/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.event.ErrorEvent;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnId;
import com.simsilica.thread.IterationProcessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import mythruna.GameConstants;
import mythruna.es.AgentType;
import mythruna.es.ObjectTypeInfo;
import mythruna.sim.GameActionSystem;
import mythruna.sim.ai.ActivationZoneListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentActivationProcessor
implements IterationProcessor {
    static Logger log = LoggerFactory.getLogger(AgentActivationProcessor.class);
    private EntityData ed;
    private PlayerContainer players;
    private AtomicInteger activePlayers = new AtomicInteger();
    private AgentContainer agents;
    private AtomicInteger activeAgents = new AtomicInteger();
    private boolean filterInvalid = true;
    private int xzRadius;
    private Map<ColumnId, Zone> zoneIndex;
    private AtomicInteger activeZones;
    private GameActionSystem gameActions;
    private List<ActivationZoneListener> listeners;

    public AgentActivationProcessor(EntityData ed, GameActionSystem gameActions, List<ActivationZoneListener> listeners) {
        this.xzRadius = GameConstants.ZONE_RADIUS.x + 1;
        this.zoneIndex = new HashMap<ColumnId, Zone>();
        this.activeZones = new AtomicInteger();
        this.ed = ed;
        this.gameActions = gameActions;
        this.listeners = listeners;
    }

    public String getDiagnostics() {
        return String.format("active players:%d, active zones:%d, active agents:%d", this.activePlayers.get(), this.activeZones.get(), this.activeAgents.get());
    }

    protected void runAction(String action, Object ... args) {
        log.info("runAction(" + action + " " + Arrays.asList(args) + ")");
        try {
            this.gameActions.spoolWorldAction(action, args);
        }
        catch (RuntimeException e) {
            log.error("Error running:" + action + " with:" + Arrays.asList(args), (Throwable)e);
        }
    }

    public void onStart() {
        this.players = new PlayerContainer(this.ed);
        this.players.start();
        this.agents = new AgentContainer(this.ed);
        this.resetZoneFilter();
        this.agents.start();
    }

    public void onIterate() {
        try {
            this.iterate();
        }
        catch (RuntimeException e) {
            log.error("Error during iteration", (Throwable)e);
            EventBus.publish((EventType)ErrorEvent.fatalError, (Object)new ErrorEvent((Throwable)e));
        }
    }

    public void onStop() {
        this.players.stop();
        this.players = null;
        this.agents.stop();
        this.agents = null;
    }

    protected void iterate() {
        if (this.players.update()) {
            this.activePlayers.set(this.players.size());
        }
        for (Player player : this.players.getArray()) {
            player.update();
        }
        if (this.filterInvalid) {
            this.resetZoneFilter();
            this.activeZones.set(this.zoneIndex.size());
        }
        if (this.agents.update()) {
            this.activeAgents.set(this.agents.size());
        }
    }

    protected void resetZoneFilter() {
        this.filterInvalid = false;
        if (this.zoneIndex.isEmpty()) {
            this.agents.setFilter(Filters.and(SpawnPosition.class, (ComponentFilter[])new ComponentFilter[]{SpawnPosition.binFilter((long)0L), SpawnPosition.binFilter((long)1L)}));
            return;
        }
        ComponentFilter[] zoneFilters = new ComponentFilter[this.zoneIndex.size()];
        int index = 0;
        for (ColumnId id : this.zoneIndex.keySet()) {
            zoneFilters[index++] = SpawnPosition.binFilter((long)id.getId());
        }
        this.agents.setFilter(Filters.or(SpawnPosition.class, (ComponentFilter[])zoneFilters));
    }

    protected Zone getZone(ColumnId columnId, boolean create) {
        Zone result = this.zoneIndex.get(columnId);
        if (result == null && create) {
            result = new Zone(this, columnId);
            this.zoneIndex.put(columnId, result);
        }
        return result;
    }

    protected void acquireZone(ColumnId columnId) {
        Zone zone;
        if (log.isTraceEnabled()) {
            log.trace("acquireZone(" + columnId + ")");
        }
        if ((zone = this.getZone(columnId, true)).acquire()) {
            this.filterInvalid = true;
            this.fireActivateZone(columnId);
        }
    }

    protected void releaseZone(ColumnId columnId) {
        Zone zone;
        if (log.isTraceEnabled()) {
            log.trace("releaseZone(" + columnId + ")");
        }
        if ((zone = this.getZone(columnId, false)) == null) {
            log.warn("deactivating non-existent zone:" + columnId);
            return;
        }
        if (zone.release()) {
            this.zoneIndex.remove(columnId);
            this.filterInvalid = true;
            this.fireDeactivateZone(columnId);
        }
    }

    protected void fireActivateZone(ColumnId columnId) {
        for (ActivationZoneListener l : this.listeners) {
            l.activateZone(columnId.getId());
        }
    }

    protected void fireDeactivateZone(ColumnId columnId) {
        for (ActivationZoneListener l : this.listeners) {
            l.deactivateZone(columnId.getId());
        }
    }

    private class PlayerContainer
    extends EntityContainer<Player> {
        public PlayerContainer(EntityData ed) {
            super(ed, new Class[]{ObjectTypeInfo.class, BodyPosition.class, ShapeInfo.class});
            this.setFilter(ObjectTypeInfo.typeFilter("PlayerCharacter", ed));
        }

        public Player[] getArray() {
            return (Player[])super.getArray();
        }

        protected Player addObject(Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("PlayerContainer.addObject(" + e.getId() + ")");
            }
            Player player = new Player(e);
            this.updateObject(player, e);
            return player;
        }

        protected void updateObject(Player player, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
        }

        protected void removeObject(Player player, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("PlayerContainer.removeObject(" + e.getId() + ")");
            }
            player.release();
        }
    }

    private class AgentContainer
    extends EntityContainer<AgentType> {
        public AgentContainer(EntityData ed) {
            super(ed, new Class[]{SpawnPosition.class, AgentType.class});
        }

        public void setFilter(ComponentFilter filter) {
            if (log.isTraceEnabled()) {
                log.trace("AgentContainer.setFilter(" + filter + ")");
            }
            super.setFilter(filter);
        }

        protected AgentType addObject(Entity e) {
            AgentType type;
            if (log.isTraceEnabled()) {
                log.trace("AgentContainer.addObject(" + e.getId() + ")");
            }
            if ((type = (AgentType)e.get(AgentType.class)).getLevel() != 0) {
                e.set((EntityComponent)type.changeLevel(0));
            }
            return type;
        }

        protected void updateObject(AgentType type, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
        }

        protected void removeObject(AgentType type, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("AgentContainer.removeObject(" + e.getId() + ")");
            }
            if (AgentActivationProcessor.this.ed.getComponent(e.getId(), AgentType.class) != null) {
                AgentActivationProcessor.this.ed.setComponent(e.getId(), (EntityComponent)type.changeLevel(2));
            }
        }
    }

    private class Player {
        private EntityId entityId;
        private BodyPosition pos;
        private Vec3i loc;
        private ColumnId columnId;
        private Set<ColumnId> zoneIds = new HashSet<ColumnId>();

        public Player(Entity entity) {
            this.entityId = entity.getId();
            this.pos = (BodyPosition)entity.get(BodyPosition.class);
        }

        protected void updateColumnId(ColumnId columnId) {
            if (columnId == null) {
                return;
            }
            if (this.columnId != null && this.columnId.getId() == columnId.getId()) {
                return;
            }
            ColumnId oldColumnId = this.columnId;
            this.columnId = columnId;
            if (log.isTraceEnabled()) {
                log.trace(this.entityId + ":updateColumnId(" + columnId + ")");
            }
            HashSet<ColumnId> newZones = new HashSet<ColumnId>();
            columnId.visitNeighbors(AgentActivationProcessor.this.xzRadius, id -> {
                newZones.add((ColumnId)id);
                if (!this.zoneIds.remove(id)) {
                    AgentActivationProcessor.this.acquireZone((ColumnId)id);
                }
            });
            for (ColumnId id2 : this.zoneIds) {
                AgentActivationProcessor.this.releaseZone(id2);
            }
            this.zoneIds = newZones;
        }

        public void update() {
            Vec3d loc = this.pos.getLastLocation();
            if (loc == null) {
                return;
            }
            Vec3i newLoc = loc.floor();
            if (newLoc.equals((Object)loc)) {
                return;
            }
            this.loc = newLoc;
            this.updateColumnId(ColumnId.fromWorld((double)loc.x, (double)loc.y, (double)loc.z));
        }

        public void release() {
            for (ColumnId columnId : this.zoneIds) {
                AgentActivationProcessor.this.releaseZone(columnId);
            }
        }
    }

    private class Zone {
        private ColumnId id;
        private int useCount = 0;

        public Zone(AgentActivationProcessor agentActivationProcessor, ColumnId id) {
            this.id = id;
        }

        public boolean acquire() {
            ++this.useCount;
            return this.useCount == 1;
        }

        public boolean release() {
            --this.useCount;
            return this.useCount <= 0;
        }
    }
}

