/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text.md;

import com.google.common.base.MoreObjects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mythruna.text.md.MdElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectiveElement
implements MdElement {
    static Logger log = LoggerFactory.getLogger(DirectiveElement.class);
    private static final Pattern DIRECTIVE = Pattern.compile("(?:\\{\\s*(.*?)\\s*\\})");
    private String directive;
    private String text;

    public DirectiveElement(String directive, String text) {
        this.directive = directive;
    }

    public static DirectiveElement matches(String line) {
        Matcher m = DIRECTIVE.matcher(line);
        if (!m.lookingAt()) {
            return null;
        }
        String s = "";
        if (m.end() < line.length()) {
            s = line.substring(m.end()).trim();
        }
        return new DirectiveElement(m.group(1), s);
    }

    @Override
    public void append(String s) {
        throw new UnsupportedOperationException("append() not supported for directive elements");
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getDirective() {
        return this.directive;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("directive", (Object)this.directive).add("text", (Object)this.text).toString();
    }
}

