/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.client;

import com.jme3.network.Client;
import com.jme3.network.Message;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.EntitySet;
import com.simsilica.es.Query;
import com.simsilica.es.StringIndex;
import com.simsilica.es.WatchedEntity;
import com.simsilica.es.base.DefaultEntity;
import com.simsilica.es.base.DefaultEntitySet;
import com.simsilica.es.base.DefaultWatchedEntity;
import com.simsilica.es.client.RemoteStringIndex;
import com.simsilica.es.net.ComponentChangeMessage;
import com.simsilica.es.net.EntityDataMessage;
import com.simsilica.es.net.EntityIdsMessage;
import com.simsilica.es.net.EntitySetErrorMessage;
import com.simsilica.es.net.FindEntitiesMessage;
import com.simsilica.es.net.FindEntityMessage;
import com.simsilica.es.net.GetComponentsMessage;
import com.simsilica.es.net.GetEntitySetMessage;
import com.simsilica.es.net.ObjectMessageDelegator;
import com.simsilica.es.net.PurgeIdsMessage;
import com.simsilica.es.net.ReleaseEntitySetMessage;
import com.simsilica.es.net.ReleaseWatchedEntityMessage;
import com.simsilica.es.net.ResetEntitySetFilterMessage;
import com.simsilica.es.net.ResultComponentsMessage;
import com.simsilica.es.net.StringIdMessage;
import com.simsilica.es.net.WatchEntityMessage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteEntityData
implements EntityData {
    static Logger log = LoggerFactory.getLogger(RemoteEntityData.class);
    private static final AtomicInteger nextSetId = new AtomicInteger();
    private static final AtomicInteger nextWatchId = new AtomicInteger();
    private static final AtomicInteger nextRequestId = new AtomicInteger();
    private final Client client;
    private final int channel;
    private volatile long lastChangeReceived;
    private final Map<Integer, PendingRequest> pendingRequests = new ConcurrentHashMap<Integer, PendingRequest>();
    private final Map<Integer, RemoteEntitySet> activeSets = new ConcurrentHashMap<Integer, RemoteEntitySet>();
    private final Map<Integer, RemoteWatchedEntity> watchedEntities = new ConcurrentHashMap<Integer, RemoteWatchedEntity>();
    private final ObjectMessageDelegator<Client> messageHandler;
    private final RemoteStringIndex strings = new RemoteStringIndex(this);

    public RemoteEntityData(Client client, int channel) {
        this.client = client;
        this.channel = channel;
        this.messageHandler = new ObjectMessageDelegator(new EntityMessageHandler(), true);
        client.addMessageListener(this.messageHandler, this.messageHandler.getMessageTypes());
    }

    public <T extends EntityComponent> T getComponent(EntityId entityId, Class<T> type) {
        if (log.isTraceEnabled()) {
            log.trace("getComponent(" + entityId + ", " + type + ")");
        }
        long latest = 0L;
        T fromCache = null;
        for (RemoteEntitySet set : this.activeSets.values()) {
            if (!set.hasType(type)) continue;
            Object value = set.checkChangeQueue(entityId, type);
            long updateTime = set.lastUpdate;
            if (value != null) {
                updateTime = this.lastChangeReceived;
            } else {
                Entity e = set.getEntity(entityId);
                if (e == null) continue;
                value = e.get(type);
            }
            if (updateTime <= latest) continue;
            latest = updateTime;
            fromCache = value;
            if (!log.isTraceEnabled()) continue;
            log.trace("Found cached component from:" + updateTime + " in set for:" + Arrays.asList(set.getTypes()));
        }
        if (fromCache != null) {
            return fromCache;
        }
        if (log.isDebugEnabled()) {
            log.debug("Retrieving component from server for:" + entityId + " type:" + type);
        }
        Entity entity = this.getEntity(entityId, type);
        return (T)entity.get(type);
    }

    public Entity getEntity(EntityId entityId, Class ... types) {
        Entity result;
        if (log.isTraceEnabled()) {
            log.trace("getEntity(" + entityId + ", " + Arrays.asList(types) + ")", new Throwable());
        }
        int id = nextRequestId.getAndIncrement();
        GetComponentsMessage msg = new GetComponentsMessage(id, entityId, types);
        msg.setReliable(true);
        PendingEntityRequest request = new PendingEntityRequest(msg);
        this.pendingRequests.put(id, request);
        this.client.send(this.channel, (Message)msg);
        try {
            result = (Entity)request.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for entity data.", e);
        }
        if (log.isTraceEnabled()) {
            log.trace("result:" + result);
        }
        return result;
    }

    public EntityId findEntity(ComponentFilter filter, Class ... types) {
        if (log.isTraceEnabled()) {
            log.trace("findEntity(" + filter + ", " + Arrays.asList(types) + ")");
        }
        return this.findEntity(new EntityCriteria().set(filter, types));
    }

    public EntityId findEntity(EntityCriteria criteria) {
        EntityId[] result;
        if (log.isTraceEnabled()) {
            log.trace("findEntity(" + criteria + ")");
        }
        int id = nextRequestId.getAndIncrement();
        FindEntityMessage msg = new FindEntityMessage(id, criteria);
        msg.setReliable(true);
        PendingEntityIdsRequest request = new PendingEntityIdsRequest((Message)msg);
        this.pendingRequests.put(id, request);
        this.client.send(this.channel, (Message)msg);
        try {
            result = (EntityId[])request.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for entity data.", e);
        }
        if (log.isTraceEnabled()) {
            EntityId returning = result != null && result.length > 0 ? result[0] : null;
            log.trace("result:" + returning);
        }
        return result != null && result.length > 0 ? result[0] : null;
    }

    public Set<EntityId> findEntities(ComponentFilter filter, Class ... types) {
        if (log.isTraceEnabled()) {
            log.trace("findEntities(" + filter + ", " + Arrays.asList(types) + ")");
        }
        return this.findEntities(new EntityCriteria().set(filter, types));
    }

    public Set<EntityId> findEntities(EntityCriteria criteria) {
        int id = nextRequestId.getAndIncrement();
        FindEntitiesMessage msg = new FindEntitiesMessage(id, criteria);
        msg.setReliable(true);
        PendingEntityIdsRequest request = new PendingEntityIdsRequest((Message)msg);
        this.pendingRequests.put(id, request);
        this.client.send(this.channel, (Message)msg);
        HashSet<EntityId> result = new HashSet<EntityId>();
        try {
            EntityId[] ids = (EntityId[])request.getResult();
            if (ids != null) {
                result.addAll(Arrays.asList(ids));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for entity data.", e);
        }
        if (log.isTraceEnabled()) {
            log.trace("result:" + result);
        }
        return result;
    }

    public Query createQuery(final EntityCriteria criteria) {
        return new Query(){

            public Set<EntityId> execute() {
                return RemoteEntityData.this.findEntities(criteria);
            }

            public EntityId findFirst() {
                return RemoteEntityData.this.findEntity(criteria);
            }
        };
    }

    public <T extends EntityComponent> Query createQuery(final ComponentFilter<T> filter, final Class<T> type) {
        return new Query(){

            public Set<EntityId> execute() {
                return RemoteEntityData.this.findEntities(filter, type);
            }

            public EntityId findFirst() {
                return RemoteEntityData.this.findEntity(filter, type);
            }
        };
    }

    public EntitySet getEntities(Class ... types) {
        return this.getEntities(new EntityCriteria().add(types));
    }

    public EntitySet getEntities(ComponentFilter filter, Class ... types) {
        return this.getEntities(new EntityCriteria().set(filter, types));
    }

    public EntitySet getEntities(EntityCriteria criteria) {
        if (log.isTraceEnabled()) {
            log.trace("getEntities(" + criteria + ")");
        }
        int id = nextSetId.getAndIncrement();
        RemoteEntitySet result = new RemoteEntitySet(id, criteria);
        this.activeSets.put(id, result);
        GetEntitySetMessage m = new GetEntitySetMessage(id, criteria);
        m.setReliable(true);
        this.client.send(this.channel, (Message)m);
        if (log.isTraceEnabled()) {
            log.trace("result:" + (Object)((Object)result));
        }
        return result;
    }

    public WatchedEntity watchEntity(EntityId entityId, Class ... types) {
        WatchedEntity result;
        int watchId = nextWatchId.getAndIncrement();
        int msgId = nextRequestId.getAndIncrement();
        WatchEntityMessage msg = new WatchEntityMessage(msgId, watchId, entityId, types);
        msg.setReliable(true);
        PendingWatchEntityRequest request = new PendingWatchEntityRequest(msg);
        this.pendingRequests.put(msgId, request);
        this.client.send(this.channel, (Message)msg);
        try {
            result = (WatchedEntity)request.getResult();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for watched entity data.", e);
        }
        if (log.isTraceEnabled()) {
            log.trace("result:" + result);
        }
        return result;
    }

    public void close() {
        this.client.removeMessageListener(this.messageHandler, this.messageHandler.getMessageTypes());
    }

    protected StringIdMessage getStringResponse(StringIdMessage msg) {
        int id = msg.getRequestId();
        msg.setReliable(true);
        PendingStringRequest request = new PendingStringRequest((Message)msg);
        this.pendingRequests.put(id, request);
        this.client.send(this.channel, (Message)msg);
        try {
            return (StringIdMessage)((Object)request.getResult());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for string data.", e);
        }
    }

    protected Integer getStringId(String s) {
        return this.getStringResponse(new StringIdMessage(nextRequestId.getAndIncrement(), s)).getId();
    }

    protected String getString(int id) {
        return this.getStringResponse(new StringIdMessage(nextRequestId.getAndIncrement(), id)).getString();
    }

    public StringIndex getStrings() {
        return this.strings;
    }

    public EntityId createEntity() {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    public void removeEntity(EntityId entityId) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    public void setComponent(EntityId entityId, EntityComponent component) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    public void setComponents(EntityId entityId, EntityComponent ... components) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    public boolean removeComponent(EntityId entityId, Class type) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    public void removeComponents(EntityId entityId, Class ... types) {
        throw new UnsupportedOperationException("RemoteEntityData is read-only.");
    }

    protected void entityChange(EntityChange change) {
        for (RemoteEntitySet set : this.activeSets.values()) {
            set.entityChange(change);
        }
        for (RemoteWatchedEntity e : this.watchedEntities.values()) {
            e.addChange(change);
        }
    }

    protected class PendingStringRequest
    extends PendingRequest<StringIdMessage, StringIdMessage> {
        public PendingStringRequest(Message request) {
            super(request);
        }

        @Override
        public void dataReceived(StringIdMessage m) {
            this.setResult(m);
        }
    }

    protected class PendingEntityIdsRequest
    extends PendingRequest<EntityIdsMessage, EntityId[]> {
        public PendingEntityIdsRequest(Message request) {
            super(request);
        }

        @Override
        public void dataReceived(EntityIdsMessage m) {
            this.setResult(m.getIds());
        }
    }

    protected class PendingWatchEntityRequest
    extends PendingRequest<ResultComponentsMessage, WatchedEntity> {
        public PendingWatchEntityRequest(WatchEntityMessage request) {
            super((Message)request);
        }

        @Override
        public void dataReceived(ResultComponentsMessage m) {
            RemoteWatchedEntity e = new RemoteWatchedEntity(RemoteEntityData.this, ((WatchEntityMessage)this.request).getWatchId(), m.getEntityId(), m.getComponents(), ((WatchEntityMessage)this.request).getComponentTypes());
            this.setResult(e);
        }
    }

    protected class PendingEntityRequest
    extends PendingRequest<ResultComponentsMessage, Entity> {
        public PendingEntityRequest(GetComponentsMessage request) {
            super((Message)request);
        }

        @Override
        public void dataReceived(ResultComponentsMessage m) {
            DefaultEntity e = new DefaultEntity((EntityData)RemoteEntityData.this, m.getEntityId(), m.getComponents(), ((GetComponentsMessage)this.request).getComponentTypes());
            this.setResult(e);
        }
    }

    protected abstract class PendingRequest<M, T> {
        protected Message request;
        private final AtomicReference<T> result = new AtomicReference();
        private final CountDownLatch received = new CountDownLatch(1);

        protected PendingRequest(Message request) {
            this.request = request;
        }

        public boolean isDone() {
            return this.result.get() != null;
        }

        public void close() {
            this.received.countDown();
        }

        protected void setResult(T val) {
            this.result.set(val);
            this.received.countDown();
        }

        public abstract void dataReceived(M var1);

        public T getResult() throws InterruptedException {
            this.received.await();
            return this.result.get();
        }

        public String toString() {
            return "PendingRequest[" + this.request + "]";
        }
    }

    private class EntityMessageHandler {
        private EntityMessageHandler() {
        }

        public void entityComponents(ResultComponentsMessage msg) {
            PendingRequest request;
            if (log.isTraceEnabled()) {
                log.trace("entityComponents(" + (Object)((Object)msg) + ")");
            }
            if ((request = (PendingRequest)RemoteEntityData.this.pendingRequests.remove(msg.getRequestId())) == null) {
                log.error("Received component data but no request is pending, id:" + msg.getRequestId());
                return;
            }
            request.dataReceived(msg);
        }

        public void entityData(EntityDataMessage msg) {
            RemoteEntitySet set;
            if (log.isTraceEnabled()) {
                log.trace("entityData(" + (Object)((Object)msg) + ")");
            }
            if ((set = (RemoteEntitySet)((Object)RemoteEntityData.this.activeSets.get(msg.getSetId()))) == null) {
                log.warn("entityData() Set not found for ID:" + msg.getSetId() + "  May have been released.");
                return;
            }
            for (EntityDataMessage.ComponentData d : msg.getData()) {
                if (log.isTraceEnabled()) {
                    log.trace("ComponentData for:" + msg.getSetId() + " :" + d);
                }
                DefaultEntity e = new DefaultEntity((EntityData)RemoteEntityData.this, d.getEntityId(), d.getComponents(), (Class[])set.getTypes());
                set.directAdd(e);
            }
        }

        public void componentChange(ComponentChangeMessage msg) {
            if (log.isTraceEnabled()) {
                log.trace("componentChange(" + (Object)((Object)msg) + ")");
            }
            for (EntityChange c : msg.getData()) {
                RemoteEntityData.this.entityChange(c);
            }
        }

        public void entityIds(EntityIdsMessage msg) {
            PendingRequest request;
            if (log.isTraceEnabled()) {
                log.trace("entityIds(" + (Object)((Object)msg) + ")");
            }
            if ((request = (PendingRequest)RemoteEntityData.this.pendingRequests.remove(msg.getRequestId())) == null) {
                log.error("Received result entity IDs but no request is pending, id:" + msg.getRequestId());
                return;
            }
            request.dataReceived(msg);
        }

        public void stringId(StringIdMessage msg) {
            PendingRequest request;
            if (log.isTraceEnabled()) {
                log.trace("stringId(" + (Object)((Object)msg) + ")");
            }
            if ((request = (PendingRequest)RemoteEntityData.this.pendingRequests.remove(msg.getRequestId())) == null) {
                log.error("Received result string ID message but no request is pending, id:" + msg.getRequestId());
                return;
            }
            request.dataReceived(msg);
        }

        public void entitySetError(EntitySetErrorMessage msg) {
            RemoteEntitySet set;
            if (log.isTraceEnabled()) {
                log.trace("entitySetError(" + (Object)((Object)msg) + ")");
            }
            if ((set = (RemoteEntitySet)((Object)RemoteEntityData.this.activeSets.get(msg.getSetId()))) == null) {
                log.warn("entitySetError() Set not found for ID:" + msg.getSetId() + "  May have been released.");
                return;
            }
            set.setError(msg.getError());
        }

        public void purgeIds(PurgeIdsMessage msg) {
            if (log.isTraceEnabled()) {
                log.trace("purgeIds(" + (Object)((Object)msg) + ")");
            }
            log.info("purgeIds(" + (Object)((Object)msg) + ")");
            RemoteEntitySet set = (RemoteEntitySet)((Object)RemoteEntityData.this.activeSets.get(msg.getSetId()));
            if (set == null) {
                log.warn("purgedIds() Set not found for ID:" + msg.getSetId() + "  May have been released.");
                return;
            }
            for (EntityId id : msg.getIds()) {
                set.directPurge(id);
            }
        }
    }

    private class RemoteWatchedEntity
    extends DefaultWatchedEntity {
        private final int watchId;

        public RemoteWatchedEntity(EntityData ed, int watchId, EntityId id, EntityComponent[] components, Class<EntityComponent>[] types) {
            super(ed, id, components, (Class[])types);
            this.watchId = watchId;
            RemoteEntityData.this.watchedEntities.put(watchId, this);
        }

        public void release() {
            if (this.isReleased()) {
                return;
            }
            super.release();
            if (log.isDebugEnabled()) {
                log.debug("Releasing watched entity:" + this.watchId);
            }
            RemoteEntityData.this.watchedEntities.remove(this.watchId);
            if (RemoteEntityData.this.client.isConnected()) {
                ReleaseWatchedEntityMessage msg = new ReleaseWatchedEntityMessage(this.watchId);
                RemoteEntityData.this.client.send(RemoteEntityData.this.channel, (Message)msg);
            }
        }

        protected void addChange(EntityChange change) {
            super.addChange(change);
        }
    }

    private class RemoteEntitySet
    extends DefaultEntitySet {
        private final int setId;
        private final ConcurrentLinkedQueue<DefaultEntity> directAdds;
        private final ConcurrentLinkedQueue<EntityId> directPurges;
        private long lastUpdate;
        private String error;

        public RemoteEntitySet(int setId, ComponentFilter filter, Class<? extends EntityComponent>[] types) {
            this(setId, new EntityCriteria().set(filter, (Class[])types));
        }

        public RemoteEntitySet(int setId, EntityCriteria criteria) {
            super((EntityData)RemoteEntityData.this, criteria);
            this.directAdds = new ConcurrentLinkedQueue();
            this.directPurges = new ConcurrentLinkedQueue();
            this.setId = setId;
        }

        protected void directPurge(EntityId id) {
            this.directPurges.add(id);
        }

        protected void setError(String error) {
            this.error = error;
        }

        protected void checkError() {
            if (this.error != null) {
                String msg = "Server error received:\n" + this.error;
                this.error = null;
                throw new IllegalStateException(msg);
            }
        }

        public void release() {
            if (this.isReleased()) {
                return;
            }
            super.release();
            if (log.isDebugEnabled()) {
                log.debug("Releasing set:" + this.setId);
            }
            RemoteEntityData.this.activeSets.remove(this.setId);
            if (RemoteEntityData.this.client.isConnected()) {
                ReleaseEntitySetMessage msg = new ReleaseEntitySetMessage(this.setId);
                RemoteEntityData.this.client.send(RemoteEntityData.this.channel, (Message)msg);
            }
        }

        public String debugId() {
            return "RemoteEntitySet@" + this.setId;
        }

        protected void loadEntities(boolean reload) {
            this.checkError();
        }

        protected void filtersChanged() {
            this.checkError();
            ResetEntitySetFilterMessage m = new ResetEntitySetFilterMessage(this.setId, this.getCriteria());
            m.setReliable(true);
            if (log.isDebugEnabled()) {
                log.debug("Sending filter reset:" + (Object)((Object)m));
            }
            RemoteEntityData.this.client.send(RemoteEntityData.this.channel, (Message)m);
        }

        protected boolean applyChanges(Set<EntityChange> updates, boolean clearChangeSets) {
            this.checkError();
            if (super.applyChanges(updates, clearChangeSets)) {
                this.lastUpdate = System.nanoTime();
                return true;
            }
            return false;
        }

        protected boolean buildTransactionChanges(Set<EntityChange> updates) {
            boolean directMods = false;
            if (!this.directAdds.isEmpty()) {
                while (!this.directAdds.isEmpty()) {
                    DefaultEntity d = this.directAdds.poll();
                    this.transaction.directAdd(d);
                    directMods = true;
                }
            }
            if (!this.directPurges.isEmpty()) {
                while (!this.directPurges.isEmpty()) {
                    EntityId id = this.directPurges.poll();
                    this.transaction.directPurge(id);
                    directMods = true;
                }
            }
            if (super.buildTransactionChanges(updates)) {
                return true;
            }
            return directMods;
        }

        protected void directAdd(DefaultEntity e) {
            this.directAdds.add(e);
        }

        protected boolean completeEntity(DefaultEntity e) {
            ComponentFilter[] filters = this.getFilters();
            EntityComponent[] array = e.getComponents();
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null || array[i] == REMOVED_COMPONENT) {
                    if (log.isTraceEnabled()) {
                        log.trace("Entity is missing type " + this.getTypes()[i] + " so is not complete for this set.");
                    }
                    return false;
                }
                ComponentFilter filter = filters[i];
                if (filter == null || filter.evaluate(array[i])) continue;
                return false;
            }
            return true;
        }

        protected void entityChange(EntityChange change) {
            RemoteEntityData.this.lastChangeReceived = System.nanoTime();
            super.entityChange(change);
        }

        protected Class<? extends EntityComponent>[] getTypes() {
            return super.getTypes();
        }

        protected <T extends EntityComponent> T checkChangeQueue(EntityId id, Class<T> type) {
            EntityComponent result = null;
            for (EntityChange change : this.getChangeQueue()) {
                if (type != change.getComponentType() || !Objects.equals(id, change.getEntityId())) continue;
                result = (EntityComponent)type.cast(change.getComponent());
            }
            return (T)result;
        }
    }
}

