/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.event;

import com.simsilica.event.ErrorEvent;
import com.simsilica.event.EventAbortedException;
import com.simsilica.event.EventListener;
import com.simsilica.event.EventType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus {
    static Logger log = LoggerFactory.getLogger(EventBus.class);
    private static final EventBus instance = new EventBus();
    private final ListenerList all = new ListenerList();
    private final Map<EventType, ListenerList> listenerMap = new ConcurrentHashMap<EventType, ListenerList>();
    private final Lock lock = new ReentrantLock();

    protected EventBus() {
    }

    public static <E> void publish(EventType<E> type, E event) {
        EventBus.getInstance().publishEvent(type, event);
    }

    public static void addListener(Object listener, EventType ... types) {
        EventBus.getInstance().addListenerMethods(listener, types);
    }

    public static void removeListener(Object listener, EventType ... types) {
        EventBus.getInstance().removeListenerMethods(listener, types);
    }

    public static <E> void addListener(EventType<E> type, EventListener<E> listener) {
        EventBus.getInstance().addEventListener(type, listener);
    }

    public static <E> void removeListener(EventType<E> type, EventListener<E> listener) {
        EventBus.getInstance().removeEventListener(type, listener);
    }

    public <E> void publishEvent(EventType<E> type, E event) {
        if (log.isTraceEnabled()) {
            log.trace("publishEvent(" + type + ", " + event + ")");
        }
        this.deliver(null, event, this.all);
        boolean delivered = this.deliver(type, event, this.getListeners(type));
        if (!delivered) {
            log.debug("Undelivered event type:" + type + "  Event:" + event);
        }
    }

    protected <E> boolean deliver(EventType<E> type, E event, ListenerList listeners) {
        if (listeners.isEmpty()) {
            return false;
        }
        boolean delivered = false;
        for (EventListener l : listeners.getArray()) {
            try {
                l.newEvent(type, event);
                delivered = true;
            }
            catch (EventAbortedException e) {
                log.error("Event aborted:" + event + " for type:" + type + " at handler:" + l, (Throwable)e);
                throw e;
            }
            catch (Throwable t) {
                log.error("Error handling event:" + event + " for type:" + type + "  in handler:" + l, t);
                if (type == ErrorEvent.dispatchError) continue;
                this.publishEvent(ErrorEvent.dispatchError, new ErrorEvent(t, type, event));
            }
        }
        return delivered;
    }

    public static EventBus getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenerList getListeners(EventType type) {
        ListenerList list = this.listenerMap.get(type);
        if (list == null) {
            this.lock.lock();
            try {
                list = this.listenerMap.get(type);
                if (list != null) {
                    ListenerList listenerList = list;
                    return listenerList;
                }
                list = new ListenerList();
                this.listenerMap.put(type, list);
            }
            finally {
                this.lock.unlock();
            }
        }
        return list;
    }

    public <E> void addEventListener(EventType<E> type, EventListener<E> listener) {
        this.getListeners(type).add(listener);
    }

    public <E> void removeEventListener(EventType<E> type, EventListener<E> listener) {
        this.getListeners(type).remove(listener);
    }

    public void addDispatchListener(EventListener listener) {
        this.all.add(listener);
    }

    public void removeDispatchListener(EventListener listener) {
        this.all.remove(listener);
    }

    protected Method findMethod(Class c, EventType type) throws NoSuchMethodException {
        String name1 = "on" + type.getName();
        try {
            return c.getDeclaredMethod(name1, type.getEventClass());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String name2 = type.getName();
            if (Character.isUpperCase(name2.charAt(0)) && Character.isLowerCase(name2.charAt(1))) {
                name2 = Character.toLowerCase(name2.charAt(0)) + name2.substring(1);
            }
            try {
                return c.getDeclaredMethod(name2, type.getEventClass());
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                if (c.getSuperclass() != null) {
                    return this.findMethod(c.getSuperclass(), type);
                }
                throw new NoSuchMethodException(c.getName() + "." + name1 + "(" + type.getEventClass().getName() + ") or " + c.getName() + "." + name2 + "(" + type.getEventClass().getName() + ")");
            }
        }
    }

    public void addListenerMethods(Object listener, EventType ... types) {
        Class<?> c = listener.getClass();
        for (EventType type : types) {
            try {
                Method m = this.findMethod(c, type);
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                this.getListeners(type).add(new MethodDispatcher(listener, m));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Event method not found for:" + type + " on object:" + listener, e);
            }
        }
    }

    public void removeListenerMethods(Object listener, EventType ... types) {
        for (EventType type : types) {
            ListenerList listeners = this.getListeners(type);
            for (EventListener l : listeners.getArray()) {
                MethodDispatcher md;
                if (!(l instanceof MethodDispatcher) || (md = (MethodDispatcher)l).delegate != listener && !md.delegate.equals(listener)) continue;
                this.removeEventListener(type, md);
            }
        }
    }

    private class ListenerList {
        private final List<EventListener> list = new ArrayList<EventListener>();
        private volatile EventListener[] array = null;

        public ListenerList() {
            this.resetArray();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        protected final void resetArray() {
            this.array = this.list.toArray(new EventListener[this.list.size()]);
        }

        protected final EventListener[] getArray() {
            return this.array;
        }

        public void add(EventListener listener) {
            EventBus.this.lock.lock();
            try {
                this.list.add(listener);
                this.resetArray();
            }
            finally {
                EventBus.this.lock.unlock();
            }
        }

        public void remove(EventListener listener) {
            EventBus.this.lock.lock();
            try {
                this.list.remove(listener);
                this.resetArray();
            }
            finally {
                EventBus.this.lock.unlock();
            }
        }
    }

    private class MethodDispatcher
    implements EventListener {
        private Object delegate;
        private Method method;

        public MethodDispatcher(Object delegate, Method m) {
            if (m == null) {
                throw new IllegalArgumentException("Method cannot be null.");
            }
            this.delegate = delegate;
            this.method = m;
        }

        public void newEvent(EventType type, Object event) {
            try {
                this.method.invoke(this.delegate, event);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException("Error calling:" + this.method + " for event:" + event, ex);
            }
        }
    }
}

