/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCriteria
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(EntityCriteria.class);
    private Map<Class<? extends EntityComponent>, ComponentFilter> criteria = new LinkedHashMap<Class<? extends EntityComponent>, ComponentFilter>();

    public EntityCriteria clone() {
        try {
            EntityCriteria result = (EntityCriteria)super.clone();
            result.criteria = new LinkedHashMap<Class<? extends EntityComponent>, ComponentFilter>(this.criteria);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone", e);
        }
    }

    public EntityCriteria set(ComponentFilter filter, Class ... types) {
        this.criteria.clear();
        for (Class t : types) {
            if (filter != null && filter.getComponentType() == t) {
                this.criteria.put(t, filter);
                continue;
            }
            this.criteria.put(t, null);
        }
        return this;
    }

    public EntityCriteria set(Class<? extends EntityComponent>[] types, ComponentFilter[] filters) {
        this.criteria.clear();
        for (int i = 0; i < types.length; ++i) {
            Class<? extends EntityComponent> type = types[i];
            ComponentFilter filter = filters[i];
            if (filter != null && filter.getComponentType() != type) {
                throw new IllegalArgumentException("Type:" + type + " does not match filter:" + filter + " at index:" + i);
            }
            this.criteria.put(type, filter);
        }
        return this;
    }

    public EntityCriteria add(ComponentFilter ... filters) {
        for (ComponentFilter f : filters) {
            this.add(f.getComponentType(), f);
        }
        return this;
    }

    @SafeVarargs
    public final EntityCriteria add(Class<? extends EntityComponent> ... types) {
        for (Class<? extends EntityComponent> type : types) {
            this.add((Class)type, (ComponentFilter)null);
        }
        return this;
    }

    public <T extends EntityComponent> EntityCriteria setFilter(Class<T> type, ComponentFilter<T> filter) {
        this.criteria.put(type, filter);
        return this;
    }

    public void clearFilters() {
        for (Map.Entry<Class<? extends EntityComponent>, ComponentFilter> e : this.criteria.entrySet()) {
            e.setValue(null);
        }
    }

    public Collection<ComponentFilter> getFilters() {
        return Collections.unmodifiableCollection(this.criteria.values());
    }

    public Set<Class<? extends EntityComponent>> getComponentTypes() {
        return Collections.unmodifiableSet(this.criteria.keySet());
    }

    protected EntityCriteria add(Class type, ComponentFilter filter) {
        if (this.criteria.containsKey(type)) {
            throw new IllegalArgumentException("Type already defined:" + type);
        }
        this.criteria.put(type, filter);
        return this;
    }

    public Class<? extends EntityComponent>[] toTypeArray() {
        return this.criteria.keySet().toArray(new Class[0]);
    }

    public ComponentFilter[] toFilterArray() {
        return this.criteria.values().toArray(new ComponentFilter[0]);
    }

    public boolean isMatchingComponent(EntityComponent c) {
        if (!this.hasType(c.getClass())) {
            return false;
        }
        ComponentFilter filter = this.criteria.get(c.getClass());
        return filter == null || filter.evaluate(c);
    }

    public final boolean hasType(Class<? extends EntityComponent> type) {
        return this.criteria.containsKey(type);
    }

    public int hashCode() {
        return this.criteria.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        EntityCriteria other = (EntityCriteria)o;
        return other.criteria.equals(this.criteria);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.criteria;
    }
}

