/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.util.SafeArrayList;
import com.simsilica.mod.FileModPack;
import com.simsilica.mod.ModManager;
import java.io.File;
import mythruna.client.PerspectiveGuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrototypeModManagerState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PrototypeModManagerState.class);
    private File modRoot = new File("prototype-mods");
    private ModManager modManager;
    private SafeArrayList<FileModPack> fileMods = new SafeArrayList(FileModPack.class);
    private float refreshInterval = 1.0f;
    private float nextUpdate;

    public PrototypeModManagerState() {
        this.modManager = new ModManager();
    }

    public ModManager getModManager() {
        return this.modManager;
    }

    protected void loadModFiles() {
        for (File f : this.modRoot.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".mod.json")) continue;
            this.fileMods.add((Object)this.modManager.loadModPack(f));
        }
    }

    protected void initialize(Application app) {
        this.modManager.loadFromResource("/mythruna/base-includes.json");
        if (this.modRoot.exists()) {
            this.loadModFiles();
        }
        this.modManager.setGlobalBinding("app", (Object)app);
        this.modManager.setGlobalBinding("gui", (Object)((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot());
        this.modManager.setGlobalBinding("glassRoot", (Object)((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRawGlassRoot());
        this.modManager.setGlobalBinding("prototypeState", (Object)this);
        this.modManager.setGlobalBinding("stateManager", (Object)app.getStateManager());
        this.modManager.initialize();
    }

    protected void cleanup(Application app) {
        this.modManager.terminate();
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        this.nextUpdate += tpf;
        if (this.nextUpdate > this.refreshInterval) {
            this.nextUpdate = 0.0f;
            this.checkMods();
        }
    }

    protected void checkMods() {
        for (FileModPack mod : (FileModPack[])this.fileMods.getArray()) {
            if (!mod.hasChanged()) continue;
            log.info("Reloading:" + mod);
            mod.reload();
        }
    }
}

