/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.bp;

import com.google.common.collect.Ordering;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.MatParamOverride;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shader.VarType;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.list.DefaultCellRenderer;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.geom.GeometryFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.HelpPopup;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.SpatialComponent;
import mythruna.client.ui.bp.BlueprintEditorState;
import mythruna.es.BlueprintInfo;
import mythruna.es.ObjectName;
import mythruna.net.BlueprintData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintSelectorState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(BlueprintSelectorState.class);
    private GameSessionState sessionState;
    private EntityData ed;
    private EntityId player;
    private GeometryFactory geomFactory;
    private Predicate<Geometry> carveIncludes;
    private Container window;
    private ActionButton editButton;
    private ActionButton copyButton;
    private ActionButton deleteButton;
    private BlueprintContainer blueprints;
    private VersionedList<Blueprint> blueprintModel = new VersionedList();
    private ListBox<Blueprint> blueprintList;
    private VersionedReference<Integer> selectionRef;
    private Blueprint selectedBlueprint;
    private BlueprintData editing = null;
    private HelpPopup help;

    public BlueprintSelectorState() {
        this.setEnabled(false);
    }

    protected void resetEditing() {
        if (this.editing == null) {
            ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot().attachChild((Spatial)this.window);
            ((BlueprintEditorState)this.getState(BlueprintEditorState.class)).setEnabled(false);
        } else {
            ((BlueprintEditorState)this.getState(BlueprintEditorState.class)).editBlueprint(this.editing);
            this.window.removeFromParent();
        }
    }

    protected void newBlueprint() {
        this.editing = new BlueprintData(null, "New Blueprint", "Object", 0.25, new Vec3i(), new CellArray(20), false);
        this.resetEditing();
    }

    protected void editBlueprint() {
        if (this.selectedBlueprint == null) {
            return;
        }
        if (this.selectedBlueprint.cellArray == null) {
            log.error("Blueprint array is null:" + this.selectedBlueprint);
            ((GuiState)this.getState(GuiState.class)).showError("Invalid Blueprint", "Selected blueprint has no cell data.", null);
            return;
        }
        BlueprintInfo info = this.selectedBlueprint.bpInfo;
        String bpName = info.getName();
        String objectName = this.selectedBlueprint.objectName.getName(this.ed);
        this.editing = new BlueprintData(this.selectedBlueprint.entity.getId(), bpName, objectName, 0.25, info.getOffset(), this.selectedBlueprint.cellArray, this.selectedBlueprint.carved);
        this.resetEditing();
    }

    protected void copyBlueprint() {
        if (this.selectedBlueprint == null) {
            return;
        }
        BlueprintInfo info = this.selectedBlueprint.bpInfo;
        String bpName = info.getName() + " Copy";
        String objectName = this.selectedBlueprint.objectName.getName(this.ed);
        this.editing = new BlueprintData(null, bpName, objectName, 0.25, info.getOffset(), this.selectedBlueprint.cellArray, this.selectedBlueprint.carved);
        this.resetEditing();
    }

    protected void deleteBlueprint() {
        if (this.selectedBlueprint == null) {
            return;
        }
        BlueprintInfo info = this.selectedBlueprint.bpInfo;
        ((OptionPanelState)this.getState(OptionPanelState.class)).show("Delete Blueprint?", "Really delete " + info.getName() + "?", new Action[]{new CallMethodAction("Delete", (Object)this, "doDelete"), new EmptyAction("Cancel")});
    }

    protected void doDelete() {
        this.sessionState.getGameSession().runAction(this.player, "deleteBlueprint", new Object[]{this.selectedBlueprint.entity.getId()});
    }

    protected void saveEdit(BlueprintData blueprint, boolean close) {
        this.sessionState.getGameSession().saveBlueprintData(blueprint);
        if (close) {
            this.editing = null;
            this.resetEditing();
        }
    }

    protected void cancelEdit() {
        this.editing = null;
        this.resetEditing();
    }

    protected void initialize(Application app) {
        this.sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = this.sessionState.getEntityData();
        this.player = this.sessionState.getGameSession().getAvatar();
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getModelGeometryFactory();
        this.carveIncludes = ((GameSessionState)this.getState(GameSessionState.class, true)).getCarveIncludes();
        this.blueprints = new BlueprintContainer(this.player, this.ed);
        this.window = new Container(new ElementId("window"));
        this.window.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.window.addChild((Node)new Label("Temporary Blueprint Selector", new ElementId("window.title")), new Object[0]);
        this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "newBlueprint")), new Object[0]);
        this.window.addChild((Node)new Label("Your Blueprints:"), new Object[0]);
        this.blueprintList = (ListBox)this.window.addChild((Node)new ListBox(this.blueprintModel), new Object[0]);
        this.blueprintList.setCellRenderer((ValueRenderer)new DefaultCellRenderer<Blueprint>(this){

            public Panel getView(Blueprint bp, boolean selected, Panel existing) {
                existing = super.getView((Object)bp, selected, existing);
                Button b = (Button)existing;
                b.setTextVAlignment(VAlignment.Center);
                SpatialComponent spatialComponent = new SpatialComponent((Spatial)bp.model);
                spatialComponent.setMargin(15.0f, 5.0f, 0.0f);
                spatialComponent.setMaxSize(50.0, 50.0, 50.0);
                spatialComponent.setHAlignment(HAlignment.Right);
                b.setIcon((GuiComponent)spatialComponent);
                return b;
            }
        });
        this.selectionRef = this.blueprintList.getSelectionModel().createSelectionReference();
        this.editButton = (ActionButton)this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "editBlueprint")), new Object[0]);
        this.editButton.setEnabled(false);
        this.copyButton = (ActionButton)this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "copyBlueprint")), new Object[0]);
        this.copyButton.setEnabled(false);
        this.deleteButton = (ActionButton)this.window.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "deleteBlueprint")), new Object[0]);
        this.deleteButton.setEnabled(false);
        this.help = new HelpPopup((Spatial)this.window, ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class))::getGuiLocation, "Blueprints");
        this.help.setText("Select 'New Blueprint' to create a new blueprint.", "", "Select an existing blue print and click 'Edit' or", "'Copy' to edit that blueprint or a copy of that", "blueprint.", "", "To use a blueprint in the world, open the player", "inventory (i) and equip the Object Tool.", "With the Object Tool equipped, the mouse wheel will", "select a blueprint for placing in the world. The", "selected blueprint will appear at the bottom center", "of the screen.");
        ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu("Blueprints", (AppState)this);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.blueprints.start();
        this.updateDialogPosition();
        this.resetEditing();
        this.help.attach();
    }

    public void update(float tpf) {
        boolean invalid = false;
        if (this.blueprints.update()) {
            invalid = true;
        }
        if (this.selectionRef.update()) {
            this.updateSelection();
            invalid = true;
        }
        this.updateDialogPosition();
    }

    protected void onDisable() {
        this.help.detach();
        this.blueprints.stop();
        this.window.removeFromParent();
        this.blueprintModel.clear();
    }

    protected void updateDialogPosition() {
        Vector2f screen = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize();
        Vector3f pref = this.window.getSize();
        this.window.setLocalTranslation(screen.x * 0.5f - pref.x - 0.5f, screen.y * 0.5f + pref.y * 0.5f, 0.0f);
    }

    protected void updateSelection() {
        log.info("updateSelection() to:" + this.blueprintList.getSelectedItem());
        Blueprint bp = (Blueprint)this.blueprintList.getSelectedItem();
        if (bp == this.selectedBlueprint) {
            return;
        }
        this.selectedBlueprint = bp;
        this.editButton.setEnabled(this.selectedBlueprint != null);
        this.copyButton.setEnabled(this.selectedBlueprint != null);
        this.deleteButton.setEnabled(this.selectedBlueprint != null);
    }

    protected void resetSelection() {
        log.info("resetSelection()");
        Integer index = this.blueprintList.getSelectionModel().getSelection();
        log.info("Existing index:" + index);
        if (index == null) {
            return;
        }
        this.blueprintList.getSelectionModel().clear();
        this.blueprintList.getSelectionModel().setSelection(index);
    }

    private class Blueprint {
        private Entity entity;
        private BlueprintInfo bpInfo;
        private ObjectName objectName;
        private ShapeInfo shape;
        private boolean carved;
        private CellArrayId cellArrayId;
        private CellArray cellArray;
        private Node model;

        public Blueprint(Entity entity) {
            this.entity = entity;
            this.model = new Node("model:" + entity.getId());
            this.model.setLocalScale(10.0f);
        }

        public void update() {
            this.bpInfo = (BlueprintInfo)this.entity.get(BlueprintInfo.class);
            this.objectName = (ObjectName)this.entity.get(ObjectName.class);
            this.shape = (ShapeInfo)this.entity.get(ShapeInfo.class);
            this.model.setName("model:" + this.entity.getId() + ", " + this.bpInfo.getName());
            String shapeId = this.shape.getShapeName(BlueprintSelectorState.this.ed);
            if (shapeId.startsWith("c_")) {
                shapeId = shapeId.substring(2);
                this.carved = true;
            }
            log.info("shapeId:" + shapeId);
            CellArrayId id = shapeId.endsWith(".ca") ? CellArrayId.fromFileName((String)shapeId) : null;
            if (!Objects.equals(this.cellArrayId, id)) {
                this.cellArrayId = id;
                if (this.cellArrayId != null) {
                    this.cellArray = BlueprintSelectorState.this.sessionState.getGameSession().getCellArray(this.cellArrayId);
                    BlueprintSelectorState.this.geomFactory.generateBlocks(this.model, this.cellArray, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
                    if (this.carved) {
                        this.model.addMatParamOverride(new MatParamOverride(VarType.Float, "CarveScale", (Object)Float.valueOf(4.0f)));
                    }
                } else {
                    this.cellArray = null;
                }
            }
        }

        public String toString() {
            return this.bpInfo.getName();
        }
    }

    private class BlueprintContainer
    extends EntityContainer<Blueprint> {
        private Comparator<? super Blueprint> comparator;

        public BlueprintContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{BlueprintInfo.class, ShapeInfo.class, ObjectName.class});
            this.comparator = Ordering.usingToString();
            ComponentFilter filter = Filters.fieldEquals(BlueprintInfo.class, (String)"parent", (Object)player);
            this.setFilter(filter);
        }

        protected Blueprint addObject(Entity e) {
            log.info("addObject(" + e + ")");
            Blueprint object = new Blueprint(e);
            this.updateObject(object, e);
            if (this.comparator != null) {
                int index = Collections.binarySearch(BlueprintSelectorState.this.blueprintModel, object, this.comparator);
                if (index < 0) {
                    index = -(index + 1);
                }
                BlueprintSelectorState.this.blueprintModel.add(index, (Object)object);
            } else {
                BlueprintSelectorState.this.blueprintModel.add((Object)object);
            }
            BlueprintSelectorState.this.resetSelection();
            return object;
        }

        protected void updateObject(Blueprint object, Entity e) {
            object.update();
        }

        protected void removeObject(Blueprint object, Entity e) {
            BlueprintSelectorState.this.blueprintModel.remove((Object)object);
            BlueprintSelectorState.this.resetSelection();
        }
    }
}

