/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.PersistentComponent;
import com.simsilica.es.StringType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterName
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(CharacterName.class);
    @StringType(maxLength=40)
    private String first;
    @StringType(maxLength=40)
    private String last;

    public CharacterName() {
    }

    public CharacterName(String first, String last) {
        if (first != null && first.length() > 40) {
            throw new IllegalArgumentException("First name cannot exceed 40 characters");
        }
        if (last != null && last.length() > 40) {
            throw new IllegalArgumentException("Last name cannot exceed 40 characters");
        }
        if (first == null && last == null) {
            throw new IllegalArgumentException("Must have at least a first or last name");
        }
        this.first = first;
        this.last = last;
    }

    public String getFirstName() {
        return this.first;
    }

    public String getLastName() {
        return this.last;
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        if (this.first != null) {
            sb.append(this.first);
        }
        if (this.last != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.last);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CharacterName other = (CharacterName)o;
        if (!Objects.equals(other.first, this.first)) {
            return false;
        }
        return Objects.equals(other.last, this.last);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.last);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("first", (Object)this.first).add("last", (Object)this.last).toString();
    }
}

