/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import java.util.HashMap;
import java.util.Map;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.Mob;
import mythruna.sim.ai.SteeringPrimitives;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkBehavior
extends AbstractBehavior {
    static Logger log = LoggerFactory.getLogger(TalkBehavior.class);
    private String defaultAction;
    private Map<EntityId, Mob> conversers = new HashMap<EntityId, Mob>();
    private boolean resetFacing = false;
    private double maxWait;
    private double timeout;

    public TalkBehavior(Mob target, String defaultAction, double maxWait) {
        this.defaultAction = defaultAction;
        this.maxWait = maxWait;
        this.addConverser(target);
    }

    public void addConverser(Mob mob) {
        log.info("addConverser(" + mob + ")");
        if (mob == null) {
            return;
        }
        this.conversers.put(mob.getEntityId(), mob);
        this.resetFacing = true;
        this.timeout = this.maxWait;
    }

    public void removeConverser(EntityId id) {
        log.info("removeConverser(" + id + ")");
        this.conversers.remove(id);
        this.resetFacing = true;
    }

    public boolean hasConversers() {
        return !this.conversers.isEmpty();
    }

    public boolean hasConverser(EntityId target) {
        return this.conversers.containsKey(target);
    }

    @Override
    protected void onStart(Brain brain) {
        log.info("onStart()");
        this.resetFacing = true;
        brain.getAgent().setDefaultAction(this.defaultAction);
    }

    @Override
    public boolean update(long frameTime, double step) {
        if (this.conversers.isEmpty()) {
            log.info("Done talking");
            return false;
        }
        this.timeout -= step;
        if (this.timeout < 0.0) {
            log.info("Got tired of waiting for more conversation.");
            this.conversers.clear();
            return false;
        }
        if (!this.resetFacing) {
            return true;
        }
        this.resetFacing = false;
        Vec3d center = new Vec3d();
        int count = 0;
        for (Mob mob : this.conversers.values()) {
            center.addLocal(mob.getLocation());
            ++count;
        }
        if (count > 0) {
            center.divideLocal((double)count);
            log.info("Want to look at:" + center);
            this.getBrain().getAgent().setSteering(SteeringPrimitives.faceLocation(this.getBrain().getAgent(), center));
        } else {
            log.warn("Somehow we found no locations for:" + this.conversers);
            this.getBrain().getAgent().setSteering(SteeringPrimitives.constant(0.0, 0.0, 0.0));
        }
        return true;
    }

    @Override
    protected void onStop() {
        log.info("onStop()");
    }
}

