/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.io.BlockTypeData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockTypeIndex {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(BlockTypeIndex.class);
    private static BlockType[] types;
    private static int typeCount;
    private static BlockType badType;
    private static int badTypeIndex;

    private BlockTypeIndex() {
    }

    public static void initialize(BlockType[] types, int badTypeIndex) {
        log.info("initialize(size:" + types.length + ")");
        if (BlockTypeIndex.types != null) {
            throw new IllegalStateException("BlockTypeIndex is already initialized");
        }
        BlockTypeIndex.types = types;
        typeCount = types.length;
        BlockTypeIndex.badTypeIndex = badTypeIndex;
        badType = types[badTypeIndex];
    }

    public static void initialize(BlockTypeData blockData) {
        BlockTypeIndex.initialize(blockData.types, blockData.badTypeIndex);
    }

    public static void load(InputStream rawIn) throws IOException {
        BlockTypeData blockData = BlockTypeData.load(rawIn);
        BlockTypeIndex.reset();
        BlockTypeIndex.initialize(blockData.types, blockData.badTypeIndex);
    }

    public static void store(OutputStream rawOut) throws IOException {
        BlockTypeData blockData = new BlockTypeData();
        blockData.types = types;
        blockData.badTypeIndex = badTypeIndex;
        BlockTypeData.store(blockData, rawOut);
    }

    public static void reset() {
        log.info("reset()");
        types = null;
        typeCount = 0;
        badTypeIndex = 0;
        badType = null;
    }

    public static BlockTypeData toBlockTypeData() {
        return new BlockTypeData(types, badTypeIndex);
    }

    public static BlockType get(int type) {
        if (type >= 0 && type < typeCount) {
            return types[type];
        }
        return badType;
    }

    public static void setBadTypeIndex(int index) {
        badTypeIndex = index;
    }

    public static int getBadTypeIndex() {
        return badTypeIndex;
    }

    public static void override(int index, BlockType type) {
        BlockTypeIndex.types[index] = type;
    }

    public static boolean isInitialized() {
        return types != null;
    }

    public static int getTypeCount() {
        return typeCount;
    }

    public static BlockType[] getTypes() {
        return types;
    }

    public static int findType(BlockName name) {
        return BlockTypeIndex.findType(name, -1);
    }

    public static int findType(BlockName name, int defaultValue) {
        for (int i = 0; i < types.length; ++i) {
            BlockType type = types[i];
            if (type == null || !Objects.equals(type.getName(), name)) continue;
            return i;
        }
        return defaultValue;
    }
}

