/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.base;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import com.simsilica.mworld.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightNeighborhood
implements CellData {
    static Logger log = LoggerFactory.getLogger(LightNeighborhood.class);
    private World world;
    private Vec3i origin;
    private LightData center;
    private LightData[][][] array = new LightData[3][3][3];

    public LightNeighborhood(World world, LightData center) {
        this.world = world;
        this.center = center;
        this.origin = center.getLeafId().getWorld(null);
        this.array[1][1][1] = center;
    }

    public int getCell(int x, int y, int z) {
        return this.getCell(x, y, z, -1);
    }

    public int getCell(int x, int y, int z, int defaultValue) {
        int yWorld;
        if (x >= 0 && y >= 0 && z >= 0 && x < 32 && y < 32 && z < 32) {
            return this.center.getCell(x, y, z, defaultValue);
        }
        int ax = 1;
        int ay = 1;
        int az = 1;
        if (x < 0) {
            --ax;
            x += 32;
        }
        if (y < 0) {
            --ay;
            y += 32;
        }
        if (z < 0) {
            --az;
            z += 32;
        }
        if (x >= 32) {
            ++ax;
            x -= 32;
        }
        if (y >= 32) {
            ++ay;
            y -= 32;
        }
        if (z >= 32) {
            ++az;
            z -= 32;
        }
        if ((yWorld = this.origin.y + (ay - 1) * 32) < 0 || yWorld >= this.world.getMaxY()) {
            return defaultValue;
        }
        if (this.array[ax][ay][az] == null) {
            LeafId id = LeafId.fromWorld(this.origin.x + (ax - 1) * 32, yWorld, this.origin.z + (az - 1) * 32);
            this.array[ax][ay][az] = this.world.getLight(id);
        }
        if (this.array[ax][ay][az] == null) {
            return defaultValue;
        }
        return this.array[ax][ay][az].getCell(x, y, z, defaultValue);
    }

    public int getCell(int x, int y, int z, Direction dir, int defaultValue) {
        Vec3i v = dir.getVec3i();
        return this.getCell(x + v.x, y + v.y, z + v.z, defaultValue);
    }

    public void setCell(int x, int y, int z, int type) {
    }
}

