/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.local;

import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.CellChangeEvent;
import com.simsilica.mworld.CellChangeListener;
import com.simsilica.mworld.World;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.world.local.BasisData;
import mythruna.world.local.FluidBasisData;
import mythruna.world.local.ForestValue;
import mythruna.world.local.LightBasisData;
import mythruna.world.local.LightValue;
import mythruna.world.local.LocalSpaceValue;
import mythruna.world.local.TreeBasisData;
import mythruna.world.local.UnderwaterValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSpace {
    static Logger log = LoggerFactory.getLogger(LocalSpace.class);
    private World world;
    private WorldObserver worldObserver = new WorldObserver();
    private ConcurrentLinkedQueue<CellChangeEvent> worldUpdates = new ConcurrentLinkedQueue();
    private Vec3d pos = new Vec3d();
    private Vec3i cell = new Vec3i();
    private BasisData[] basisData;
    private LocalSpaceValue[] values;
    private CellChangeListener[] cellListeners;
    private LightValue light;
    private UnderwaterValue underwater;
    private ForestValue forest;

    public LocalSpace(World world) {
        this.world = world;
        world.addCellChangeListener((CellChangeListener)this.worldObserver);
        LightBasisData lightData = new LightBasisData(world);
        FluidBasisData fluidData = new FluidBasisData(world);
        TreeBasisData treeData = new TreeBasisData(world);
        this.basisData = new BasisData[]{lightData, fluidData, treeData};
        this.light = new LightValue(lightData);
        this.underwater = new UnderwaterValue(fluidData);
        this.forest = new ForestValue(treeData);
        this.values = new LocalSpaceValue[]{this.light, this.underwater, this.forest};
        this.cellListeners = new CellChangeListener[]{this.light, this.underwater};
    }

    public void release() {
        this.world.removeCellChangeListener((CellChangeListener)this.worldObserver);
        this.worldUpdates.clear();
    }

    public LightValue getLightValue() {
        return this.light;
    }

    public UnderwaterValue getUnderwaterValue() {
        return this.underwater;
    }

    public ForestValue getForestValue() {
        return this.forest;
    }

    public boolean updatePosition(Vec3d newPos, Vec3d look) {
        this.pos.set(newPos);
        if (this.pos.y < 0.0) {
            this.pos.y = 0.0;
        } else if (this.pos.y >= (double)this.world.getMaxY()) {
            this.pos.y = this.world.getMaxY() - 1;
        }
        Vec3i newCell = this.pos.floor();
        for (LocalSpaceValue v : this.values) {
            v.updatePosition(this.pos, newCell, look);
        }
        if (this.cell.equals((Object)newCell)) {
            return false;
        }
        this.cell.set(newCell);
        boolean changed = false;
        for (BasisData data : this.basisData) {
            if (!data.updatePosition(this.cell)) continue;
            changed = true;
        }
        return changed;
    }

    public void applyWorldUpdates() {
        CellChangeEvent event = null;
        while ((event = this.worldUpdates.poll()) != null) {
            for (CellChangeListener l : this.cellListeners) {
                l.cellChanged(event);
            }
        }
    }

    public void reload() {
        for (BasisData data : this.basisData) {
            if (!data.isInvalid()) continue;
            data.reload();
        }
    }

    private class WorldObserver
    implements CellChangeListener {
        private WorldObserver() {
        }

        public void cellChanged(CellChangeEvent event) {
            LocalSpace.this.worldUpdates.add(event);
        }
    }
}

