/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.shader.ShaderNodeVariable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ShaderGenerationInfo
implements Savable,
Cloneable {
    protected List<ShaderNodeVariable> attributes = new ArrayList<ShaderNodeVariable>();
    protected List<ShaderNodeVariable> vertexUniforms = new ArrayList<ShaderNodeVariable>();
    protected ShaderNodeVariable vertexGlobal = null;
    protected List<ShaderNodeVariable> varyings = new ArrayList<ShaderNodeVariable>();
    protected List<ShaderNodeVariable> fragmentUniforms = new ArrayList<ShaderNodeVariable>();
    protected List<ShaderNodeVariable> fragmentGlobals = new ArrayList<ShaderNodeVariable>();
    protected List<String> unusedNodes = new ArrayList<String>();

    public List<ShaderNodeVariable> getAttributes() {
        return this.attributes;
    }

    public List<ShaderNodeVariable> getVertexUniforms() {
        return this.vertexUniforms;
    }

    public List<ShaderNodeVariable> getFragmentUniforms() {
        return this.fragmentUniforms;
    }

    public ShaderNodeVariable getVertexGlobal() {
        return this.vertexGlobal;
    }

    public List<ShaderNodeVariable> getFragmentGlobals() {
        return this.fragmentGlobals;
    }

    public List<ShaderNodeVariable> getVaryings() {
        return this.varyings;
    }

    public void setVertexGlobal(ShaderNodeVariable vertexGlobal) {
        this.vertexGlobal = vertexGlobal;
    }

    public List<String> getUnusedNodes() {
        return this.unusedNodes;
    }

    public void setUnusedNodes(List<String> unusedNodes) {
        this.unusedNodes = unusedNodes;
    }

    public String toString() {
        return "ShaderGenerationInfo{attributes=" + this.attributes + ", vertexUniforms=" + this.vertexUniforms + ", vertexGlobal=" + this.vertexGlobal + ", varyings=" + this.varyings + ", fragmentUniforms=" + this.fragmentUniforms + ", fragmentGlobals=" + this.fragmentGlobals + '}';
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.writeSavableArrayList((ArrayList)this.attributes, "attributes", new ArrayList());
        oc.writeSavableArrayList((ArrayList)this.vertexUniforms, "vertexUniforms", new ArrayList());
        oc.writeSavableArrayList((ArrayList)this.varyings, "varyings", new ArrayList());
        oc.writeSavableArrayList((ArrayList)this.fragmentUniforms, "fragmentUniforms", new ArrayList());
        oc.writeSavableArrayList((ArrayList)this.fragmentGlobals, "fragmentGlobals", new ArrayList());
        oc.write(this.vertexGlobal, "vertexGlobal", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.attributes = ic.readSavableArrayList("attributes", new ArrayList());
        this.vertexUniforms = ic.readSavableArrayList("vertexUniforms", new ArrayList());
        this.varyings = ic.readSavableArrayList("varyings", new ArrayList());
        this.fragmentUniforms = ic.readSavableArrayList("fragmentUniforms", new ArrayList());
        this.fragmentGlobals = ic.readSavableArrayList("fragmentGlobals", new ArrayList());
        this.vertexGlobal = (ShaderNodeVariable)ic.readSavable("vertexGlobal", null);
    }

    protected ShaderGenerationInfo clone() throws CloneNotSupportedException {
        ShaderGenerationInfo clone = (ShaderGenerationInfo)super.clone();
        clone.attributes = new ArrayList<ShaderNodeVariable>();
        clone.vertexUniforms = new ArrayList<ShaderNodeVariable>();
        clone.fragmentUniforms = new ArrayList<ShaderNodeVariable>();
        clone.fragmentGlobals = new ArrayList<ShaderNodeVariable>();
        clone.unusedNodes = new ArrayList<String>();
        clone.varyings = new ArrayList<ShaderNodeVariable>();
        for (ShaderNodeVariable attribute : this.attributes) {
            clone.attributes.add(attribute.clone());
        }
        for (ShaderNodeVariable uniform : this.vertexUniforms) {
            clone.vertexUniforms.add(uniform.clone());
        }
        if (this.vertexGlobal != null) {
            clone.vertexGlobal = this.vertexGlobal.clone();
        }
        for (ShaderNodeVariable varying : this.varyings) {
            clone.varyings.add(varying.clone());
        }
        for (ShaderNodeVariable uniform : this.fragmentUniforms) {
            clone.fragmentUniforms.add(uniform.clone());
        }
        for (ShaderNodeVariable globals : this.fragmentGlobals) {
            clone.fragmentGlobals.add(globals.clone());
        }
        clone.unusedNodes.addAll(this.unusedNodes);
        return clone;
    }
}

