/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3d;
import java.util.function.Consumer;
import mythruna.es.ProtectedArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedAreaEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(ProtectedAreaEditor.class);
    private EntityId toolId;
    private EntityId editing;
    private TextField name;
    private Vec3d end1;
    private Vec3d end2;
    private Container buttons;
    private ActionButton save;
    private ActionButton delete;
    private ActionButton cancel;
    private Consumer<ProtectedAreaEditor> saveCallback;
    private Consumer<ProtectedAreaEditor> deleteCallback;

    public ProtectedAreaEditor(EntityId toolId) {
        super((GuiLayout)new BorderLayout(), new ElementId("window"));
        this.toolId = toolId;
        this.addChild((Node)new Label("Protected Area Editor", new ElementId("window.title")), new Object[]{BorderLayout.Position.North});
        Container contents = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last)), new Object[]{BorderLayout.Position.Center});
        this.buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[]{BorderLayout.Position.South});
        this.save = new ActionButton((Action)new CallMethodAction("Save", (Object)this, "save"));
        this.delete = new ActionButton((Action)new CallMethodAction("Delete", (Object)this, "delete"));
        this.cancel = new ActionButton((Action)new CallMethodAction("Cancel", (Object)this, "cancel"));
    }

    protected void resetButtons() {
        this.buttons.clearChildren();
        this.buttons.addChild((Node)this.save, new Object[0]);
        if (this.editing != null) {
            this.save.setText("Save");
            this.buttons.addChild((Node)this.delete, new Object[0]);
        } else {
            this.save.setText("Create");
        }
        this.buttons.addChild((Node)this.cancel, new Object[0]);
    }

    public EntityId getEditing() {
        return this.editing;
    }

    public void create(EntityId toolId, Vec3d end1, Vec3d end2, Consumer<ProtectedAreaEditor> saveCallback) {
        this.toolId = toolId;
        this.end1 = end1;
        this.end2 = end2;
        this.editing = null;
        this.saveCallback = saveCallback;
        this.resetButtons();
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this);
    }

    public void edit(EntityId toolId, Entity entity, Consumer<ProtectedAreaEditor> saveCallback, Consumer<ProtectedAreaEditor> deleteCallback) {
        this.toolId = toolId;
        this.editing = entity.getId();
        this.end1 = ((ProtectedArea)entity.get(ProtectedArea.class)).getMin();
        this.end2 = ((ProtectedArea)entity.get(ProtectedArea.class)).getMax();
        this.saveCallback = saveCallback;
        this.deleteCallback = deleteCallback;
        this.resetButtons();
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this);
    }

    protected void save() {
        this.saveCallback.accept(this);
        this.removeFromParent();
    }

    protected void delete() {
        this.deleteCallback.accept(this);
        this.removeFromParent();
    }

    protected void cancel() {
        System.out.println("cancel()");
        this.removeFromParent();
    }
}

