/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.input;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.action.Option;
import com.simsilica.action.PromptType;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.es.WatchedEntity;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.Axis;
import com.simsilica.lemur.input.Button;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mythruna.client.BackgroundRetrieverState;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.TimeState;
import mythruna.client.ui.PromptListener;
import mythruna.client.ui.UserPromptState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.OriginalDiggerManipulator;
import mythruna.client.view.WorldMarkerState;
import mythruna.client.view.input.BlockManipulator;
import mythruna.client.view.input.BlockTypeSelectionState;
import mythruna.client.view.input.CreatorManipulator;
import mythruna.client.view.input.HandManipulator;
import mythruna.client.view.input.ManipulatorType;
import mythruna.client.view.input.SwingManipulator;
import mythruna.client.view.object.ModelViewState;
import mythruna.es.Holding;
import mythruna.es.ObjectFocus;
import mythruna.es.ObjectName;
import mythruna.net.DefaultGameSessionListener;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivationInputState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ActivationInputState.class);
    public static final String GROUP_ACTIVATION = "Activation";
    public static final FunctionId F_PRIMARY = new FunctionId("Activation", "Primary");
    public static final FunctionId F_PRIMARY_ALT = new FunctionId("Activation", "Primary Alt");
    public static final FunctionId F_SECONDARY = new FunctionId("Activation", "Secondary");
    public static final FunctionId F_SECONDARY_ALT = new FunctionId("Activation", "Secondary Alt");
    public static final FunctionId F_PRIMARY_SELECTOR = new FunctionId("Activation", "Primary Sel.");
    public static final FunctionId F_SECONDARY_SELECTOR = new FunctionId("Activation", "Secondary Sel.");
    public static final FunctionId F_PRIMARY_SELECTOR_KEYS = new FunctionId("Activation", "Primary Sel. Keys");
    public static final FunctionId F_SECONDARY_SELECTOR_KEYS = new FunctionId("Activation", "Secondary Sel. Keys");
    private EntityData ed;
    private EntityId avatarId;
    private GameSession session;
    private BackgroundRetrieverState retriever;
    private ActivationHandler activationHandler = new ActivationHandler();
    private SessionObserver sessionObserver = new SessionObserver(this);
    private TimeState time;
    private PromptObserver promptObserver = new PromptObserver();
    private Node cursor;
    private Geometry cursorGeom;
    private int size = 24;
    private ColorRGBA cursorColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private Label cursorText;
    private String lastAction;
    private VersionedReference<Vec3d> cameraPosRef;
    private VersionedReference<Quatd> cameraFacingRef;
    private WatchedEntity mainHand;
    private Holding mainHolding;
    private ManipulatorType mainManipulator;
    private WatchedEntity mainItem;
    private ObjectFocus mainFocus;
    private FocusView focusView;
    private String focusText;
    private String focusAnnotation;
    private Label focusLabel;
    private float labelScale = 1.5f;
    private Geometry unitCube;
    private CellArray focusCells = new CellArray(1, 1, 1);
    private CellArray focusLights = new CellArray(1, 1, 1);
    private Map<EntityId, Spatial> spatialCache = new HashMap<EntityId, Spatial>();

    public void setDefaultAction(String action) {
        if (Objects.equals(action, this.lastAction)) {
            return;
        }
        this.lastAction = action;
        log.info("--------setDefaultAction(" + action + ")");
        if (action == null) {
            this.cursorText.setText("");
            this.cursorText.removeFromParent();
            return;
        }
        if (this.cursorText.getParent() == null) {
            this.cursor.attachChild((Spatial)this.cursorText);
        }
        this.cursorText.setText(action);
        Vector3f pref = this.cursorText.getPreferredSize();
        this.cursorText.setLocalTranslation(-pref.x * 0.5f, 0.0f, 0.0f);
    }

    protected Node getGuiNode() {
        return ((SimpleApplication)this.getApplication()).getGuiNode();
    }

    protected void initialize(Application app) {
        int timeIndex = 0;
        long start = System.nanoTime();
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.time = (TimeState)this.getState(TimeState.class, true);
        this.retriever = (BackgroundRetrieverState)this.getState(BackgroundRetrieverState.class, true);
        this.cameraPosRef = ((AvatarState)this.getState(AvatarState.class, true)).createEyePositionReference();
        this.cameraFacingRef = ((AvatarState)this.getState(AvatarState.class, true)).createCameraOrientationReference();
        this.focusView = new FocusView(this, app.getCamera());
        long end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.focusView.setLocalScale(0.018f);
        this.focusLabel = new Label("(0) Unknown", new ElementId("focus.label"));
        this.focusLabel.setColor(ColorRGBA.White);
        this.focusLabel.setShadowColor(ColorRGBA.Black);
        this.focusLabel.setLocalScale(this.labelScale);
        GameSessionState sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        sessionState.addGameSessionListener((GameSessionListener)this.sessionObserver);
        this.session = sessionState.getGameSession();
        this.avatarId = this.session.getAvatar();
        GuiGlobals globals = GuiGlobals.getInstance();
        InputMapper inputMapper = globals.getInputMapper();
        inputMapper.map(F_PRIMARY, Button.MOUSE_BUTTON1, new Object[0]);
        inputMapper.map(F_PRIMARY_ALT, Button.MOUSE_BUTTON2, new Object[0]);
        inputMapper.map(F_SECONDARY, Button.MOUSE_BUTTON1, new Object[]{29});
        inputMapper.map(F_SECONDARY, Button.MOUSE_BUTTON1, new Object[]{157});
        inputMapper.map(F_SECONDARY_ALT, Button.MOUSE_BUTTON2, new Object[]{29});
        inputMapper.map(F_SECONDARY_ALT, Button.MOUSE_BUTTON2, new Object[]{157});
        inputMapper.map(F_PRIMARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[0]);
        inputMapper.map(F_PRIMARY_SELECTOR_KEYS, 52, new Object[0]);
        inputMapper.map(F_PRIMARY_SELECTOR_KEYS, InputState.Negative, 51, new Object[0]);
        inputMapper.map(F_SECONDARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[]{29});
        inputMapper.map(F_SECONDARY_SELECTOR, Axis.MOUSE_WHEEL, new Object[]{157});
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        float quadSize = (float)this.size * 4.0f / 3.0f;
        Quad quad = new Quad(quadSize, quadSize);
        Texture texture = globals.loadTexture("Interface/glass-orb-dark-48.png", false, false);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.cursorGeom = new Geometry("cursor", (Mesh)quad);
        Material mat = globals.createMaterial(texture, false).getMaterial();
        mat.setColor("Color", this.cursorColor);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.cursorGeom.setMaterial(mat);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.cursor = new Node("cursor");
        this.cursorGeom.center();
        this.cursor.attachChild((Spatial)this.cursorGeom);
        float scale = (float)app.getCamera().getHeight() / 900.0f;
        this.cursor.setLocalScale(scale);
        this.cursorText = new Label("", new ElementId("action.label"));
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.unitCube = new Geometry("unitCube", (Mesh)new Box(0.5f, 0.5f, 0.5f));
        mat = globals.createMaterial(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f), false).getMaterial();
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Front);
        this.unitCube.setMaterial(mat);
        this.unitCube.setQueueBucket(RenderQueue.Bucket.Transparent);
        this.unitCube.move(0.5f, 0.5f, 0.5f);
        end = System.nanoTime();
        log.info("init[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        int timeIndex = 0;
        long start = System.nanoTime();
        ((UserPromptState)this.getState(UserPromptState.class)).addPromptListener(this.promptObserver);
        this.resetCursorPosition();
        this.getGuiNode().attachChild((Spatial)this.cursor);
        this.focusView.updateCamera();
        long end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.focusView);
        ((GuiState)this.getState(GuiState.class)).getGuiRoot().attachChild((Spatial)this.focusLabel);
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        log.info("cursor size:" + this.cursor.getWorldBound() + "  cursor scale:" + this.cursor.getWorldScale());
        this.mainHand = this.ed.watchEntity(this.avatarId, new Class[]{Holding.class});
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.getApplication().enqueue(() -> this.setMainManipulator((Holding)this.mainHand.get(Holding.class)));
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        this.updateFocusLabel();
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup(GROUP_ACTIVATION);
        inputMapper.addDelegate(F_PRIMARY, (Object)this.activationHandler, "setPrimary", true);
        inputMapper.addDelegate(F_PRIMARY_ALT, (Object)this.activationHandler, "setPrimaryAlt", true);
        inputMapper.addDelegate(F_SECONDARY, (Object)this.activationHandler, "setSecondary", true);
        inputMapper.addDelegate(F_SECONDARY_ALT, (Object)this.activationHandler, "setSecondaryAlt", true);
        inputMapper.addDelegate(F_PRIMARY_SELECTOR_KEYS, (Object)this.activationHandler, "changePrimary", true);
        inputMapper.addAnalogListener((AnalogFunctionListener)this.activationHandler, new FunctionId[]{F_PRIMARY_SELECTOR, F_SECONDARY_SELECTOR});
        end = System.nanoTime();
        log.info("enable[" + timeIndex++ + "] took:" + (double)(end - start) / 1000000.0 + " ms");
        start = System.nanoTime();
    }

    public void update(float tpf) {
        if (this.mainHand.applyChanges()) {
            this.setMainManipulator((Holding)this.mainHand.get(Holding.class));
        }
        if (this.mainItem != null && this.mainItem.applyChanges()) {
            this.setMainFocus((ObjectFocus)this.mainItem.get(ObjectFocus.class));
        }
        boolean viewChanged = false;
        if (this.cameraFacingRef.update()) {
            viewChanged = true;
        }
        if (this.cameraPosRef.update()) {
            viewChanged = true;
        }
        if (viewChanged) {
            if (this.mainManipulator != null) {
                this.mainManipulator.viewChanged((Vec3d)this.cameraPosRef.get(), (Quatd)this.cameraFacingRef.get());
            }
        } else if (this.mainManipulator != null) {
            this.mainManipulator.update(tpf);
        }
    }

    protected void onDisable() {
        ((UserPromptState)this.getState(UserPromptState.class)).removePromptListener(this.promptObserver);
        this.cursor.removeFromParent();
        this.focusView.removeFromParent();
        this.focusLabel.removeFromParent();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup(GROUP_ACTIVATION);
        inputMapper.removeDelegate(F_PRIMARY, (Object)this.activationHandler, "setPrimary");
        inputMapper.removeDelegate(F_PRIMARY_ALT, (Object)this.activationHandler, "setPrimaryAlt");
        inputMapper.removeDelegate(F_SECONDARY, (Object)this.activationHandler, "setSecondary");
        inputMapper.removeDelegate(F_SECONDARY_ALT, (Object)this.activationHandler, "setSecondaryAlt");
        inputMapper.removeDelegate(F_PRIMARY_SELECTOR_KEYS, (Object)this.activationHandler, "changePrimary");
        inputMapper.removeAnalogListener((AnalogFunctionListener)this.activationHandler, new FunctionId[]{F_PRIMARY_SELECTOR, F_SECONDARY_SELECTOR});
    }

    protected EntityId getMainHoldingTarget() {
        return this.mainHolding == null ? null : this.mainHolding.getTarget();
    }

    protected void setMainManipulator(Holding holding) {
        String type;
        EntityId target;
        if (Objects.equals(this.mainHolding, holding)) {
            return;
        }
        if (holding != null) {
            log.info("setMainManipulator(" + holding.toString(this.ed) + ")");
        }
        if (this.mainManipulator != null) {
            this.mainManipulator.setTarget(null);
            this.mainItem.release();
            this.setDefaultAction(null);
        }
        this.mainHolding = holding;
        this.setFocusAnnotation(null);
        EntityId blockTool = null;
        if (this.mainHolding == null) {
            target = this.avatarId;
            type = "Hand";
        } else {
            target = holding.getTarget();
            type = holding.getManipulatorTypeName(this.ed);
        }
        if ("OriginalDigger".equals(type)) {
            log.info("OriginalDigger");
            this.mainManipulator = new OriginalDiggerManipulator(((GameSessionState)this.getState(GameSessionState.class)).getWorld(), (WorldMarkerState)this.getState(WorldMarkerState.class), this.session, (AvatarState)this.getState(AvatarState.class)){

                @Override
                public void change(int delta) {
                    ((BlockTypeSelectionState)ActivationInputState.this.getState(BlockTypeSelectionState.class)).adjustRotation(delta);
                    super.change(delta);
                }
            };
            blockTool = target;
        } else if ("Creator".equals(type)) {
            log.info("Creator");
            this.mainManipulator = new CreatorManipulator(this.session, (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class), text -> this.setDefaultAction((String)text));
        } else if ("Block".equals(type)) {
            log.info("Block");
            this.mainManipulator = new BlockManipulator((GameSessionState)this.getState(GameSessionState.class), (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class), text -> this.setDefaultAction((String)text));
            blockTool = target;
        } else if ("Hand".equals(type)) {
            log.info("Hand");
            this.mainManipulator = new HandManipulator(this.session, (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class), text -> this.setDefaultAction((String)text));
        } else if ("Swing".equals(type)) {
            log.info("Swing");
            HandManipulator hand = new HandManipulator(this.session, (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class), text -> this.setDefaultAction((String)text));
            this.mainManipulator = new SwingManipulator((AvatarState)this.getState(AvatarState.class), hand);
        } else {
            log.error("Current equipped object has no manipulator type:" + target);
            this.mainManipulator = new HandManipulator(this.session, (AvatarState)this.getState(AvatarState.class), (ModelViewState)this.getState(ModelViewState.class), text -> this.setDefaultAction((String)text));
        }
        ((BlockTypeSelectionState)this.getState(BlockTypeSelectionState.class)).setTool(blockTool);
        this.mainItem = this.ed.watchEntity(target, new Class[]{ObjectFocus.class});
        this.setMainFocus((ObjectFocus)this.mainItem.get(ObjectFocus.class), true);
        this.mainManipulator.setTarget(target);
    }

    public void setMainFocus(ObjectFocus focus) {
        this.setMainFocus(focus, false);
    }

    protected void setMainFocus(ObjectFocus focus, boolean forceUpdate) {
        if (!forceUpdate && Objects.equals(this.mainFocus, focus)) {
            return;
        }
        log.info("Main focus:" + focus);
        this.mainFocus = focus;
        if (this.mainFocus == null) {
            this.focusView.setFocus(null);
            this.setFocusText("");
            return;
        }
        if (focus.isEntity()) {
            EntityId id = focus.getEntityId();
            Spatial existing = this.spatialCache.get(id);
            if (existing != null) {
                this.setFocusSpatial(id, existing);
            } else {
                ((ModelViewState)this.getState(ModelViewState.class)).createSpatial(id, spatial -> {
                    spatial.setCullHint(Spatial.CullHint.Never);
                    this.setFocusSpatial(id, (Spatial)spatial);
                    this.spatialCache.put(id, (Spatial)spatial);
                });
            }
        } else if (focus.isBlockType()) {
            int val = MaskUtils.setSideMask((int)Math.max(0, (int)focus.getId()), (int)63);
            this.focusCells.setCell(0, 0, 0, val);
            this.focusLights.setCell(0, 0, 0, LightUtils.DIRECT_SUN);
            GeometryFactory geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getGeometryFactory();
            Node indicator = new Node("indicator");
            Node blocks = geomFactory.generateBlocks(indicator, this.focusCells, (CellData)this.focusLights, false);
            blocks.attachChild((Spatial)this.unitCube);
            this.focusView.setFocus((Spatial)blocks);
            BlockType bt = BlockTypeIndex.get((int)((int)focus.getId()));
            if (bt != null) {
                this.setFocusText(String.valueOf(bt.getName()));
            } else {
                this.setFocusText("Unknown");
            }
        } else if (focus.isString()) {
            this.focusView.setFocus(null);
            this.setFocusText(focus.getString(this.ed));
        } else {
            this.focusView.setFocus(null);
            this.setFocusText("");
            throw new UnsupportedOperationException("Uknonwn focus type:" + focus);
        }
        this.updateFocusLabel();
    }

    protected void setFocusText(String focusText) {
        log.info("setFocusText(" + focusText + ")");
        if (Objects.equals(focusText, this.focusText)) {
            return;
        }
        this.focusText = focusText;
        this.updateFocusText();
    }

    protected void setFocusAnnotation(String focusAnnotation) {
        log.info("setFocusAnnotation(" + focusAnnotation + ")");
        if (Objects.equals(focusAnnotation, this.focusAnnotation)) {
            return;
        }
        this.focusAnnotation = focusAnnotation;
        this.updateFocusText();
    }

    protected void updateFocusText() {
        if (this.focusLabel != null) {
            if (this.focusAnnotation != null) {
                this.focusLabel.setText(this.focusText + " (" + this.focusAnnotation + ")");
            } else {
                this.focusLabel.setText(this.focusText);
            }
        }
    }

    protected String getObjectName(EntityId entityId, String defaultValue) {
        ObjectName on = (ObjectName)this.ed.getComponent(entityId, ObjectName.class);
        if (on != null) {
            return on.getName(this.ed);
        }
        Name name = (Name)this.ed.getComponent(entityId, Name.class);
        if (name != null) {
            return name.getName();
        }
        return defaultValue;
    }

    protected void setFocusSpatial(EntityId entityId, Spatial spatial) {
        this.focusView.setFocus(spatial);
        String name = (String)spatial.getUserData("objectName");
        if (name != null) {
            this.setFocusText(name);
        } else {
            this.retriever.query((Object)this, () -> this.getObjectName(entityId, "Unknown"), text -> {
                this.setFocusText((String)text);
                spatial.setUserData("objectName", text);
            });
        }
        this.updateFocusLabel();
    }

    protected void updateFocusLabel() {
        Vector3f pref = this.focusLabel.getPreferredSize().mult(this.labelScale);
        Vector2f size = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).getGuiSize();
        this.focusLabel.setLocalTranslation(size.x * 0.5f - pref.x * 0.5f, 5.0f + pref.y, 0.0f);
    }

    protected void resetCursorPosition() {
        int width = this.getApplication().getCamera().getWidth();
        int height = this.getApplication().getCamera().getHeight();
        this.cursor.setLocalTranslation((float)width * 0.5f, (float)height * 0.5f, 0.0f);
    }

    public class ActivationHandler
    implements AnalogFunctionListener {
        private InputState previousPrimary;

        public void setPrimary(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.mainManipulator.activate(pressed);
        }

        public void setPrimaryAlt(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.mainManipulator.altActivate(pressed);
        }

        public void setSecondary(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.session.executeCommand("activateSecondary", ActivationInputState.this.avatarId, new Object[]{pressed});
        }

        public void setSecondaryAlt(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            boolean pressed = state == InputState.Positive;
            ActivationInputState.this.session.executeCommand("activateSecondaryAlt", ActivationInputState.this.avatarId, new Object[]{pressed});
        }

        public void changePrimary(InputState state) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            log.info("changePrimary(" + state + ")");
            if (state != this.previousPrimary) {
                this.previousPrimary = state;
                ActivationInputState.this.mainManipulator.change(state.asNumber());
            }
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (ActivationInputState.this.mainManipulator == null) {
                return;
            }
            if (func == F_PRIMARY_SELECTOR) {
                ActivationInputState.this.mainManipulator.change((int)value);
            }
        }
    }

    private class SessionObserver
    extends DefaultGameSessionListener {
        private SessionObserver(ActivationInputState activationInputState) {
        }

        public void setAvatar(EntityId avatar) {
            log.info("setAvatar(" + avatar + ")");
        }
    }

    private class PromptObserver
    implements PromptListener {
        private PromptObserver() {
        }

        @Override
        public boolean showPrompt(EntityId entityId, PromptType type, String promptText) {
            log.info("showPrompt(" + entityId + ", " + type + ")");
            switch (type) {
                case Flyover: {
                    ActivationInputState.this.setDefaultAction(promptText);
                    return true;
                }
                case Message: {
                    log.info("entityId:" + entityId + "  holding:" + ActivationInputState.this.getMainHoldingTarget());
                    if (promptText != null && Objects.equals(entityId, ActivationInputState.this.getMainHoldingTarget())) {
                        log.info("promptText:" + promptText);
                        if (promptText.startsWith("focusAnnotation:")) {
                            ActivationInputState.this.setFocusAnnotation(promptText.substring("focusAnnotation:".length()));
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        @Override
        public boolean showOptions(EntityId target, List<Option<EntityId>> options, Option<EntityId> closeOption) {
            return false;
        }
    }

    private class FocusView
    extends Node {
        private Camera cam;
        private Vector3f offset = new Vector3f();
        private float project = 0.25f;
        private float yOffset = 0.0f;
        private float effectiveHeight = 60.0f;
        private Spatial focus;
        private double baseRadius = Math.sqrt(0.75);
        private Geometry test;

        public FocusView(ActivationInputState activationInputState, Camera cam) {
            super("focus");
            this.cam = cam;
            this.updateCamera();
        }

        protected double getRadius(BoundingVolume bounds) {
            if (bounds instanceof BoundingSphere) {
                float radius = ((BoundingSphere)bounds).getRadius();
                return Math.sqrt(radius * radius + radius * radius + radius * radius);
            }
            if (bounds instanceof BoundingBox) {
                Vector3f extent = ((BoundingBox)bounds).getExtent(null);
                return Math.sqrt(extent.x * extent.x + extent.y * extent.y + extent.z * extent.z);
            }
            return this.baseRadius;
        }

        public void setFocus(Spatial focus) {
            if (this.focus == focus) {
                return;
            }
            if (this.focus != null) {
                this.focus.removeFromParent();
            }
            this.focus = focus;
            if (this.focus != null) {
                focus.removeFromParent();
                focus.setLocalScale(1.0f);
                BoundingVolume bounds = focus.getWorldBound();
                double radius = this.getRadius(bounds);
                float scale = (float)(this.baseRadius / radius);
                focus.setLocalScale(scale);
                focus.center();
                this.attachChild(focus);
            }
        }

        public void updateCamera() {
            double fov = Math.toRadians(this.cam.getFov());
            double cos = Math.cos(fov * 0.5);
            double h = (double)this.project / cos;
            double y = Math.sin(fov * 0.5) * h;
            double halfScreen = (double)this.cam.getHeight() * 0.5;
            double ratio = (double)this.effectiveHeight / halfScreen;
            if (halfScreen < 450.0) {
                ratio *= halfScreen / 450.0;
            }
            double height = y * ratio;
            this.yOffset = (float)(-y + height);
            float scale = (float)height;
            this.setLocalScale(scale);
        }

        public void updateLogicalState(float tpf) {
            super.updateLogicalState(tpf);
            this.offset.set(this.cam.getLocation());
            this.offset.addLocal(this.cam.getDirection().mult(this.project));
            this.offset.addLocal(this.cam.getUp().mult(this.yOffset));
            this.setLocalTranslation(this.offset);
        }
    }
}

