/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.input;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Slider;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.KeyAction;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.net.ChatMessage;
import com.simsilica.net.ChatSessionListener;
import com.simsilica.net.client.ChatClientService;
import com.simsilica.state.CommandConsoleState;
import com.simsilica.state.CommandEntry;
import com.simsilica.state.MessageState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.client.GameSessionState;
import mythruna.client.Main;
import mythruna.client.MainGameFunctions;
import mythruna.client.net.ConnectionState;
import mythruna.client.sound.SoundState;
import mythruna.net.DefaultGameSessionListener;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.net.client.GameSessionClientService;
import mythruna.shell.ChatWho;
import mythruna.shell.CommandShell;
import mythruna.shell.Echo;
import mythruna.shell.Help;
import mythruna.shell.PassthroughCommand;
import mythruna.shell.ShellCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ShellState.class);
    public static final String SOUND_NEW_CHAT = "New Chat";
    private GameSessionClientService session;
    private CommandEntry originalCommandEntry;
    private ChatClientService chatService;
    private ChatObserver chatObserver = new ChatObserver();
    private ShellOutputObserver outputObserver = new ShellOutputObserver();
    private CommandShell clientShell = new CommandShell();
    private SoundState sounds;
    private Map<String, String> npcAliases = new ConcurrentHashMap<String, String>();
    private VersionedReference<Boolean> consoleEnabledRef;
    private RangedValueModel scrollModel;
    private Slider scrollSlider;

    public CommandShell getClientShell() {
        return this.clientShell;
    }

    public Map<String, String> getNpcAliases() {
        return this.npcAliases;
    }

    protected void initialize(Application app) {
        this.session = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(GameSessionClientService.class);
        this.chatService = ((ConnectionState)this.getState(ConnectionState.class)).getService(ChatClientService.class);
        this.session.addGameSessionListener((GameSessionListener)this.outputObserver);
        MessageState messages = (MessageState)this.getState(MessageState.class);
        this.clientShell.setOutput(line -> messages.addMessage(line, ColorRGBA.Cyan));
        this.clientShell.addCommand("help", (ShellCommand)new Help());
        this.clientShell.addCommand("echo", (ShellCommand)new Echo());
        this.clientShell.addCommand("who", (ShellCommand)new ChatWho(this.chatService));
        this.clientShell.addCommand("ping", (ShellCommand)new PassthroughCommand((GameSession)this.session, "ping", new String[]{"- Shows stats about this client connection."}));
        this.clientShell.put("connection", (Object)this.getState(ConnectionState.class));
        this.sounds = (SoundState)this.getState(SoundState.class, true);
        this.sounds.registerSound(SOUND_NEW_CHAT, "Sounds/Effects/sh-blink.ogg");
        CommandConsoleState console = (CommandConsoleState)this.getState(CommandConsoleState.class, true);
        console.getActionMap().put(new KeyAction(200, new int[0]), (source, key) -> this.scrollConsole(InputState.Positive));
        console.getActionMap().put(new KeyAction(208, new int[0]), (source, key) -> this.scrollConsole(InputState.Negative));
        this.scrollModel = messages.getScrollModel();
        this.scrollSlider = new Slider(this.scrollModel, Axis.Y, new ElementId("console.slider"), null);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        CommandConsoleState console = (CommandConsoleState)this.getState(CommandConsoleState.class, true);
        this.consoleEnabledRef = console.createEnabledReference();
        this.originalCommandEntry = console.getCommandEntry();
        console.setCommandEntry((CommandEntry)new GameCommandEntry());
        this.chatService.addChatSessionListener((ChatSessionListener)this.chatObserver);
        for (ChatMessage m : this.chatService.getBacklog()) {
            log.info("Catching up:" + m);
            m.deliver((ChatSessionListener)this.chatObserver);
        }
        this.chatService.getBacklog().clear();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(MainGameFunctions.F_CHAT_CONSOLE, (Object)this.getState(GameSessionState.class), "openConsole");
        inputMapper.addDelegate(MainGameFunctions.F_SCROLL_CONSOLE, (Object)this, "scrollConsole", true);
        inputMapper.addDelegate(MainGameFunctions.F_PAGE_CONSOLE, (Object)this, "pageConsole", true);
    }

    protected void onDisable() {
        CommandConsoleState console = (CommandConsoleState)this.getState(CommandConsoleState.class, true);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(MainGameFunctions.F_CHAT_CONSOLE, (Object)this.getState(GameSessionState.class), "openConsole");
        inputMapper.removeDelegate(MainGameFunctions.F_SCROLL_CONSOLE, (Object)this, "scrollConsole");
        inputMapper.removeDelegate(MainGameFunctions.F_PAGE_CONSOLE, (Object)this, "pageConsole");
        this.chatService.removeChatSessionListener((ChatSessionListener)this.chatObserver);
        console.setCommandEntry(this.originalCommandEntry);
    }

    public void update(float tpf) {
        if (this.consoleEnabledRef.update()) {
            this.updateSlider();
            if (!((Boolean)this.consoleEnabledRef.get()).booleanValue()) {
                ((GameSessionState)this.getState(GameSessionState.class)).closeConsole();
            }
        }
    }

    protected void updateSlider() {
        if (((Boolean)this.consoleEnabledRef.get()).booleanValue()) {
            MessageState messages = (MessageState)this.getState(MessageState.class, true);
            Vector3f offset = messages.getMessageRootOffset();
            float yBottom = offset.y;
            float yTop = this.getApplication().getCamera().getHeight();
            this.scrollSlider.setPreferredSize(null);
            Vector3f pref = this.scrollSlider.getPreferredSize();
            pref.y = yTop - yBottom;
            this.scrollSlider.setPreferredSize(pref);
            float width = this.getApplication().getCamera().getWidth();
            this.scrollSlider.setLocalTranslation(width - pref.x, yTop, 100.0f);
            ((Main)this.getApplication()).getGuiNode().attachChild((Spatial)this.scrollSlider);
        } else {
            this.scrollSlider.removeFromParent();
        }
    }

    public void scrollConsole(InputState val) {
        log.info("scroll:" + val);
        switch (val) {
            case Positive: {
                this.scrollModel.setValue(this.scrollModel.getValue() + 1.0);
                break;
            }
            case Negative: {
                this.scrollModel.setValue(this.scrollModel.getValue() - 1.0);
            }
        }
    }

    public void pageConsole(InputState val) {
        log.info("page:" + val);
        switch (val) {
            case Positive: {
                this.scrollModel.setValue(this.scrollModel.getValue() + 10.0);
                break;
            }
            case Negative: {
                this.scrollModel.setValue(this.scrollModel.getValue() - 10.0);
            }
        }
    }

    protected void resetScroll() {
        this.scrollModel.setValue(0.0);
    }

    private class ChatObserver
    implements ChatSessionListener {
        private ChatObserver() {
        }

        public void playerJoined(int clientId, String playerName) {
            log.info("playerJoined(" + clientId + ", " + playerName + ")");
            ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(playerName + " has joined.", ColorRGBA.Yellow);
        }

        public void newMessage(int clientId, String playerName, String message) {
            ColorRGBA color = ColorRGBA.White;
            if (clientId == -1 && !playerName.startsWith("<")) {
                if ((playerName = ShellState.this.npcAliases.get(playerName)) == null) {
                    return;
                }
                color = ColorRGBA.Cyan;
            }
            ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(playerName + ">" + message, color);
            ShellState.this.getApplication().enqueue(() -> ShellState.this.sounds.playEffect(ShellState.SOUND_NEW_CHAT));
        }

        public void playerLeft(int clientId, String playerName) {
            log.info("playerLeft(" + clientId + ", " + playerName + ")");
            ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(playerName + " has left.", ColorRGBA.Yellow);
        }
    }

    private class ShellOutputObserver
    extends DefaultGameSessionListener {
        private ShellOutputObserver() {
        }

        public void newConsoleMessage(String msg) {
            ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(msg, ColorRGBA.Green);
        }
    }

    private class GameCommandEntry
    implements CommandEntry {
        private String lastCommand;

        private GameCommandEntry() {
        }

        public boolean runCommand(String cmd) {
            ShellState.this.resetScroll();
            if (cmd.length() == 0) {
                return false;
            }
            switch (cmd.charAt(0)) {
                case '.': {
                    if (this.lastCommand != null) {
                        log.info("Running previous command:" + this.lastCommand);
                        return this.runCommand(this.lastCommand);
                    }
                    return false;
                }
                case '/': {
                    log.info("local cmd:" + cmd.substring(1));
                    try {
                        ShellState.this.clientShell.execute(cmd.substring(1));
                    }
                    catch (Exception e) {
                        log.error("Error running command:" + cmd, (Throwable)e);
                        ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(e.getMessage(), ColorRGBA.Red);
                    }
                    this.lastCommand = cmd;
                    return true;
                }
                case '~': {
                    log.info("remote cmd:" + cmd.substring(1));
                    ShellState.this.session.executeShell(cmd.substring(1));
                    this.lastCommand = cmd;
                    return true;
                }
            }
            ShellState.this.chatService.sendMessage(cmd);
            return false;
        }
    }
}

