/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import mythruna.sim.ai.Behavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.Reaction;
import mythruna.sim.ai.Signal;

public abstract class AbstractBehavior
implements Behavior {
    private Brain brain;
    private boolean running;

    protected AbstractBehavior() {
    }

    protected Brain getBrain() {
        return this.brain;
    }

    public Reaction generateReaction(Brain brain, Signal signal) {
        return null;
    }

    @Override
    public final void start(Brain brain) {
        if (this.running) {
            return;
        }
        this.running = true;
        this.brain = brain;
        this.onStart(brain);
    }

    protected void onStart(Brain brain) {
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public abstract boolean update(long var1, double var3);

    @Override
    public final void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.onStop();
        this.brain = null;
    }

    protected void onStop() {
    }
}

