/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.db.AbstractColumnDb;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryColumnDb
extends AbstractColumnDb {
    static Logger log = LoggerFactory.getLogger(InMemoryColumnDb.class);
    private Vec3i center;
    private int radius;
    private int height;
    private Consumer<ColumnData> initializer;
    private Map<ColumnId, ColumnData> data = new ConcurrentHashMap<ColumnId, ColumnData>();

    public InMemoryColumnDb(Vec3i center, int radius, int height, Consumer<ColumnData> initializer) {
        this.center = center;
        this.radius = radius;
        this.height = height;
        this.initializer = initializer;
    }

    @Override
    public void initialize() {
        int span = 32;
        int size = (int)Math.ceil((double)this.height / (double)span);
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int z = -this.radius; z <= this.radius; ++z) {
                Vec3i loc = this.center.add(x * span, 0, z * span);
                ColumnId id = ColumnId.fromWorld(loc);
                ColumnData columnData = new ColumnData(id, size);
                this.initializer.accept(columnData);
                this.data.put(id, columnData);
                this.columnGenerated(columnData);
            }
        }
        log.info("created " + this.data.size() + " columns.");
    }

    @Override
    public void terminate() {
    }

    @Override
    public ColumnData getColumn(ColumnId columnId) {
        return this.data.get(columnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markChanged(ColumnData col) {
        DataVersion version;
        DataVersion dataVersion = version = col.getVersion();
        synchronized (dataVersion) {
            version.resetChanged(System.currentTimeMillis());
        }
    }
}

