/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.simsilica.es.EntityId;
import com.simsilica.es.IndexedField;
import com.simsilica.es.StringType;
import com.simsilica.es.sql.FieldType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypes {
    static Logger log = LoggerFactory.getLogger(FieldTypes.class);
    private static final Map<String, String> dbTypes = new HashMap<String, String>();

    public static List<FieldType> getFieldTypes(Class type) {
        return FieldTypes.getFieldTypes(null, type);
    }

    protected static List<FieldType> getFieldTypes(String prefix, Class type) {
        Field[] fields;
        if (log.isTraceEnabled()) {
            log.trace("getFieldTypes(" + prefix + ", " + type + ")");
        }
        ArrayList<FieldType> results = new ArrayList<FieldType>();
        for (Field f : fields = type.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            FieldType fieldType = FieldTypes.toFieldType(prefix, f);
            if (log.isTraceEnabled()) {
                log.trace("  field:" + f + "  fieldType:" + fieldType);
            }
            results.add(fieldType);
        }
        return results;
    }

    protected static FieldType toFieldType(String prefix, Field field) {
        field.setAccessible(true);
        Class<?> ft = field.getType();
        if (ft.isPrimitive()) {
            return new PrimitiveField(prefix, field);
        }
        if (ft.isArray()) {
            Class<?> elementType = ft.getComponentType();
            if (elementType.isPrimitive()) {
                return new PrimitiveArrayField(prefix, field);
            }
            throw new UnsupportedOperationException("Only primitive arrays are supported, field:" + field);
        }
        if (EntityId.class.isAssignableFrom(ft)) {
            return new EntityIdField(prefix, field);
        }
        if (String.class.equals(ft)) {
            return new StringField(prefix, field);
        }
        if (Enum.class.isAssignableFrom(ft)) {
            throw new UnsupportedOperationException("Enum types are not supported, field:" + field);
        }
        return new ObjectField(prefix, field);
    }

    protected static String toDbType(Class type) {
        String db = dbTypes.get(type.getSimpleName());
        if (db != null) {
            return db;
        }
        return type.getSimpleName();
    }

    protected static Object[] toObjectArray(Object array) {
        List result;
        if (array == null) {
            return null;
        }
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof int[]) {
            result = Ints.asList((int[])((int[])array));
        } else if (array instanceof long[]) {
            result = Longs.asList((long[])((long[])array));
        } else if (array instanceof short[]) {
            result = Shorts.asList((short[])((short[])array));
        } else if (array instanceof byte[]) {
            result = Bytes.asList((byte[])((byte[])array));
        } else if (array instanceof float[]) {
            result = Floats.asList((float[])((float[])array));
        } else if (array instanceof double[]) {
            result = Doubles.asList((double[])((double[])array));
        } else {
            throw new IllegalArgumentException("Unhandled array type:" + array.getClass());
        }
        return result.toArray(new Object[0]);
    }

    protected static Object toPrimitiveArray(Object array, Class elementType) {
        if (array == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("toPrimitiveArray(" + array + ", " + elementType + ")");
        }
        int size = Array.getLength(array);
        Object result = Array.newInstance(elementType, size);
        for (int i = 0; i < size; ++i) {
            Object element = Array.get(array, i);
            if (elementType == Integer.TYPE) {
                Array.setInt(result, i, (Integer)element);
                continue;
            }
            if (elementType == Long.TYPE) {
                Array.setLong(result, i, (Long)element);
                continue;
            }
            if (elementType == Short.TYPE) {
                Array.setShort(result, i, (Short)element);
                continue;
            }
            if (elementType == Byte.TYPE) {
                Array.setByte(result, i, (Byte)element);
                continue;
            }
            if (elementType == Float.TYPE) {
                Array.setFloat(result, i, ((Float)element).floatValue());
                continue;
            }
            if (elementType == Double.TYPE) {
                Array.setDouble(result, i, (Double)element);
                continue;
            }
            Array.set(result, i, element);
        }
        return result;
    }

    static {
        dbTypes.put("int", "INTEGER");
        dbTypes.put("long", "BIGINT");
        dbTypes.put("short", "SMALLINT");
        dbTypes.put("byte", "TINYINT");
        dbTypes.put("float", "FLOAT");
        dbTypes.put("double", "DOUBLE");
    }

    protected static class PrimitiveArrayField
    implements FieldType {
        private String name;
        private String dbFieldName;
        private String dbElementType;
        private Field field;

        public PrimitiveArrayField(Field field) {
            this(null, field);
        }

        public PrimitiveArrayField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            this.dbFieldName = prefix == null ? this.name : prefix + this.name;
            this.dbElementType = FieldTypes.toDbType(field.getType().getComponentType());
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            return this.dbElementType + " ARRAY";
        }

        @Override
        public boolean isIndexed() {
            return this.field.getAnnotation(IndexedField.class) != null;
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            defs.put(prefix + this.dbFieldName.toUpperCase(), this);
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            fields.add(prefix + this.dbFieldName);
        }

        @Override
        public Object toDbValue(Object o) {
            return o;
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                Object primArray = this.field.get(object);
                java.sql.Array array = ps.getConnection().createArrayOf(this.dbElementType, FieldTypes.toObjectArray(primArray));
                ps.setObject(index++, array);
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                java.sql.Array value = rs.getArray(index++);
                this.field.set(target, FieldTypes.toPrimitiveArray(value.getArray(), this.field.getType().getComponentType()));
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            Object value;
            store[storeIndex] = value = rs.getObject(columnIndex++);
            return columnIndex;
        }

        public String toString() {
            if (this.dbFieldName != this.name) {
                return this.name + "/" + this.dbFieldName + ":" + this.getType();
            }
            return this.getFieldName() + ":" + this.getType();
        }
    }

    protected static class PrimitiveField
    implements FieldType {
        private String name;
        private String dbFieldName;
        private Field field;

        public PrimitiveField(Field field) {
            this(null, field);
        }

        public PrimitiveField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            this.dbFieldName = prefix == null ? this.name : prefix + this.name;
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            String s = this.field.getType().getSimpleName();
            String result = (String)dbTypes.get(s);
            if (result != null) {
                return result;
            }
            return s;
        }

        @Override
        public boolean isIndexed() {
            return this.field.getAnnotation(IndexedField.class) != null;
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            defs.put(prefix + this.dbFieldName.toUpperCase(), this);
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            fields.add(prefix + this.dbFieldName);
        }

        @Override
        public Object toDbValue(Object o) {
            return o;
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                ps.setObject(index++, this.field.get(object));
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        protected Object cast(Number n, Class c) {
            if (c == Float.TYPE) {
                return Float.valueOf(n.floatValue());
            }
            if (c == Byte.TYPE) {
                return n.byteValue();
            }
            if (c == Short.TYPE) {
                return n.shortValue();
            }
            if (c == Integer.TYPE) {
                return n.intValue();
            }
            return n;
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                Object value = rs.getObject(index++);
                if (value instanceof Number) {
                    value = this.cast((Number)value, this.getType());
                } else if (value == null) {
                    value = this.cast(0, this.getType());
                }
                this.field.set(target, value);
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            Object value;
            if ((value = rs.getObject(columnIndex++)) instanceof Number) {
                value = this.cast((Number)value, this.getType());
            }
            store[storeIndex] = value;
            return columnIndex;
        }

        public String toString() {
            if (this.dbFieldName != this.name) {
                return this.name + "/" + this.dbFieldName + ":" + this.getType();
            }
            return this.getFieldName() + ":" + this.getType();
        }
    }

    protected static class ObjectField
    implements FieldType {
        private String name;
        private Field field;
        private FieldType[] fields;

        public ObjectField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            List<FieldType> list = FieldTypes.getFieldTypes(prefix, field.getType());
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Field " + this.name + " type:" + field.getType() + " has no usable child fields.");
            }
            this.fields = new FieldType[list.size()];
            this.fields = list.toArray(this.fields);
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            return "Undefined";
        }

        @Override
        public boolean isIndexed() {
            return this.field.getAnnotation(IndexedField.class) != null;
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            prefix = prefix + this.name + "_";
            for (FieldType t : this.fields) {
                t.addFieldDefinitions(prefix.toUpperCase(), defs);
            }
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            prefix = prefix + this.name + "_";
            for (FieldType t : this.fields) {
                t.addFields(prefix, fields);
            }
        }

        @Override
        public Object toDbValue(Object o) {
            return o;
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                Object subValue = this.field.get(object);
                for (FieldType t : this.fields) {
                    index = t.store(subValue, ps, index);
                }
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                Object subValue = this.field.getType().newInstance();
                for (FieldType t : this.fields) {
                    index = t.load(subValue, rs, index);
                }
                this.field.set(target, subValue);
                return index;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            try {
                Object subValue = this.field.getType().newInstance();
                for (FieldType t : this.fields) {
                    columnIndex = t.load(subValue, rs, columnIndex);
                }
                store[storeIndex] = subValue;
                return columnIndex;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        public String toString() {
            return this.getFieldName() + ":" + this.getType() + "{" + Arrays.asList(this.fields) + "}";
        }
    }

    protected static class StringField
    implements FieldType {
        private String name;
        private String dbFieldName;
        private Field field;
        private int maxLength;

        public StringField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            this.dbFieldName = prefix == null ? this.name : prefix + this.name;
            StringType meta = field.getAnnotation(StringType.class);
            this.maxLength = meta != null ? meta.maxLength() : 512;
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            return "VARCHAR(" + this.maxLength + ")";
        }

        @Override
        public boolean isIndexed() {
            return this.field.getAnnotation(IndexedField.class) != null;
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            defs.put(prefix + this.dbFieldName.toUpperCase(), this);
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            fields.add(prefix + this.dbFieldName);
        }

        @Override
        public Object toDbValue(Object o) {
            return o;
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                ps.setObject(index++, this.field.get(object));
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                this.field.set(target, rs.getObject(index++));
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            store[storeIndex] = rs.getObject(columnIndex++);
            return columnIndex;
        }

        public String toString() {
            if (this.dbFieldName != this.name) {
                return this.name + "/" + this.dbFieldName + ":" + this.getType();
            }
            return this.getFieldName() + ":" + this.getType();
        }
    }

    protected static class EntityIdField
    implements FieldType {
        private String name;
        private String dbFieldName;
        private Field field;

        public EntityIdField(Field field) {
            this(null, field);
        }

        public EntityIdField(String prefix, Field field) {
            this.field = field;
            this.name = field.getName();
            this.dbFieldName = prefix == null ? this.name : prefix + this.name;
        }

        @Override
        public String getFieldName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public String getDbType() {
            String result = (String)dbTypes.get("long");
            return result;
        }

        @Override
        public boolean isIndexed() {
            return this.field.getAnnotation(IndexedField.class) != null;
        }

        @Override
        public void addFieldDefinitions(String prefix, Map<String, FieldType> defs) {
            defs.put(prefix + this.dbFieldName.toUpperCase(), this);
        }

        @Override
        public void addFields(String prefix, List<String> fields) {
            fields.add(prefix + this.dbFieldName);
        }

        @Override
        public Object toDbValue(Object o) {
            if (o == null) {
                return null;
            }
            return ((EntityId)o).getId();
        }

        @Override
        public int store(Object object, PreparedStatement ps, int index) throws SQLException {
            try {
                EntityId entityId = (EntityId)this.field.get(object);
                if (entityId != null) {
                    ps.setObject(index++, entityId.getId());
                } else {
                    ps.setObject(index++, null);
                }
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int load(Object target, ResultSet rs, int index) throws SQLException {
            try {
                Number value = (Number)rs.getObject(index++);
                if (value != null) {
                    this.field.set(target, new EntityId(value.longValue()));
                } else {
                    this.field.set(target, null);
                }
                return index;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error in field mapping", e);
            }
        }

        @Override
        public int readIntoArray(Object[] store, int storeIndex, ResultSet rs, int columnIndex) throws SQLException {
            Number value;
            store[storeIndex] = (value = (Number)rs.getObject(columnIndex++)) != null ? new EntityId(value.longValue()) : null;
            return columnIndex;
        }

        public String toString() {
            if (this.dbFieldName != this.name) {
                return this.name + "/" + this.dbFieldName + ":" + this.getType();
            }
            return this.getFieldName() + ":" + this.getType();
        }
    }
}

