#import "Common/ShaderLib/GLSLCompat.glsllib"
#ifdef POINT_SPRITE
#  if !defined(GL_ES) && __VERSION__ < 120
#    error Point sprite is not supported by the video hardware!
#  endif
#endif

#ifdef USE_TEXTURE
uniform sampler2D m_Texture;
varying vec4 texCoord;
#endif

uniform vec4 m_Color;

varying vec4 color;

void main(){
    if (color.a <= 0.01) {
        discard;
    }

    vec4 pointColor;
    #ifdef USE_TEXTURE
        #ifdef POINT_SPRITE
            vec2 uv = mix(texCoord.xy, texCoord.zw, gl_PointCoord.xy);
        #else
            vec2 uv = texCoord.xy;
        #endif
        pointColor = texture2D(m_Texture, uv) * color;
    #else
        pointColor = color;
    #endif
    
    #ifdef HAS_COLOR
        pointColor = pointColor * m_Color;
    #endif

    gl_FragColor = pointColor;

    #ifdef PRE_SHADOW
        if (gl_FragColor.r <= 0.1 && 
            gl_FragColor.g <= 0.1 &&
            gl_FragColor.b <= 0.1) {
            discard;
        }
    #endif
}
