/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import mythruna.client.LogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorDialog
extends JFrame {
    static Logger log = LoggerFactory.getLogger(ErrorDialog.class);
    private static final String SECTION_BAR = "----------------------------";
    private String error;
    private Throwable throwable;
    private CountDownLatch canSafelyExit;
    private JEditorPane logReport;
    private StringBuilder report = new StringBuilder();

    public ErrorDialog(String error, Throwable throwable, CountDownLatch canSafelyExit) {
        super("Mythruna Severe Error");
        this.error = error;
        this.throwable = throwable;
        this.canSafelyExit = canSafelyExit;
        if (canSafelyExit != null) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.setSize(640, 480);
        this.setLocationRelativeTo(null);
        this.buildContents();
        this.parseLogs();
    }

    protected void buildContents() {
        JPanel contents = new JPanel();
        this.getContentPane().add(contents);
        contents.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        contents.add((Component)buttons, "South");
        buttons.add(new JButton(new AbstractAction("Copy Report to Clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.sendErrorToClipboard();
            }
        }));
        buttons.add(new JButton(new AbstractAction("Generate Report Zip"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.generateReportZip();
            }
        }));
        if (this.canSafelyExit != null) {
            buttons.add(new JButton(new AbstractAction("Exit"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ErrorDialog.this.shutdown();
                }
            }));
        } else {
            buttons.add(new JButton(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ErrorDialog.this.dispose();
                }
            }));
        }
        JTabbedPane tabs = new JTabbedPane();
        contents.add((Component)tabs, "Center");
        JEditorPane summary = new JEditorPane();
        summary.setEditable(false);
        tabs.addTab("Summary", new JScrollPane(summary));
        StringBuilder sb = new StringBuilder();
        for (Throwable t : Throwables.getCausalChain((Throwable)this.throwable)) {
            if (sb.length() > 0) {
                sb.append("Caused by: ");
            }
            sb.append(t.getClass().getSimpleName() + ": " + t.getMessage());
            sb.append("\n");
        }
        summary.setText(sb.toString());
        JEditorPane stack = new JEditorPane();
        stack.setEditable(false);
        tabs.addTab("Stack Trace", new JScrollPane(stack));
        stack.setText(Throwables.getStackTraceAsString((Throwable)this.throwable));
        this.logReport = new JEditorPane();
        this.logReport.setEditable(false);
        tabs.addTab("Error Logs", new JScrollPane(this.logReport));
        this.logReport.setText("Loading...");
        this.report.append("Summary:\n----------------------------\n");
        this.report.append(summary.getText());
        this.report.append("\nStack trace:\n----------------------------\n");
        this.report.append(stack.getText());
        File infoFile = new File("system-info.txt");
        if (infoFile.exists()) {
            try {
                String systemInfo = Files.toString((File)infoFile, (Charset)StandardCharsets.UTF_8);
                JEditorPane info = new JEditorPane();
                stack.setEditable(false);
                tabs.addTab("System Info", new JScrollPane(info));
                info.setText(systemInfo);
                this.report.append("\nSystem Info:\n----------------------------\n");
                this.report.append(systemInfo);
            }
            catch (IOException e) {
                log.error("Error reading:" + infoFile, (Throwable)e);
            }
        }
    }

    protected void shutdown() {
        log.info("shutdown()");
        if (this.canSafelyExit == null) {
            log.info("Not in a mode where shutdown can be initiated.");
            return;
        }
        if (this.canSafelyExit.getCount() == 0L) {
            log.info("Exiting");
            System.exit(-1);
            return;
        }
        log.info("Waiting to safely exit...");
        String format = "Waiting for writes to finish... up to %d seconds.";
        AtomicInteger seconds = new AtomicInteger(60);
        JLabel message = new JLabel(String.format(format, seconds.get()));
        message.setHorizontalAlignment(0);
        message.setBorder(new EmptyBorder(10, 20, 10, 20));
        JDialog dialog = new JDialog((Frame)this, true);
        dialog.setTitle("Waiting for Safe Shutdown");
        dialog.setDefaultCloseOperation(0);
        dialog.getContentPane().add(message);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        Thread thread = new Thread(() -> {
            try {
                int secs;
                while (!this.canSafelyExit.await(1L, TimeUnit.SECONDS) && (secs = seconds.decrementAndGet()) > 0) {
                    SwingUtilities.invokeLater(() -> message.setText(String.format(format, secs)));
                }
            }
            catch (InterruptedException e) {
                log.error("Interrupted waiting", (Throwable)e);
            }
            if (this.canSafelyExit.getCount() == 0L) {
                log.info("Safely exiting");
            } else {
                log.info("Force exiting");
            }
            System.exit(-1);
        });
        thread.setName("WaitForSafeExit");
        log.info("starting thread:" + thread);
        thread.start();
        dialog.setVisible(true);
    }

    protected void parseLogs() {
        new Thread(() -> {
            LogParser parser = new LogParser();
            try {
                parser.parse(new File("mythruna-client.log"));
                SwingUtilities.invokeLater(() -> {
                    String s = Joiner.on((String)"\n").join(parser.getErrors());
                    this.logReport.setText(s);
                    this.report.append("\nError logs:\n----------------------------\n" + s);
                });
            }
            catch (IOException e) {
                log.error("Error parsing log file", (Throwable)e);
            }
        }).start();
    }

    public void sendErrorToClipboard() {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(this.report.toString());
        clip.setContents(data, data);
    }

    public void generateReportZip(Consumer<Integer> progress, BiConsumer<String, Throwable> callback) {
        log.info("generateReportZip()");
        String name = String.format("%tF-%08x.error.zip", new Date(), System.currentTimeMillis());
        File file = new File(name);
        log.info("Generating:" + file);
        Thread thread = new Thread(() -> {
            try {
                this.writeZip(file, progress);
            }
            catch (Exception e) {
                callback.accept("Error writing:" + file, e);
                return;
            }
            callback.accept("Finished writing:" + file, null);
        });
        thread.setName("ZipWriter");
        thread.start();
    }

    protected void generateReportZip() {
        log.info("generateReportZip()");
        String name = String.format("%tF-%08x.error.zip", new Date(), System.currentTimeMillis());
        File file = new File(name);
        log.info("Generating:" + file);
        JProgressBar progress = new JProgressBar(0, 100);
        JDialog dialog = new JDialog((Frame)this, true);
        dialog.setTitle("Writing Report Zip");
        dialog.setDefaultCloseOperation(0);
        dialog.getContentPane().add(progress);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        Thread thread = new Thread(() -> {
            try {
                this.writeZip(file, p -> SwingUtilities.invokeLater(() -> progress.setValue((int)p)));
            }
            catch (IOException e) {
                log.error("Error writing zip:" + file, (Throwable)e);
                JOptionPane.showMessageDialog(this, "Error writing zip:" + file, "Zip Error", 0);
                return;
            }
            SwingUtilities.invokeLater(() -> {
                dialog.setVisible(false);
                JOptionPane.showMessageDialog(this, "Finished writing:" + file, "Success", 1);
            });
        });
        thread.setName("ZipWriter");
        thread.start();
        dialog.setVisible(true);
    }

    protected void safeSleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("error sleeping", e);
        }
    }

    protected void writeZip(File file, Consumer<Integer> progress) throws IOException {
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(file));){
            ZipEntry entry = new ZipEntry("report.txt");
            log.info("writing:" + entry);
            zip.putNextEntry(entry);
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)zip, StandardCharsets.UTF_8));
            out.print(this.report.toString());
            out.flush();
            entry = new ZipEntry("mythruna-client.log");
            log.info("writing:" + entry);
            zip.putNextEntry(entry);
            File logFile = new File("mythruna-client.log");
            long totalSize = logFile.length();
            byte[] buffer = new byte[1024];
            try (FileInputStream in = new FileInputStream(logFile);){
                int length = 0;
                long bytesWritten = 0L;
                while ((length = ((InputStream)in).read(buffer)) >= 0) {
                    zip.write(buffer, 0, length);
                    int p = (int)((bytesWritten += (long)length) * 100L / totalSize);
                    progress.accept(p);
                }
            }
        }
    }
}

