/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.util.Iterator;
import java.util.Objects;
import mythruna.client.ui.item.ContainerSection;
import mythruna.client.ui.item.Item;
import mythruna.item.InventorySize2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemContainer {
    static Logger log = LoggerFactory.getLogger(ItemContainer.class);
    public static final String MAIN_SECTION = "main";
    private static final InventorySize2d DEFAULT_CONTAINER_SIZE = new InventorySize2d();
    private EntityId entityId;
    private Item containerItem;
    private VersionedHolder<Vec3d> containerPos = new VersionedHolder((Object)new Vec3d());
    private VersionedHolder<InventorySize2d> containerSize = new VersionedHolder((Object)DEFAULT_CONTAINER_SIZE);
    private VersionedList<ContainerSection> sections = new VersionedList();
    private VersionedHolder<ContainerSection> currentSection = new VersionedHolder();

    public ItemContainer(EntityId entityId, Item containerItem) {
        this.entityId = entityId;
        this.containerItem = containerItem;
        ContainerSection section = new ContainerSection(entityId, MAIN_SECTION);
        this.currentSection.setObject((Object)section);
        this.sections.add((Object)section);
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public ContainerSection getCurrentSection() {
        return (ContainerSection)((Object)this.currentSection.getObject());
    }

    public void setCurrentSection(ContainerSection section) {
        this.currentSection.updateObject((Object)section);
    }

    public VersionedReference<ContainerSection> createCurrentSectionRef() {
        return this.currentSection.createReference();
    }

    public VersionedList<ContainerSection> getSections() {
        return this.sections;
    }

    public boolean add(Item item) {
        return this.getCurrentSection().add(item);
    }

    public boolean remove(Item item) {
        return this.getCurrentSection().remove(item);
    }

    public boolean addSection(ContainerSection section) {
        if (this.sections.size() == 1 && MAIN_SECTION.equals(((ContainerSection)((Object)this.sections.get(0))).getName())) {
            this.sections.clear();
            this.currentSection.setObject(null);
        }
        boolean result = this.sections.add((Object)section);
        if (this.currentSection.getObject() == null) {
            this.currentSection.setObject((Object)section);
        }
        return result;
    }

    public Item getContainerItem() {
        return this.containerItem;
    }

    public void setContainerSize(InventorySize2d containerSize) {
        this.containerSize.updateObject((Object)containerSize);
    }

    public InventorySize2d getContainerSize() {
        return (InventorySize2d)this.containerSize.getObject();
    }

    public VersionedReference<InventorySize2d> createContainerSizeRef() {
        return this.containerSize.createReference();
    }

    public void setContainerPosition(Vec3d containerPos) {
        this.containerPos.updateObject((Object)containerPos);
    }

    public Vec3d getContainerPosition() {
        return (Vec3d)this.containerPos.getObject();
    }

    public VersionedReference<Vec3d> createContainerPositionRef() {
        return this.containerPos.createReference();
    }

    public boolean isEmpty(int xSlot, int ySlot, int width, int height) {
        Iterator iterator = ((ContainerSection)((Object)this.currentSection.getObject())).iterator();
        while (iterator.hasNext()) {
            Item child = (Item)iterator.next();
            if (!child.intersects(xSlot, ySlot, width, height)) continue;
            return false;
        }
        return true;
    }

    public Vec3i findEmptySlot(Item item) {
        return this.getCurrentSection().findEmptySlot(item, (InventorySize2d)this.containerSize.getObject());
    }

    public int hashCode() {
        return Objects.hash(this.entityId, this.containerItem, this.containerSize.getObject());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ItemContainer other = (ItemContainer)o;
        if (!Objects.equals(other.entityId, this.entityId)) {
            return false;
        }
        if (!Objects.equals(other.containerItem, this.containerItem)) {
            return false;
        }
        return Objects.equals(other.containerSize.getObject(), this.containerSize.getObject());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("entityId", (Object)this.entityId).add("containerItem", (Object)this.containerItem).add("containerSize", (Object)this.getContainerSize()).add("items", (Object)super.toString()).toString();
    }
}

