/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityCriteria;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import java.util.List;
import mythruna.client.ui.map.DefaultMapToolLayer;
import mythruna.client.ui.map.LineQuad;
import mythruna.client.ui.map.LineWidget;
import mythruna.client.ui.map.MapPoint;
import mythruna.client.ui.map.MapToolState;
import mythruna.client.ui.map.ProtectedAreaEditor;
import mythruna.es.OwnedBy;
import mythruna.es.ProtectedArea;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedAreaLayer
extends DefaultMapToolLayer {
    static Logger log = LoggerFactory.getLogger(ProtectedAreaLayer.class);
    private GameSession gameSession;
    private EntityData ed;
    private MapToolState parent;
    private AssetManager assets;
    private Node root;
    private EntityId avatarId;
    private Vector2f clipRadius = new Vector2f(100.0f, 100.0f);
    private ProtectedAreaContainer areas;
    private VersionedReference<List<TileId>> visibleTilesRef;
    private AreaView selected;
    private LineWidget lineWidget;
    private MapPoint draggedEnd;
    private Vec3d dragOffset;
    private ProtectedAreaEditor editor;
    private Label helpText;

    public ProtectedAreaLayer(GameSession gameSession, EntityData ed, MapToolState parent, AssetManager assets) {
        this.gameSession = gameSession;
        this.ed = ed;
        this.parent = parent;
        this.avatarId = gameSession.getAvatar();
        this.root = new Node("customProtectedAreaRoot");
        this.assets = assets;
        this.root.move(0.0f, 0.0f, 0.5f);
        parent.getToolRoot().attachChild((Spatial)this.root);
        this.visibleTilesRef = parent.createVisibleTilesRef();
        this.areas = new ProtectedAreaContainer(this.avatarId, ed);
        this.areas.setVisibleTiles((List)this.visibleTilesRef.get());
        this.helpText = new Label("Protected Area:\nLeft Mouse: Create\nRight Mouse: Move", new ElementId("help.tips.label"));
    }

    protected ProtectedAreaEditor getEditor() {
        if (this.editor != null) {
            return this.editor;
        }
        this.editor = new ProtectedAreaEditor(this.getToolId());
        return this.editor;
    }

    @Override
    public EntityId getEntityIdForCollision(Spatial collision) {
        AreaView v = this.getAreaView(collision);
        return v == null ? null : v.entity.getId();
    }

    @Override
    protected void onActivate() {
        this.parent.setLayerEditor((Panel)this.helpText);
    }

    @Override
    protected void onDeactivate() {
        this.parent.setLayerEditor(null);
    }

    @Override
    public void updateViewPort(Vector2f viewRadius) {
        this.clipRadius.set(viewRadius);
    }

    @Override
    public void start() {
        this.areas.start();
    }

    @Override
    public void update() {
        if (this.visibleTilesRef.update()) {
            this.areas.setVisibleTiles((List)this.visibleTilesRef.get());
        }
        this.areas.update();
        for (AreaView v : this.areas.getArray()) {
            v.updatePosition();
        }
    }

    @Override
    public void stop() {
        this.areas.stop();
    }

    @Override
    public void hover(Vec3d world, Spatial collision) {
        if (collision.hasAncestor((Node)this.lineWidget)) {
            return;
        }
        this.setSelected(this.getAreaView(collision));
    }

    @Override
    public void click(int button, Vec3d world, Spatial collision) {
        if (this.selected == null) {
            return;
        }
        if (button == 0) {
            log.info("edit:" + this.selected);
            GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this.getEditor());
            this.getEditor().edit(this.getToolId(), this.selected.entity, this::doUpdate, this::doDelete);
        }
    }

    protected Vec3d constrain(Vec3d v) {
        ColumnId colId = ColumnId.fromWorld((Vec3d)v);
        return colId.getWorld(null).toVec3d();
    }

    @Override
    public void startDrag(int button, Vec3d start, Vec3d end, Spatial collision) {
        this.draggedEnd = null;
        if (button == 0) {
            this.setSelected(null);
            this.showLineWidget(this.parent.createMapPoint(this.constrain(start)), this.parent.createMapPoint(this.constrain(end)));
            this.dragOffset = new Vec3d();
            this.draggedEnd = this.lineWidget.getEnd2();
        } else if (this.lineWidget != null) {
            this.draggedEnd = this.lineWidget.findEnd(collision);
            if (this.draggedEnd != null) {
                this.dragOffset = this.draggedEnd.getWorld().subtract(this.constrain(start));
                this.draggedEnd.setWorld(this.constrain(end.add(this.dragOffset)));
            }
        }
    }

    @Override
    public void drag(int button, Vec3d start, Vec3d end, Spatial collision) {
        if (this.draggedEnd != null) {
            this.draggedEnd.setWorld(this.constrain(end.add(this.dragOffset)));
        }
    }

    @Override
    public void endDrag(int button, Vec3d start, Vec3d end, Spatial collision) {
        this.draggedEnd = null;
        if (this.selected != null && this.lineWidget != null) {
            this.gameSession.runAction(this.getToolId(), "move", new Object[]{this.selected.entity.getId(), this.constrain(this.lineWidget.getEnd1().getWorld()), this.constrain(this.lineWidget.getEnd2().getWorld())});
        } else {
            this.gameSession.runAction(this.getToolId(), "create", new Object[]{ProtectedArea.create((Vec3d)this.constrain(start), (Vec3d)this.constrain(end), (int)0)});
        }
        this.clearLineWidget();
    }

    protected void setSelected(AreaView selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        if (this.selected == null) {
            this.clearLineWidget();
        } else {
            this.showLineWidget(selected.end1, selected.end2);
            this.root.attachChild((Spatial)this.lineWidget);
        }
    }

    protected LineWidget showLineWidget(MapPoint end1, MapPoint end2) {
        if (this.lineWidget != null) {
            this.lineWidget.removeFromParent();
        }
        this.lineWidget = new LineWidget("areaSelectionTool", end1, end2, this.assets);
        this.lineWidget.setClipRadius(this.clipRadius);
        this.lineWidget.move(0.0f, 0.0f, 20.0f);
        this.root.attachChild((Spatial)this.lineWidget);
        return this.lineWidget;
    }

    protected void clearLineWidget() {
        if (this.lineWidget != null) {
            this.lineWidget.removeFromParent();
            this.lineWidget = null;
        }
    }

    protected AreaView getAreaView(Spatial collision) {
        EntityId hit = this.getEntityId(collision);
        if (hit == null) {
            return null;
        }
        return (AreaView)this.areas.getObject(hit);
    }

    protected EntityId getEntityId(Spatial spatial) {
        for (Spatial s = spatial; s != null; s = s.getParent()) {
            if (s == this.root || s == this.parent.getMapRoot()) {
                return null;
            }
            Long id = (Long)s.getUserData("oid");
            if (id == null) continue;
            return new EntityId(id.longValue());
        }
        return null;
    }

    protected void doCreate(ProtectedAreaEditor editor) {
        log.info("doCreate()");
    }

    protected void doUpdate(ProtectedAreaEditor editor) {
        log.info("doUpdate()");
    }

    protected void doDelete(ProtectedAreaEditor editor) {
        log.info("doDelete()");
        this.gameSession.runAction(this.getToolId(), "delete", new Object[]{editor.getEditing()});
    }

    private class ProtectedAreaContainer
    extends EntityContainer<AreaView> {
        public ProtectedAreaContainer(EntityId avatarId, EntityData ed) {
            super(ed, new EntityCriteria().add(new Class[]{ProtectedArea.class}).add(new ComponentFilter[]{OwnedBy.filter((EntityId)avatarId)}));
        }

        public void setVisibleTiles(List<TileId> tiles) {
            EntityCriteria criteria = this.getCriteria();
            if (tiles.isEmpty()) {
                ComponentFilter filter1 = ProtectedArea.filterTileId((long)0L);
                ComponentFilter filter2 = ProtectedArea.filterTileId((long)1L);
                criteria.setFilter(ProtectedArea.class, Filters.and(ProtectedArea.class, (ComponentFilter[])new ComponentFilter[]{filter1, filter2}));
                this.setCriteria(criteria);
                return;
            }
            ComponentFilter[] filters = new ComponentFilter[tiles.size()];
            int index = 0;
            for (TileId id : tiles) {
                filters[index++] = ProtectedArea.filterTileId((long)id.getId());
            }
            criteria.setFilter(ProtectedArea.class, Filters.or(ProtectedArea.class, (ComponentFilter[])filters));
            this.setCriteria(criteria);
        }

        public AreaView[] getArray() {
            return (AreaView[])super.getArray();
        }

        protected AreaView addObject(Entity entity) {
            AreaView result = new AreaView(ProtectedAreaLayer.this, entity);
            this.updateObject(result, entity);
            return result;
        }

        protected void updateObject(AreaView object, Entity entity) {
            if (entity != object.entity) {
                log.error("That's really weird.");
            }
            object.updateData();
        }

        protected void removeObject(AreaView object, Entity entity) {
            object.release();
        }
    }

    private class AreaView {
        private Entity entity;
        private ProtectedArea area;
        private String styleName;
        private LineQuad lineQuad;
        private Quad quad;
        private Geometry geom;
        private Material material;
        private ColorRGBA color = new ColorRGBA(0.2f, 0.1f, 0.1f, 0.65f);
        private MapPoint end1;
        private MapPoint end2;
        private VersionedReference<MapPoint> end1Ref;
        private VersionedReference<MapPoint> end2Ref;

        public AreaView(ProtectedAreaLayer protectedAreaLayer, Entity entity) {
            this.entity = entity;
            this.end1 = protectedAreaLayer.parent.createMapPoint(new Vec3d());
            this.end1Ref = this.end1.createReference();
            this.end2 = protectedAreaLayer.parent.createMapPoint(new Vec3d());
            this.end2Ref = this.end2.createReference();
            this.buildGeometry("line:" + entity.getId());
            this.geom.setUserData("oid", (Object)entity.getId().getId());
            protectedAreaLayer.root.attachChild((Spatial)this.geom);
        }

        protected void buildGeometry(String geomName) {
            this.quad = new Quad(10.0f, 10.0f);
            this.geom = new Geometry(geomName, (Mesh)this.quad);
            this.material = GuiGlobals.getInstance().createMaterial(this.color, false).getMaterial();
            this.geom.setMaterial(this.material);
            this.geom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        }

        public void updatePosition() {
            boolean changed = false;
            if (this.end1Ref.update()) {
                changed = true;
            }
            if (this.end2Ref.update()) {
                changed = true;
            }
            if (changed) {
                this.resetPosition();
            }
        }

        public void updateData() {
            this.area = (ProtectedArea)this.entity.get(ProtectedArea.class);
            this.end1.setWorld(this.area.getMin());
            this.end2.setWorld(this.area.getMax());
        }

        protected void resetPosition() {
            double w = Math.abs(this.end1.getView().x - this.end2.getView().x);
            double h = Math.abs(this.end1.getView().y - this.end2.getView().y);
            this.quad.updateGeometry((float)w, (float)h);
            double x = Math.min(this.end1.getView().x, this.end2.getView().x);
            double y = Math.min(this.end1.getView().y, this.end2.getView().y);
            this.geom.updateModelBound();
            this.geom.setLocalTranslation((float)x, (float)y, 0.0f);
        }

        public void release() {
            this.geom.removeFromParent();
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.entity.getId() + "]";
        }
    }
}

