/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.world;

import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.simsilica.es.EntityData;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.CellGenType;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.World;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldStats
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(WorldStats.class);
    private static final Function<Object, String> TO_STRING = Functions.toStringFunction();
    private EntityData ed;
    private World world;
    private WorldManager worldManager;
    private int yMax;
    private Map<String, Set<Integer>> blockSets = new HashMap<String, Set<Integer>>();

    public Set<Integer> getBlockSet(String name) {
        Set<Integer> set = this.blockSets.get(name);
        return set == null ? Collections.emptySet() : set;
    }

    public void setBlockSet(String name, Predicate<BlockType> filter) {
        log.info("server-test-mod setBlockSet(" + name + ", " + filter + ")");
        HashSet<Integer> set = new HashSet<Integer>();
        BlockType[] types = BlockTypeIndex.getTypes();
        for (int i = 0; i < types.length; ++i) {
            BlockType type = types[i];
            if (type == null || !filter.test(type)) continue;
            log.info(name + ":Including type:" + type.getName());
            set.add(i);
        }
        this.blockSets.put(name, set);
        log.info(name + " = " + set);
    }

    public void setBlockSet(String name, String pattern) {
        com.google.common.base.Predicate pred = Predicates.containsPattern((String)pattern);
        this.setBlockSet(name, arg_0 -> WorldStats.lambda$setBlockSet$0((Predicate)pred, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSurfaceBlocks(ColumnId columnId, Set<Integer> types, int minCount) {
        start = System.nanoTime();
        try {
            count = 0;
            origin = columnId.getWorld(null);
            ground = new boolean[32][32];
            leafLoc = origin.toVec3d();
            y = this.yMax;
lbl8:
            // 2 sources

            while (true) {
                if (y >= 0) {
                    leafLoc.y = y;
                    leaf = this.world.getWorldLeaf(leafLoc);
                    if (leaf == null || leaf.isEmpty()) break;
                    leafOrigin = leaf.getLeafId().getWorld(null);
                } else {
                    var10_9 = false;
                    end = System.nanoTime();
                    WorldStats.log.info(String.format("hasSurfaceBlocks() %.02f ms", new Object[]{(double)(end - start) / 1000000.0}));
                    return var10_9;
                }
                block4: for (i = 0; i < 32; ++i) {
                    k = 0;
                    while (true) {
                        if (k >= 32) continue block4;
                        if (!ground[i][k]) {
                            for (j = 31; j >= 0; --j) {
                                value = leaf.getCell(i, j, k);
                                type = MaskUtils.getType((int)value);
                                if (types.contains(type) && ++count >= minCount) {
                                    var18_19 = true;
                                    end = System.nanoTime();
                                    WorldStats.log.info(String.format("hasSurfaceBlocks() %.02f ms", new Object[]{(double)(end - start) / 1000000.0}));
                                    return var18_19;
                                }
                                genType = CellGenType.getType((int)value);
                                if (genType != CellGenType.Terrain) continue;
                                ground[i][k] = true;
                                break;
                            }
                        }
                        ++k;
                    }
                }
                break;
            }
        }
        catch (Throwable var21_21) {
            end = System.nanoTime();
            WorldStats.log.info(String.format("hasSurfaceBlocks() %.02f ms", new Object[]{(double)(end - start) / 1000000.0}));
            throw var21_21;
        }
        y -= 32;
        ** while (true)
    }

    public List<Vec3i> getSurfaceBlocks(ColumnId columnId, Set<Integer> types) {
        long start = System.nanoTime();
        ArrayList<Vec3i> results = new ArrayList<Vec3i>();
        Vec3i origin = columnId.getWorld(null);
        boolean[][] ground = new boolean[32][32];
        Vec3d leafLoc = origin.toVec3d();
        for (int y = this.yMax; y >= 0; y -= 32) {
            leafLoc.y = y;
            LeafData leaf = this.world.getWorldLeaf(leafLoc);
            if (leaf == null || leaf.isEmpty()) continue;
            Vec3i leafOrigin = leaf.getLeafId().getWorld(null);
            for (int i = 0; i < 32; ++i) {
                block2: for (int k = 0; k < 32; ++k) {
                    if (ground[i][k]) continue;
                    for (int j = 31; j >= 0; --j) {
                        CellGenType genType;
                        int value = leaf.getCell(i, j, k);
                        int type = MaskUtils.getType((int)value);
                        if (types.contains(type)) {
                            results.add(leafOrigin.add(i, j, k));
                        }
                        if ((genType = CellGenType.getType((int)value)) != CellGenType.Terrain) continue;
                        ground[i][k] = true;
                        continue block2;
                    }
                }
            }
        }
        long end = System.nanoTime();
        log.info(String.format("getSurfaceBlocks() %.02f ms", (double)(end - start) / 1000000.0));
        return results;
    }

    public Map<Integer, Integer> getSurfaceCounts(ColumnId columnId) {
        long start = System.nanoTime();
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        Vec3i origin = columnId.getWorld(null);
        boolean[][] ground = new boolean[32][32];
        Vec3d leafLoc = origin.toVec3d();
        for (int y = this.yMax; y >= 0; y -= 32) {
            leafLoc.y = y;
            LeafData leaf = this.world.getWorldLeaf(leafLoc);
            if (leaf == null || leaf.isEmpty()) continue;
            for (int i = 0; i < 32; ++i) {
                block2: for (int k = 0; k < 32; ++k) {
                    if (ground[i][k]) continue;
                    for (int j = 31; j >= 0; --j) {
                        int value = leaf.getCell(i, j, k);
                        int type = MaskUtils.getType((int)value);
                        Integer count = (Integer)results.get(type);
                        if (count == null) {
                            results.put(type, 1);
                        } else {
                            results.put(type, count + 1);
                        }
                        CellGenType genType = CellGenType.getType((int)value);
                        if (genType != CellGenType.Terrain) continue;
                        ground[i][k] = true;
                        continue block2;
                    }
                }
            }
        }
        long end = System.nanoTime();
        log.info(String.format("getSurfaceCounts() %.02f ms", (double)(end - start) / 1000000.0));
        return results;
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.worldManager = (WorldManager)this.getSystem(WorldManager.class, true);
        this.world = (World)this.getSystem(World.class, true);
        this.yMax = this.world.getMaxY();
        this.setBlockSet("flowers", "flora.*flower");
        this.setBlockSet("leaves", "leaves.*");
    }

    protected void terminate() {
    }

    public void start() {
    }

    public void update(SimTime time) {
    }

    public void stop() {
    }

    private static /* synthetic */ boolean lambda$setBlockSet$0(Predicate pred, BlockType type) {
        return pred.test(String.valueOf(type.getName()));
    }
}

