/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public abstract class ScaledBuffer {
    public static ScaledBuffer createUnscaledBuffer(int elements) {
        return new PassthroughBuffer(elements);
    }

    public static ScaledBuffer createScaledBuffer(int elements, float min, float max) {
        return new ScaledByteBuffer(elements, min, max);
    }

    public abstract int position();

    public abstract ScaledBuffer put(float var1);

    public abstract ScaledBuffer put(float ... var1);

    public abstract void applyToMesh(Mesh var1, VertexBuffer.Type var2, int var3);

    private static class ScaledByteBuffer
    extends ScaledBuffer {
        private ByteBuffer buffer;
        private float min;
        private float max;
        private float range;

        public ScaledByteBuffer(int elements, float min, float max) {
            this.min = min;
            this.max = max;
            this.range = max - min;
            this.buffer = BufferUtils.createByteBuffer((int)elements);
        }

        private byte scale(float val) {
            return (byte)((val -= this.min) / this.range * 255.0f);
        }

        @Override
        public int position() {
            return this.buffer.position();
        }

        @Override
        public ScaledBuffer put(float value) {
            this.buffer.put(this.scale(value));
            return this;
        }

        @Override
        public ScaledBuffer put(float ... values) {
            for (float f : values) {
                this.put(f);
            }
            return this;
        }

        @Override
        public void applyToMesh(Mesh mesh, VertexBuffer.Type type, int components) {
            mesh.setBuffer(type, components, this.buffer);
            mesh.getBuffer(type).setNormalized(true);
        }
    }

    private static class PassthroughBuffer
    extends ScaledBuffer {
        private FloatBuffer buffer;

        public PassthroughBuffer(int elements) {
            this.buffer = BufferUtils.createFloatBuffer((int)elements);
        }

        @Override
        public int position() {
            return this.buffer.position();
        }

        @Override
        public ScaledBuffer put(float value) {
            this.buffer.put(value);
            return this;
        }

        @Override
        public ScaledBuffer put(float ... value) {
            this.buffer.put(value);
            return this;
        }

        @Override
        public void applyToMesh(Mesh mesh, VertexBuffer.Type type, int components) {
            mesh.setBuffer(type, components, this.buffer);
        }
    }
}

