/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.text.DocumentModel;
import com.simsilica.lemur.text.DocumentModelFilter;
import com.simsilica.lemur.text.TextFilters;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Random;
import mythruna.GameConstants;
import mythruna.client.GuiState;
import mythruna.client.ProgressState;
import mythruna.client.WorldListState;
import mythruna.world.WorldFractalFactory;
import mythruna.world.WorldInfo;
import mythruna.world.WorldLibrary;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateWorldState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CreateWorldState.class);
    private Container window;
    private TextField nameField;
    private Selector<String> fractalField;
    private TextField seedField;
    private Label preview;

    public CreateWorldState() {
        this.setEnabled(false);
    }

    protected void generate() {
        String name = this.getName();
        if (name == null) {
            return;
        }
        Long seed = this.getSeed();
        if (seed == null) {
            return;
        }
        String fractal = this.getFractal();
        if (fractal == null) {
            return;
        }
        WorldLibrary library = ((WorldListState)this.getState(WorldListState.class, true)).getWorldLibrary();
        final WorldInfo info = library.createWorldInfo(name, fractal, seed.longValue());
        final ProgressState progress = (ProgressState)this.getState(ProgressState.class);
        progress.openView((Object)this, "Creating world...");
        ((JobState)this.getState(JobState.class)).execute(new Job(){
            private WorldManager world;

            public void runOnWorker() {
                this.world = WorldManager.createWorld((WorldInfo)info);
            }

            public double runOnUpdate() {
                ((WorldListState)CreateWorldState.this.getState(WorldListState.class)).startWorld(this.world);
                CreateWorldState.this.setEnabled(false);
                progress.releaseView((Object)CreateWorldState.this);
                return 1.0;
            }
        });
    }

    public void cancel() {
        this.setEnabled(false);
    }

    protected void random() {
        Random rand = new Random();
        long l = rand.nextLong();
        this.seedField.setText(String.valueOf(l));
    }

    protected void preview() {
        final Long seed = this.getSeed();
        if (seed == null) {
            return;
        }
        float scale = ((GuiState)this.getState(GuiState.class)).getStandardScale() * this.window.getLocalScale().x;
        this.preview.setText("Generating " + seed + "...");
        ((JobState)this.getState(JobState.class)).execute(new Job(){
            private QuadBackgroundComponent map;

            public void runOnWorker() {
                this.map = WorldListState.createPreview(CreateWorldState.this.getFractal(), seed, GameConstants.MAP_PREVIEW_SIZE, 65536.0);
            }

            public double runOnUpdate() {
                CreateWorldState.this.preview.setIcon((GuiComponent)this.map);
                CreateWorldState.this.preview.setText(null);
                return 1.0;
            }
        });
    }

    protected String getName() {
        String s = this.nameField.getText();
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        return s;
    }

    protected Long parseNumber(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            log.info("Not a number", (Throwable)e);
            return null;
        }
    }

    protected Long parseHex(String value) {
        try {
            return Long.parseLong(value, 16);
        }
        catch (NumberFormatException e) {
            log.info("Not a number", (Throwable)e);
            return null;
        }
    }

    protected Long getSeed() {
        String s = this.seedField.getText();
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        Long result = this.parseNumber(s);
        if (result != null) {
            return result;
        }
        result = this.parseHex(s);
        if (result != null) {
            return result;
        }
        return s.hashCode();
    }

    protected String getFractal() {
        String s = (String)this.fractalField.getSelectedItem();
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        return s;
    }

    protected void initialize(Application app) {
        this.window = new Container(new ElementId("window"));
        this.window.addChild((Node)new Label("Create New World", new ElementId("window.title")), new Object[0]);
        Container properties = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        Function nameFilter = TextFilters.charFilter((Predicate)Predicates.or((Predicate)TextFilters.isLetterOrDigit(), (Predicate)TextFilters.isInChars((char[])new char[]{'_', '-', '.', ' '})));
        DocumentModelFilter nameModel = new DocumentModelFilter(nameFilter, null);
        properties.addChild((Node)new Label("Name:"), new Object[0]);
        this.nameField = (TextField)properties.addChild((Node)new TextField((DocumentModel)nameModel), new Object[]{1});
        this.nameField.setInsets(new Insets3f(2.0f, 2.0f, 2.0f, 2.0f));
        VersionedList fractalTypes = new VersionedList(WorldFractalFactory.getFractalTypes());
        properties.addChild((Node)new Label("Fractal:"), new Object[0]);
        this.fractalField = (Selector)properties.addChild((Node)new Selector(fractalTypes), new Object[]{1});
        properties.addChild((Node)new Label("Seed:"), new Object[0]);
        DocumentModelFilter numeric = new DocumentModelFilter(nameFilter, null);
        this.seedField = (TextField)properties.addChild((Node)new TextField((DocumentModel)numeric), new Object[]{1});
        this.seedField.setInsets(new Insets3f(2.0f, 2.0f, 2.0f, 2.0f));
        Container seedPanel = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Even, FillMode.Even)), new Object[0]);
        seedPanel.setBackground(null);
        seedPanel.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "random")), new Object[0]);
        seedPanel.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "preview")), new Object[0]);
        Texture paper = app.getAssetManager().loadTexture("Interface/paper.jpg");
        this.preview = (Label)this.window.addChild((Node)new Label("Preview", new ElementId("spinner.value")), new Object[0]);
        this.preview.setBackground((GuiComponent)new QuadBackgroundComponent(paper));
        this.preview.setPreferredSize(new Vector3f(384.0f, 384.0f, 1.0f));
        this.preview.setTextHAlignment(HAlignment.Center);
        this.preview.setTextVAlignment(VAlignment.Center);
        this.preview.setInsets(new Insets3f(15.0f, 15.0f, 15.0f, 15.0f));
        this.preview.setColor(new ColorRGBA(0.7f, 0.4f, 0.2f, 1.0f));
        this.preview.setShadowColor(ColorRGBA.Black);
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "generate")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.75f));
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }
}

