/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.OptionPanelState;
import mythruna.GameConstants;
import mythruna.client.MythrunaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarningState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(WarningState.class);
    private static final String LAST_LOOK_KEY = WarningState.class.getSimpleName() + ".lastLook";
    private String version = GameConstants.buildVersion();

    public WarningState() {
        String lastLook = MythrunaConfig.getInstance().getStartupSetting(LAST_LOOK_KEY, "00000000");
        log.info("version:" + this.version + " lastLook:" + lastLook);
        this.setEnabled(this.version.compareTo(lastLook) > 0);
    }

    protected void close() {
        this.setEnabled(false);
        MythrunaConfig.getInstance().getStartupSettings().put(LAST_LOOK_KEY, this.version);
        MythrunaConfig.getInstance();
        MythrunaConfig.save();
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getApplication().enqueue(() -> ((OptionPanelState)this.getState(OptionPanelState.class)).show("Warning: Engine Test Build", "WARNING: This is a test build and not a fully functional game.\n\nTo the best extent possible, the world data format will remain backwards\ncompatible with new engine versions. Sometimes it may be necessary to\nstart a new world to get new features. This will be noted in the \"What's new?\"\npage when it happens.\n\nThe current version of the world fractal is pretty basic when compared to\nits final form but still produces fun results. Towns are pretty random, though.\n'Point of interest' placement will be where the biggest 'future game' impact\nwill be.\n\nThere are plans to have in-game tools to help migrate really cool builds to\nnew worlds, eventually.\n\n      So build with confidence!      Share your screen shots.\n", new Action[]{new CallMethodAction((Object)this, "close")}));
    }

    protected void onDisable() {
    }
}

