/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytePacketOutputStream
extends OutputStream {
    static Logger log = LoggerFactory.getLogger(BytePacketOutputStream.class);
    private int maxPacketSize;
    private List<byte[]> packets = new ArrayList<byte[]>();
    private int totalBytes;
    private ByteArrayOutputStream currentPacket;
    private int currentPacketSize;

    public BytePacketOutputStream(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
        this.currentPacket = new ByteArrayOutputStream();
    }

    public int getBytesWritten() {
        return this.totalBytes;
    }

    public byte[][] toPackets() {
        return (byte[][])this.packets.toArray((T[])new byte[0][]);
    }

    protected void newPacket() {
        this.packets.add(this.currentPacket.toByteArray());
        this.currentPacket = new ByteArrayOutputStream();
        this.currentPacketSize = 0;
    }

    @Override
    public void close() throws IOException {
        this.currentPacket.close();
        if (this.currentPacketSize > 0) {
            this.packets.add(this.currentPacket.toByteArray());
        }
    }

    @Override
    public void write(int b) {
        if (this.currentPacketSize == this.maxPacketSize) {
            this.newPacket();
        }
        this.currentPacket.write(b);
        ++this.currentPacketSize;
        ++this.totalBytes;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        while (len > 0) {
            if (this.currentPacketSize == this.maxPacketSize) {
                this.newPacket();
            }
            int toWrite = Math.min(len, this.maxPacketSize - this.currentPacketSize);
            this.currentPacket.write(b, off, toWrite);
            off += toWrite;
            len -= toWrite;
            this.currentPacketSize += toWrite;
            this.totalBytes += toWrite;
        }
    }
}

