/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.oggtools;

import de.jarnbjo.flac.FlacStream;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.UncachedUrlStream;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class Player {
    private static FlacStream fs;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public static void main(String[] args) {
        System.out.println("JOggPlayer v1.0");
        System.out.println("Please send bug reports to Tor-Einar@Jarnbjo.de");
        System.out.println("");
        if (args.length != 1) {
            System.out.println("Usage: java -jar JOggPlayer.jar <URL>");
            System.exit(0);
        }
        try {
            UncachedUrlStream os = new UncachedUrlStream(new URL(args[0]));
            LogicalOggStream los = (LogicalOggStream)os.getLogicalStreams().iterator().next();
            if (los.getFormat() != "audio/x-vorbis") {
                System.err.println("Not a plain Ogg/Vorbis-file. Unable to play.");
                System.exit(1);
            }
            VorbisStream vs = new VorbisStream(los);
            System.out.println("Title:  " + vs.getCommentHeader().getTitle());
            System.out.println("Artist: " + vs.getCommentHeader().getArtist());
            VorbisInputStream vis = new VorbisInputStream(vs);
            AudioFormat audioFormat = new AudioFormat(vs.getIdentificationHeader().getSampleRate(), 16, vs.getIdentificationHeader().getChannels(), true, true);
            AudioInputStream ais = new AudioInputStream(vis, audioFormat, -1L);
            DataLine.Info dataLineInfo = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = Player.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
            Object gainControl = null;
            sourceDataLine.open(audioFormat);
            sourceDataLine.start();
            byte[] buffer = new byte[8192];
            int cnt = 0;
            while ((cnt = ais.read(buffer, 0, buffer.length)) != -1) {
                if (cnt <= 0) continue;
                sourceDataLine.write(buffer, 0, cnt);
            }
            sourceDataLine.drain();
            sourceDataLine.close();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class VorbisInputStream
    extends InputStream {
        private VorbisStream source;
        private byte[] buffer = new byte[8192];

        public VorbisInputStream(VorbisStream source) {
            this.source = source;
        }

        public int read() throws IOException {
            return 0;
        }

        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                return this.source.readPcm(buffer, offset, length);
            }
            catch (EndOfOggStreamException e) {
                return -1;
            }
        }
    }
}

