/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fx.geom;

import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class TruncatedDome
extends Mesh {
    private int radials;
    private int slices;
    private float innerRadius;
    private float outerRadius;
    private float baseRadius;
    private boolean inside;

    public TruncatedDome(float innerRadius, float outerRadius, int radials, int slices, boolean inside) {
        this.updateGeometry(innerRadius, outerRadius, radials, slices, inside);
    }

    public float getBaseRadius() {
        return this.baseRadius;
    }

    public final void updateGeometry(float innerRadius, float outerRadius, int radials, int slices, boolean inside) {
        int j;
        int i;
        if (this.innerRadius == innerRadius && this.outerRadius == outerRadius && this.radials == radials && this.slices == slices && this.inside == inside) {
            return;
        }
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.radials = radials;
        this.slices = slices;
        this.inside = inside;
        int radialVertCount = radials + 1;
        int elevVertCount = slices;
        int vertCount = radialVertCount * elevVertCount + 1;
        int quadCount = radials * elevVertCount;
        int triCount = 2 * quadCount + radials;
        FloatBuffer pb = this.makeFloatBuffer(VertexBuffer.Type.Position, 3, vertCount);
        FloatBuffer nb = this.makeFloatBuffer(VertexBuffer.Type.Normal, 3, vertCount);
        float[] radialSines = new float[radialVertCount];
        float[] radialCosines = new float[radialVertCount];
        float aDelta = (float)Math.PI * 2 / (float)radials;
        for (int i2 = 0; i2 < radialVertCount; ++i2) {
            radialSines[i2] = FastMath.sin((float)((float)i2 * aDelta));
            radialCosines[i2] = FastMath.cos((float)((float)i2 * aDelta));
        }
        float[] sliceAngles = new float[elevVertCount];
        sliceAngles[0] = 1.5707964f - FastMath.acos((float)(innerRadius / outerRadius));
        this.baseRadius = FastMath.cos((float)sliceAngles[0]) * outerRadius;
        for (i = 1; i < elevVertCount; ++i) {
            float t = 1.0f - (float)i / (float)elevVertCount;
            t *= t;
            float r = this.baseRadius * t;
            sliceAngles[i] = FastMath.acos((float)(r / outerRadius));
        }
        for (i = 0; i < elevVertCount; ++i) {
            float sliceCos = FastMath.cos((float)sliceAngles[i]);
            float sliceSin = FastMath.sin((float)sliceAngles[i]);
            for (j = 0; j < radialVertCount; ++j) {
                float x = radialCosines[j] * sliceCos;
                float y = sliceSin;
                float z = radialSines[j] * sliceCos;
                if (inside) {
                    nb.put(-x).put(-y).put(-z);
                } else {
                    nb.put(x).put(y).put(z);
                }
                pb.put(x * outerRadius);
                pb.put(y * outerRadius - innerRadius);
                pb.put(z * outerRadius);
            }
        }
        nb.put(0.0f).put(inside ? -1.0f : 1.0f).put(0.0f);
        pb.put(0.0f).put(outerRadius - innerRadius).put(0.0f);
        ShortBuffer ib = this.makeShortBuffer(VertexBuffer.Type.Index, 3, triCount);
        for (int i3 = 0; i3 < elevVertCount - 1; ++i3) {
            int next;
            int base;
            if (inside) {
                base = i3 * radialVertCount;
                next = (i3 + 1) * radialVertCount;
            } else {
                next = i3 * radialVertCount;
                base = (i3 + 1) * radialVertCount;
            }
            for (int j2 = 0; j2 < radialVertCount - 1; ++j2) {
                ib.put((short)(base + j2));
                ib.put((short)(base + j2 + 1));
                ib.put((short)(next + j2 + 1));
                ib.put((short)(base + j2));
                ib.put((short)(next + j2 + 1));
                ib.put((short)(next + j2));
            }
        }
        int base = (elevVertCount - 1) * radialVertCount;
        int tip = elevVertCount * radialVertCount;
        for (j = 0; j < radialVertCount - 1; ++j) {
            if (inside) {
                ib.put((short)(base + j));
                ib.put((short)(base + j + 1));
                ib.put((short)tip);
                continue;
            }
            ib.put((short)(base + j));
            ib.put((short)tip);
            ib.put((short)(base + j + 1));
        }
        this.setBuffer(VertexBuffer.Type.Position, 3, pb);
        this.setBuffer(VertexBuffer.Type.Normal, 3, nb);
        this.setBuffer(VertexBuffer.Type.Index, 3, ib);
        this.updateBound();
    }

    protected FloatBuffer makeFloatBuffer(VertexBuffer.Type type, int components, int size) {
        FloatBuffer result = this.getFloatBuffer(type);
        if (result != null && result.capacity() == components * size) {
            result.clear();
            return result;
        }
        result = BufferUtils.createFloatBuffer((int)(components * size));
        return result;
    }

    protected ShortBuffer makeShortBuffer(VertexBuffer.Type type, int components, int size) {
        ShortBuffer result = this.getShortBuffer(type);
        if (result != null && result.capacity() == components * size) {
            result.clear();
            return result;
        }
        result = BufferUtils.createShortBuffer((int)(components * size));
        return result;
    }
}

