/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.crig.RigProtocol;
import com.simsilica.crig.RigType;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.mblock.phys.MBlockShape;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(RigShapeFactory.class);
    private LoadingCache<String, RigType> rigTypes = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, RigType>(){

        public RigType load(String key) {
            return RigShapeFactory.this.loadRigType(key);
        }
    });

    public MBlockShape createShape(String shapeName, double scale, Mass mass) {
        ShapeName name;
        if (log.isTraceEnabled()) {
            log.trace("createShape(" + shapeName + ", " + scale + ", " + mass + ")");
        }
        if (!"rig".equals((name = ShapeName.parse(shapeName)).getType())) {
            return null;
        }
        RigType rigType = (RigType)this.rigTypes.getUnchecked((Object)name.getFullName());
        if (rigType == null) {
            throw new RuntimeException("Rig not found:" + name);
        }
        return rigType.createShape(shapeName, scale, mass);
    }

    protected String rigNameToType(String name) {
        return "/rigs/" + name + ".rt";
    }

    protected RigType loadRigType(String name) {
        String rtName = this.rigNameToType(name);
        try {
            log.info("Loading rig type:" + rtName);
            return RigProtocol.loadRigType((String)rtName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading rig type:" + rtName, e);
        }
    }
}

