/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.action.ActionContext;
import com.simsilica.action.ActionEnvironment;
import com.simsilica.action.ObjectType;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.action.Option;
import com.simsilica.action.PromptProvider;
import com.simsilica.action.PromptType;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.sim.Activator;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameActionSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(GameActionSystem.class);
    private EntityData ed;
    private ObjectTypeRegistry<Activator, EntityId> objectTypes;
    private EntityId worldEntity;
    private WorldActivator activator;
    private ActionEnvironment<Activator, EntityId> actionEnv;
    private ActionContext<Activator, EntityId> worldContext;
    private Thread gameThread;
    private ConcurrentLinkedQueue<Runnable> spool = new ConcurrentLinkedQueue();
    private boolean stopped = false;

    public ObjectType<Activator, EntityId> getType(EntityId entityId) {
        return this.objectTypes.getType((Object)entityId);
    }

    public ActionEnvironment<Activator, EntityId> getWorldEnvironment() {
        return this.actionEnv;
    }

    public void spool(Runnable r) {
        if (this.stopped) {
            this.flush();
            log.info("Stopped, running spooled runnable directly:" + r);
            r.run();
        } else {
            this.spool.add(r);
        }
    }

    public void runAction(EntityId target, String actionName, Object ... parms) {
        if (Thread.currentThread() != this.gameThread) {
            this.getManager().enqueue(() -> {
                try {
                    this.actionEnv.runAction((Object)target, actionName, parms);
                }
                catch (RuntimeException e) {
                    log.error("Error running action:" + actionName + " on target:" + target + " with:" + Arrays.asList(parms), (Throwable)e);
                }
                return null;
            });
        } else {
            this.actionEnv.runAction((Object)target, actionName, parms);
        }
    }

    public void runWorldAction(String actionName, Object ... parms) {
        if (Thread.currentThread() != this.gameThread) {
            this.getManager().enqueue(() -> {
                try {
                    this.worldContext.run(this.actionEnv, actionName, parms);
                }
                catch (RuntimeException e) {
                    log.error("Error running world action:" + actionName + " with:" + Arrays.asList(parms), (Throwable)e);
                }
                return null;
            });
        } else {
            this.worldContext.run(this.actionEnv, actionName, parms);
        }
    }

    public void spoolAction(EntityId target, String actionName, Object ... parms) {
        this.spool.add(() -> {
            try {
                this.actionEnv.runAction((Object)target, actionName, parms);
            }
            catch (RuntimeException e) {
                log.error("Error running spooled action:" + actionName + " on target:" + target + " with:" + Arrays.asList(parms), (Throwable)e);
            }
        });
    }

    public void spoolWorldAction(String actionName, Object ... parms) {
        this.spool.add(() -> {
            try {
                this.worldContext.run(this.actionEnv, actionName, parms);
            }
            catch (RuntimeException e) {
                log.error("Error running spooled world action:" + actionName + " with:" + Arrays.asList(parms), (Throwable)e);
            }
        });
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.objectTypes = (ObjectTypeRegistry)this.getSystem(ObjectTypeRegistry.class, true);
        this.worldEntity = ((WorldManager)this.getSystem(WorldManager.class, true)).getWorldEntity();
        this.activator = new WorldActivator(this.worldEntity);
        this.actionEnv = this.objectTypes.createEnvironment((Object)this.activator);
        this.worldContext = this.objectTypes.getContext((Object)this.worldEntity);
        this.actionEnv.setPromptProvider((PromptProvider)new WorldPrompts(this));
        this.gameThread = Thread.currentThread();
    }

    protected void terminate() {
    }

    public void start() {
        this.stopped = false;
    }

    public void update(SimTime time) {
        Runnable r = this.spool.poll();
        if (r != null) {
            long start = System.nanoTime();
            r.run();
            long end = System.nanoTime();
            if (end - start > 16000000L) {
                log.warn(String.format("Runnable %s took %.03f ms", r, (double)(end - start) / 1000000.0));
            }
        }
    }

    public void stop() {
        this.flush();
        this.stopped = true;
    }

    protected void flush() {
        if (this.spool.size() > 0) {
            log.info("Finishing out spooler, " + this.spool.size() + " items.");
            Runnable r = null;
            while ((r = this.spool.poll()) != null) {
                try {
                    r.run();
                }
                catch (Exception e) {
                    log.error("Error running:" + r, (Throwable)e);
                }
            }
        }
    }

    private class WorldActivator
    implements Activator {
        private EntityId entityId;
        private Map<String, Object> vars;

        public WorldActivator(EntityId entityId) {
            this.entityId = entityId;
        }

        @Override
        public EntityId getId() {
            return this.entityId;
        }

        @Override
        public Vec3d getEyePos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Vec3d getPos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Vec3d getLookDir() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Vec3d getDir() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Quatd getLookOrientation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Quatd getOrientation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<BlockIterator.Intersection> pick(Rayd ray, double limit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T extends EntityComponent> T getAt(Class<T> type) {
            return (T)GameActionSystem.this.ed.getComponent(GameActionSystem.this.worldEntity, type);
        }

        @Override
        public Object getProperty(String name) {
            return this.vars.get(name);
        }

        @Override
        public void setProperty(String name, Object newValue) {
            this.vars.put(name, newValue);
        }
    }

    private class WorldPrompts
    implements PromptProvider<Activator, EntityId> {
        public WorldPrompts(GameActionSystem gameActionSystem) {
        }

        public void showPrompt(EntityId target, PromptType type, String prompt) {
            log.info("showPrompt(" + target + ", " + type + ", " + prompt + ")");
        }

        public void showOptions(EntityId target, List<Option<EntityId>> options) {
            log.warn("showOptions(" + target + ", " + options + ")");
        }

        public void showOptions(EntityId target, List<Option<EntityId>> options, Option<EntityId> closeOption) {
            log.warn("showOptions(" + target + ", " + options + ", " + closeOption + ")");
        }
    }
}

