/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.town;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellUtils;
import com.simsilica.mblock.io.BlockObject;
import com.simsilica.mblock.io.BlocksFileFormat;
import com.simsilica.mworld.BlockData;
import com.simsilica.mworld.BlockDataId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockRegistry
implements Function<BlockDataId, BlockData> {
    static Logger log = LoggerFactory.getLogger(TestBlockRegistry.class);
    private static String BASE_PATH = "/Models/pois/";
    private static BuildingFactory[] allBuildings = new BuildingFactory[]{new BuildingFactory("a-frame-proto.blocks", 1, true), new BuildingFactory("corn-rows.blocks", 1, true), new BuildingFactory("domed-temple.blocks", 1, true), new BuildingFactory("dungeon-stairs.blocks", 10, 9, true), new BuildingFactory("fence-low.blocks", 1, true), new BuildingFactory("fence-tall.blocks", 1, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("giant-skull-insides.blocks", 6, true), new BuildingFactory("graves1.blocks", 1, true), new BuildingFactory("graves2.blocks", 2, true), new BuildingFactory("graves3.blocks", 1, true), new BuildingFactory("graves4.blocks", 1, true), new BuildingFactory("keep1.blocks", 1, true), new BuildingFactory("lg-farmhouse.blocks", 1, true), new BuildingFactory("plowed-rows.blocks", 1, true), new BuildingFactory("pumpkin-altar.blocks", 0, true), new BuildingFactory("roman-temple2.blocks", 1, true), new BuildingFactory("ruined-altar.blocks", 2, 2, true), new BuildingFactory("ruined-altar2.blocks", 2, 2, true), new BuildingFactory("single-tower.blocks", 1, true), new BuildingFactory("small-airport.blocks", 1, true), new BuildingFactory("spawn-tower.blocks", 1, true), new BuildingFactory("stone-canopy.blocks", 1, true), new BuildingFactory("tall-dungeon.blocks", 12, 12, true), new BuildingFactory("test-bldg1.blocks", 1, true), new BuildingFactory("test-bldg2.blocks", 1, true), new BuildingFactory("test-bldg3.blocks", 1, true), new BuildingFactory("test-bldg4.blocks", 1, true), new BuildingFactory("test-bldg5.blocks", 1, true), new BuildingFactory("test-bldg6.blocks", 1, true), new BuildingFactory("test-bldg7.blocks", 1, true), new BuildingFactory("test-bldg8-b.blocks", 2, true), new BuildingFactory("test-bldg8.blocks", 2, true), new BuildingFactory("test-path1.blocks", 1, true), new BuildingFactory("test-path2.blocks", 1, true), new BuildingFactory("thatch-cottage.blocks", 1, true), new BuildingFactory("tower2.blocks", 1, true), new BuildingFactory("ruined-cobble-hut.blocks", 1, true), new BuildingFactory("small-stone-ruin.blocks", 1, true), new BuildingFactory("stone-cairn.blocks", 1, true), new BuildingFactory("tree-stump.blocks", 1, true), new BuildingFactory("tree-stump2.blocks", 1, true), new BuildingFactory("sm-well1.blocks", 3, true), new BuildingFactory("sm-well2.blocks", 3, true)};
    private static BuildingFactory[] testBuildings = new BuildingFactory[]{new BuildingFactory("small-airport.blocks", 1, true), new BuildingFactory("ruined-altar2.blocks", 2, 2, true), new BuildingFactory("tower2.blocks", 1, true), new BuildingFactory("dungeon-stairs.blocks", 10, 9, true), new BuildingFactory("test-bldg1.blocks", 1, true), new BuildingFactory("test-bldg2.blocks", 1, true), new BuildingFactory("test-bldg3.blocks", 1, true), new BuildingFactory("test-bldg4.blocks", 1, true), new BuildingFactory("test-bldg5.blocks", 1, true), new BuildingFactory("test-bldg6.blocks", 1, true), new BuildingFactory("test-bldg7.blocks", 1, true), new BuildingFactory("tall-dungeon.blocks", 12, 12, true), new BuildingFactory("roman-temple2.blocks", 1, true), new BuildingFactory("test-bldg8-b.blocks", 2, true), new BuildingFactory("lg-farmhouse.blocks", 1, true), new BuildingFactory("ruined-altar2.blocks", 2, 2, true), new BuildingFactory("tower2.blocks", 1, true), new BuildingFactory("dungeon-stairs.blocks", 10, 9, true), new BuildingFactory("test-bldg1.blocks", 1, true), new BuildingFactory("test-bldg2.blocks", 1, true), new BuildingFactory("test-bldg3.blocks", 1, true), new BuildingFactory("test-bldg4.blocks", 1, true), new BuildingFactory("test-bldg5.blocks", 1, true), new BuildingFactory("test-bldg6.blocks", 1, true), new BuildingFactory("test-bldg7.blocks", 1, true), new BuildingFactory("tall-dungeon.blocks", 12, 12, true), new BuildingFactory("roman-temple2.blocks", 1, true), new BuildingFactory("test-bldg8-b.blocks", 2, true), new BuildingFactory("ruined-altar2.blocks", 2, 2, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("graves1.blocks", 1, true), new BuildingFactory("graves2.blocks", 2, true), new BuildingFactory("graves3.blocks", 1, true), new BuildingFactory("graves4.blocks", 1, true), new BuildingFactory("test-bldg1.blocks", 1, true), new BuildingFactory("test-bldg2.blocks", 1, true), new BuildingFactory("test-bldg3.blocks", 1, true), new BuildingFactory("test-bldg4.blocks", 1, true), new BuildingFactory("test-bldg5.blocks", 1, true), new BuildingFactory("test-bldg6.blocks", 1, true), new BuildingFactory("test-bldg8-b.blocks", 2, true), new BuildingFactory("ruined-altar2.blocks", 2, 2, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("graves1.blocks", 1, true), new BuildingFactory("graves2.blocks", 2, true), new BuildingFactory("graves3.blocks", 1, true), new BuildingFactory("graves4.blocks", 1, true), new BuildingFactory("test-bldg1.blocks", 1, true), new BuildingFactory("test-bldg2.blocks", 1, true), new BuildingFactory("test-bldg3.blocks", 1, true), new BuildingFactory("test-bldg4.blocks", 1, true), new BuildingFactory("test-bldg5.blocks", 1, true), new BuildingFactory("test-bldg6.blocks", 1, true), new BuildingFactory("test-bldg8-b.blocks", 2, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("graves1.blocks", 1, true), new BuildingFactory("graves2.blocks", 2, true), new BuildingFactory("graves3.blocks", 1, true), new BuildingFactory("graves4.blocks", 1, true), new BuildingFactory("graves1.blocks", 1, true), new BuildingFactory("graves2.blocks", 2, true), new BuildingFactory("graves3.blocks", 1, true), new BuildingFactory("graves4.blocks", 1, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("ruined-altar2.blocks", 2, 2, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("graves1.blocks", 1, true), new BuildingFactory("graves2.blocks", 2, true), new BuildingFactory("graves3.blocks", 1, true), new BuildingFactory("graves4.blocks", 1, true), new BuildingFactory("gallows1.blocks", 1, true), new BuildingFactory("graves1.blocks", 1, true), new BuildingFactory("graves2.blocks", 2, true), new BuildingFactory("graves3.blocks", 1, true), new BuildingFactory("graves4.blocks", 1, true), new BuildingFactory("test-bldg6.blocks", 1, true), new BuildingFactory("small-airport.blocks", 1, true), new BuildingFactory("giant-skull-insides.blocks", 6, true)};
    private static BuildingFactory[] other = new BuildingFactory[]{new BuildingFactory("spawn-tower.blocks", 1, true)};
    private static BuildingFactory[] other2 = new BuildingFactory[]{new BuildingFactory("warehouse2x2-1.blocks", 1, true), new BuildingFactory("warehouse2x2-2.blocks", 1, true), new BuildingFactory("warehouse3x3-1.blocks", 1, true), new BuildingFactory("warehouse3x3-2.blocks", 1, true), new BuildingFactory("warehouse3x3-3.blocks", 1, true), new BuildingFactory("warehouse3x3-4.blocks", 1, true), new BuildingFactory("warehouse4x4-1.blocks", 1, true), new BuildingFactory("warehouse4x4-2.blocks", 1, true), new BuildingFactory("warehouse4x4-3.blocks", 1, true), new BuildingFactory("warehouse4x4-4.blocks", 1, true), new BuildingFactory("SpiritTemple", "spirit-henge.blocks", 1, true), new BuildingFactory("SpiritTemple", "spirit-henge-desert.blocks", 1, true)};
    private Map<BlockDataId, BlockData> index = new HashMap<BlockDataId, BlockData>();
    private ListMultimap<String, BlockDataId> nameIndex = MultimapBuilder.hashKeys().arrayListValues().build();
    private Map<String, BuildingFactory> factoryIndex = new HashMap<String, BuildingFactory>();

    public TestBlockRegistry() {
        BlockData blocks;
        BlockObject bo;
        for (BuildingFactory factory : allBuildings) {
            try {
                bo = BlocksFileFormat.readBlocks((String)(BASE_PATH + factory.name), (boolean)true);
                blocks = new BlockData(bo.cells, null, new Vec3i[0]);
                this.addAllOrientations(factory.name, blocks);
                this.factoryIndex.put(factory.name, factory);
            }
            catch (Exception e) {
                log.error("Error reading blocks:" + factory.name, (Throwable)e);
            }
        }
        for (BuildingFactory factory : testBuildings) {
            try {
                bo = BlocksFileFormat.readBlocks((String)(BASE_PATH + factory.name), (boolean)true);
                blocks = new BlockData(bo.cells, null, new Vec3i[0]);
                this.addAllOrientations(factory.name, blocks);
                this.factoryIndex.put(factory.name, factory);
            }
            catch (Exception e) {
                log.error("Error reading blocks:" + factory.name, (Throwable)e);
            }
        }
        for (BuildingFactory factory : other) {
            try {
                bo = BlocksFileFormat.readBlocks((String)(BASE_PATH + factory.name), (boolean)true);
                blocks = new BlockData(bo.cells, null, new Vec3i[0]);
                this.nameIndex.put((Object)factory.name, (Object)this.add(blocks));
                this.factoryIndex.put(factory.name, factory);
            }
            catch (Exception e) {
                log.error("Error reading blocks:" + factory.name, (Throwable)e);
            }
        }
        for (BuildingFactory factory : other2) {
            try {
                bo = BlocksFileFormat.readBlocks((String)(BASE_PATH + factory.name), (boolean)true);
                blocks = new BlockData(bo.cells, null, new Vec3i[0]);
                this.addAllOrientations(factory.name, blocks);
                this.factoryIndex.put(factory.name, factory);
            }
            catch (Exception e) {
                log.error("Error reading blocks:" + factory.name, (Throwable)e);
            }
        }
    }

    public BuildingFactory getFactory(String name) {
        return this.factoryIndex.get(name);
    }

    public BuildingFactory getFactory(BlockDataId id) {
        for (Map.Entry e : this.nameIndex.entries()) {
            if (!Objects.equals(e.getValue(), id)) continue;
            return this.getFactory((String)e.getKey());
        }
        return null;
    }

    public Vec3i getSize(BlockDataId dataId) {
        BlockData data = this.get(dataId);
        if (data == null) {
            return null;
        }
        return data.getCells().getSize();
    }

    public BuildingFactory getSpawnTower() {
        return other[0];
    }

    public BuildingFactory getRandomBuilding(Random rand) {
        int i = rand.nextInt(testBuildings.length);
        return testBuildings[i];
    }

    public BlockDataId getRandomOrientation(BuildingFactory factory, Random rand) {
        return this.getRandomOrientation(factory.name, rand);
    }

    public BlockDataId getRandomOrientation(String name, Random rand) {
        List<BlockDataId> list = this.find(name);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No orientations mapped for:" + name);
        }
        int i = rand.nextInt(list.size());
        return list.get(i);
    }

    public BlockDataId getRandomFixedFacing(String name, int facing, Random rand) {
        List<BlockDataId> list = this.find(name);
        int flip = rand.nextInt(1);
        return list.get(0);
    }

    public BlockDataId findFirst(String name) {
        List values = this.nameIndex.get((Object)name);
        if (values.isEmpty()) {
            return null;
        }
        return (BlockDataId)values.get(0);
    }

    public List<BlockDataId> find(String name) {
        return this.nameIndex.get((Object)name);
    }

    public int size() {
        return this.index.size();
    }

    @Override
    public BlockData apply(BlockDataId id) {
        return this.index.get(id);
    }

    protected void addAllOrientations(String name, BlockData blocks) {
        this.nameIndex.put((Object)name, (Object)this.add(blocks));
        CellArray cells = blocks.getCells();
        CellArray xformed = null;
        xformed = CellUtils.rotate((CellArray)cells, (int)1);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.rotate((CellArray)cells, (int)2);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.rotate((CellArray)cells, (int)3);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.mirrorX((CellArray)cells);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.mirrorZ((CellArray)cells);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.rotate((CellArray)cells, (int)1);
        xformed = CellUtils.mirrorX((CellArray)xformed);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
        xformed = CellUtils.rotate((CellArray)cells, (int)1);
        xformed = CellUtils.mirrorZ((CellArray)xformed);
        this.nameIndex.put((Object)name, (Object)this.add(new BlockData(xformed, null, new Vec3i[0])));
    }

    public BlockDataId add(BlockData blocks) {
        BlockDataId id = new BlockDataId((long)this.index.size());
        this.index.put(id, blocks);
        return id;
    }

    public BlockData get(BlockDataId id) {
        return this.index.get(id);
    }

    public static class BuildingFactory {
        String name;
        int groundLevel;
        int yOffset;
        boolean aboveGround;
        String typeName;

        public BuildingFactory(String name, int groundLevel, boolean aboveGround) {
            this(name, groundLevel, groundLevel, aboveGround);
        }

        public BuildingFactory(String typeName, String name, int groundLevel, boolean aboveGround) {
            this(typeName, name, groundLevel, groundLevel, aboveGround);
        }

        public BuildingFactory(String name, int groundLevel, int yOffset, boolean aboveGround) {
            this(null, name, groundLevel, yOffset, aboveGround);
        }

        public BuildingFactory(String typeName, String name, int groundLevel, int yOffset, boolean aboveGround) {
            this.typeName = typeName;
            this.name = name;
            this.groundLevel = groundLevel;
            this.yOffset = yOffset;
            this.aboveGround = aboveGround;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("typeName", (Object)this.typeName).add("name", (Object)this.name).add("groundLevel", this.groundLevel).add("yOffset", this.yOffset).add("aboveGround", this.aboveGround).toString();
        }
    }
}

