/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tree;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.tree.AbstractTreeType;
import com.simsilica.mworld.tile.tree.AtlasCell;
import com.simsilica.mworld.tile.tree.TileColumnCells;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeType;
import com.simsilica.mworld.tile.tree.TreeTypeIndex;
import java.io.Serializable;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmbrellaTreeType
extends AbstractTreeType
implements Serializable {
    static Logger log = LoggerFactory.getLogger(UmbrellaTreeType.class);
    static final long serialVersionUID = 42L;
    private static final int RADIUS = 3;
    private static final int WIDTH = 7;
    private static final int[][][] layers = new int[][][]{new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 9, 9, 9, 0, 0}, {0, 0, 9, 9, 9, 0, 0}, {0, 0, 9, 9, 9, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 0, 0, 0, 0, 0}, {0, 0, 8, 8, 8, 0, 0}, {0, 8, 8, 8, 8, 8, 0}, {0, 8, 8, 8, 8, 8, 0}, {0, 8, 8, 8, 8, 8, 0}, {0, 0, 8, 8, 8, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}, new int[][]{{0, 0, 7, 7, 7, 0, 0}, {0, 7, 6, 6, 6, 7, 0}, {7, 6, 4, 4, 4, 6, 7}, {7, 6, 4, 0, 4, 6, 7}, {7, 6, 4, 4, 4, 6, 7}, {0, 7, 6, 6, 6, 7, 0}, {0, 0, 7, 7, 7, 0, 0}}, new int[][]{{0, 0, 5, 5, 5, 0, 0}, {0, 5, 3, 3, 3, 5, 0}, {5, 3, 2, 2, 2, 3, 5}, {5, 3, 2, 0, 2, 3, 5}, {5, 3, 2, 2, 2, 3, 5}, {0, 5, 3, 3, 3, 5, 0}, {0, 0, 5, 5, 5, 0, 0}}};
    private int[][] footprint = new int[][]{{0, 0, 2, 2, 2, 0, 0}, {0, 2, 4, 4, 4, 2, 0}, {2, 4, 6, 6, 6, 4, 2}, {2, 4, 6, 15, 6, 4, 2}, {2, 4, 6, 6, 6, 4, 2}, {0, 2, 4, 4, 4, 2, 0}, {0, 0, 2, 2, 2, 0, 0}};
    private int footprintSize = 7;
    private int footprintOffset = 3;
    private int typeTrunk;
    private int typeLeaves;
    private int[] branches;

    public UmbrellaTreeType(String name, AtlasCell atlasCell) {
        super(name, atlasCell);
    }

    public void initialize(TreeTypeIndex treeTypes) {
        this.typeLeaves = BlockTypeIndex.findType((BlockName)new BlockName("leaves", "leaf")) | TREE_BITS;
        this.typeTrunk = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "vcyl")) | TREE_BITS;
        this.branches = new int[4];
        this.branches[0] = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "branch", Integer.valueOf(2))) | TREE_BITS;
        this.branches[1] = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "branch", Integer.valueOf(3))) | TREE_BITS;
        this.branches[2] = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "branch", Integer.valueOf(0))) | TREE_BITS;
        this.branches[3] = BlockTypeIndex.findType((BlockName)new BlockName("trunk", "branch", Integer.valueOf(1))) | TREE_BITS;
    }

    public boolean markTree(Tree tree, boolean[][] used) {
        int i = tree.x - this.footprintOffset;
        int k = tree.z - this.footprintOffset;
        for (int x = 0; x < this.footprintSize; ++x) {
            for (int z = 0; z < this.footprintSize; ++z) {
                if (this.footprint[x][z] <= 0) continue;
                used[i + x][k + z] = true;
            }
        }
        return true;
    }

    public Tree createTree(short x, short y, short z, TerrainImage terrain, Random rand) {
        int height = rand.nextInt(4) + 8;
        return new Tree(x, y, z, (byte)height, 3, (TreeType)this);
    }

    private void addBranch(int i, int j, int k, int base, CellData cells, Direction dir) {
        Vec3i v = dir.getVec3i();
        int x = v.x;
        int z = v.z;
        cells.setCell(i + x, j, k + z, this.branches[dir.getCardinalDirection()]);
        cells.setCell(i + x + x, j, k + z + z, this.typeLeaves);
        cells.setCell(i + x + x, j + 1, k + z + z, this.typeLeaves);
        cells.setCell(i + x, j + 1, k + z, this.typeLeaves);
        cells.setCell(i + x - z, j + 1, k + z - x, this.typeLeaves);
        cells.setCell(i + x + z, j + 1, k + z + x, this.typeLeaves);
    }

    private void addLayer(int[][] layer, int i, int j, int k, CellData cells, Random rand) {
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                int r = layer[x][z];
                if (r == 0) continue;
                if (r == 9) {
                    cells.setCell(i + x - 3, j, k + z - 3, this.typeLeaves);
                    continue;
                }
                int chance = rand.nextInt(9);
                if (chance >= r) continue;
                cells.setCell(i + x - 3, j, k + z - 3, this.typeLeaves);
            }
        }
    }

    public boolean insertTree(Tree tree, TileColumnCells cells, Random rand) {
        byte height = tree.height;
        int start = tree.y;
        int end = tree.y + height;
        short i = tree.x;
        short k = tree.z;
        for (int y = start; y < end - 1; ++y) {
            cells.setCell((int)i, y, (int)k, this.typeTrunk);
        }
        int[] heights = new int[]{rand.nextInt(height - 4) + 1, rand.nextInt(height - 4) + 1, rand.nextInt(height - 4) + 1, rand.nextInt(height - 4) + 1};
        this.addBranch(i, start + heights[0], k, start, (CellData)cells, Direction.North);
        this.addBranch(i, start + heights[1], k, start, (CellData)cells, Direction.South);
        this.addBranch(i, start + heights[2], k, start, (CellData)cells, Direction.East);
        this.addBranch(i, start + heights[3], k, start, (CellData)cells, Direction.West);
        int level = end - 1;
        this.addLayer(layers[0], i, level--, k, (CellData)cells, rand);
        this.addLayer(layers[1], i, level--, k, (CellData)cells, rand);
        while (level >= start + 3) {
            this.addLayer(layers[2], i, level--, k, (CellData)cells, rand);
        }
        this.addLayer(layers[3], i, level--, k, (CellData)cells, rand);
        return true;
    }

    public boolean insertTree(Tree tree, TerrainImage terrain) {
        int i = tree.x - this.footprintOffset;
        int k = tree.z - this.footprintOffset;
        for (int x = 0; x < this.footprintSize; ++x) {
            for (int z = 0; z < this.footprintSize; ++z) {
                if (this.footprint[x][z] == 0) continue;
                terrain.updateLight(i + x, k + z, (byte)(-this.footprint[x][z]));
            }
        }
        return true;
    }

    public boolean isBlock(Tree tree, int x, int y, int z, int type) {
        int layer;
        if (x < -tree.radius || z < -tree.radius) {
            return false;
        }
        if (x > tree.radius || z > tree.radius) {
            return false;
        }
        if (y < 0 || y > tree.height) {
            return false;
        }
        byte height = tree.height;
        if (x == 0 && z == 0) {
            if (y >= height - 2) {
                return type == MaskUtils.getType((int)this.typeLeaves);
            }
            return type == MaskUtils.getType((int)this.typeTrunk);
        }
        if (y >= 1 && y <= height - 3) {
            if (x == 0) {
                if (z == 1) {
                    if (type == MaskUtils.getType((int)this.typeLeaves)) {
                        return true;
                    }
                    return type == MaskUtils.getType((int)this.branches[Direction.South.getCardinalDirection()]);
                }
                if (z == -1) {
                    if (type == MaskUtils.getType((int)this.typeLeaves)) {
                        return true;
                    }
                    return type == MaskUtils.getType((int)this.branches[Direction.North.getCardinalDirection()]);
                }
            } else if (z == 0) {
                if (x == 1) {
                    if (type == MaskUtils.getType((int)this.typeLeaves)) {
                        return true;
                    }
                    return type == MaskUtils.getType((int)this.branches[Direction.East.getCardinalDirection()]);
                }
                if (x == -1) {
                    if (type == MaskUtils.getType((int)this.typeLeaves)) {
                        return true;
                    }
                    return type == MaskUtils.getType((int)this.branches[Direction.West.getCardinalDirection()]);
                }
            }
        }
        if (y >= height - 2) {
            layer = height - 1 - y;
        } else if (y >= 3) {
            layer = 2;
        } else if (y == 2) {
            layer = 3;
        } else {
            return false;
        }
        int val = layers[layer][x + 3][z + 3];
        if (val == 0) {
            return false;
        }
        return type == MaskUtils.getType((int)this.typeLeaves);
    }
}

