
// Some default clothing designs that we give to all players

findDefaultClothingDesigns = {
    def parent = worldManager.worldEntity;
    def filter = Filters.fieldEquals(ClothingInfo.class, "parent", parent);
    return entityData.findEntities(filter, ClothingInfo.class);
}

findClothingDesign = { parent, name ->
    def filter1 = Filters.fieldEquals(ClothingInfo.class, "parent", parent);
    def filter2 = Filters.fieldEquals(ClothingInfo.class, "name", name);
    return entityData.findEntity(Filters.and(ClothingInfo.class, filter1, filter2), ClothingInfo.class);
}

createDefaultClothingDesign = { String designName, String itemName, String cellResource ->
    if( cellResource.charAt(0) != '/' ) {
        // Make an assumption
        cellResource = "/Models/clothes/" + cellResource;
    }
    def parent = worldManager.worldEntity;
    def cellId = importClothingResource(cellResource);

    log.info("Imported:" + designName + "  cellResource:" + cellResource + "  as cellId:" + cellId);

    // See if we already have one
    def entity = findClothingDesign(worldManager.worldEntity, designName);
    if( entity == null ) {
        // Create the entity
        entity = entityData.createEntity();
    }

    // We're going to reset the data either way
    def info = new ClothingInfo(parent, designName);
    def shapeName = new ShapeName("fab", cellId.toIdString());

    entityData.setComponents(entity,
            info,
            ObjectName.create(itemName),
            ObjectTypeInfo.create("ClothingDesign"),
            ShapeInfo.create(shapeName.toCompositeString(), 1),
            new CreatedBy(parent)
            );

    return entity;
}

copyClothingDesign = { EntityId design, EntityId target ->
    def info = design[ClothingInfo];
    if( info == null ) {
        throw new IllegalArgumentException("Entity is not a clothing design:" + design);
    }
    // See if it already exists in the target
    def entity = findClothingDesign(target, info.getName());
    if( entity != null ) {
        log.info("Player:" + target + " already has clothing design:" + info);
        // So let's not blow away any changes they might have made
        return entity;
    } else {
        log.info("Creating:" + info + " on player:" + target);
        entity = entityData.createEntity();
    }
    entityData.setComponents(entity,
        info.changeParent(target),
        design[ObjectName],
        design[ObjectTypeInfo],
        design[ShapeInfo],
        design[CreatedBy]
        );
    return entity;
}

if( true ) {
    log.info("Creating default clothing designs...");
    createDefaultClothingDesign("Basic Boots", "Boots", "basic-boots.clothing");
    createDefaultClothingDesign("Basic Pants", "Pants", "basic-pants.clothing");
    createDefaultClothingDesign("Basic Shirt", "Shirt", "basic-shirt.clothing");
    createDefaultClothingDesign("Basic Tunic", "Tunic", "basic-tunic.clothing");
    createDefaultClothingDesign("Underwear - Top", "Bra", "bra.clothing");
    createDefaultClothingDesign("Cuffed Boots", "Boots", "cuffed-boots.clothing");
    createDefaultClothingDesign("Underwear - Bottom", "Panties", "panties.clothing");
    createDefaultClothingDesign("Pants With Belt", "Pants", "pants-with-belt.clothing");
    createDefaultClothingDesign("Right Bracer", "Bracer", "right-bracer.clothing");
    createDefaultClothingDesign("Shirt Vest", "Shirt", "shirt-vest.clothing");
    createDefaultClothingDesign("Silver Necklace", "Necklace", "silver-necklace.clothing");

    createDefaultClothingDesign("Fur Shirt", "Shirt", "open-fur-shirt.clothing");
    createDefaultClothingDesign("T-Shirt", "Shirt", "t-shirt.clothing");
    createDefaultClothingDesign("Open Shirt", "Shirt", "open-shirt-vest.clothing");
    createDefaultClothingDesign("High Boots", "Boots", "thigh-high-boots.clothing");
    createDefaultClothingDesign("Sash", "Sash", "tartan-sash.clothing");
    createDefaultClothingDesign("Chain Necklace", "Necklace", "chain-necklace.clothing");
    createDefaultClothingDesign("Chain Pendant", "Necklace", "chain-pendant.clothing");
    createDefaultClothingDesign("Metal Bracers", "Bracers", "metal-bracers.clothing");
    createDefaultClothingDesign("Left Bracer", "Bracer", "left-bracer.clothing");
    createDefaultClothingDesign("Leather Bracers", "Bracers", "leather-bracers.clothing");
    createDefaultClothingDesign("Shoes", "Shoes", "aged-leather-shoes.clothing");

    createDefaultClothingDesign("Burlap Shirt", "Burlap Shirt", "burlap-shirt.clothing");
    createDefaultClothingDesign("Burlap Shorts", "Burlap Shorts", "burlap-shorts.clothing");

    // Some "for internal use" searchable clothing designs
    createDefaultClothingDesign("human-female-underwear", "!private!", "human-female-underwear.clothing");
    createDefaultClothingDesign("human-male-underwear", "!private!", "human-male-underwear.clothing");
    createDefaultClothingDesign("human-female-starter", "!private!", "human-female-starter.clothing");
    createDefaultClothingDesign("human-male-starter", "!private!", "human-male-starter.clothing");
}

// When a player entity is created, we want to add some
// standard clothing for them.
on( playerEntityCreated ) { event ->
    // Copy the standard clothing
    log.info("Adding default clothing designs to:" + event.player);
    //def shirt = null;
    //def shorts = null;
    findDefaultClothingDesigns().each {
        log.info("(AppearanceSystem) Clothing design:" + it + "  name:" + it.name);
        if( "!private!" == it.name ) {
            return;
        }
        def item = copyClothingDesign(it, event.player);
        //if( "Burlap Shirt" == it.name ) {
        //    shirt = item;
        //} else if( "Burlap Shorts" == it.name ) {
        //    shorts = item;
        //}
    }
}

on( playerEntityJoining ) { event ->

    // Here we could check some version info or something to see if we need to
    // update to a newer set of clothing designs... or just iterate and copy missing ones or
    // something.

    // Is the player naked?
    def wearing = getWornItems(event.player);
    if( wearing.isEmpty() ) {

        // See if there is a shirt design
        def shirt = findClothingDesign(event.player, "Burlap Shirt");
        def shorts = findClothingDesign(event.player, "Burlap Shorts");

        int index = wearing.size();
        // Add some default clothing based on race
        if( shirt != null ) {
            log.info("Auto-wearing:" + shirt.name);
            shirt << new WornBy(resolveEntityId(event.player), index);
            index++;
        }
        if( shorts != null ) {
            log.info("Auto-wearing:" + shorts.name);
            shorts << new WornBy(resolveEntityId(event.player), index);
            index++;
        }
    }

}
