/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly.io;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import mythruna.assembly.Joint;
import mythruna.assembly.Subassembly;
import mythruna.assembly.io.PolyTypeAdapterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubassemblyJson {
    static Logger log = LoggerFactory.getLogger(SubassemblyJson.class);
    private static SubassemblyJson instance = new SubassemblyJson();
    private Gson gson;

    public SubassemblyJson() {
        this.initializeGson();
    }

    protected void initializeGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)PolyTypeAdapterFactory.create(Subassembly.class));
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)PolyTypeAdapterFactory.create(Joint.class));
        this.gson = gsonBuilder.create();
    }

    public String toJson(Subassembly blockSet) {
        return this.gson.toJson((Object)blockSet);
    }

    public Subassembly fromJson(String json) {
        return (Subassembly)this.gson.fromJson(json, Subassembly.class);
    }

    public static SubassemblyJson getInstance() {
        return instance;
    }

    public static Subassembly load(File f) {
        try {
            String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
            return instance.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + f, e);
        }
    }

    public static Subassembly loadResource(String resource) {
        try {
            String json = Resources.toString((URL)SubassemblyJson.class.getResource(resource), (Charset)Charsets.UTF_8);
            return instance.fromJson(json);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + resource, e);
        }
    }

    public static void store(Subassembly assembly, File f) {
        try {
            String json = instance.toJson(assembly);
            Files.write((CharSequence)json, (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
    }
}

