/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es.quest;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.PersistentComponent;
import mythruna.world.WorldTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quest
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(Quest.class);
    private EntityId questGiver;
    private EntityId parentQuest;
    private EntityId quester;
    private double createdTime;
    private double statusTime;
    private int status;

    private Quest() {
    }

    public Quest(EntityId questGiver, WorldTime createdTime) {
        this(questGiver, createdTime.getTotalGameSeconds());
    }

    public Quest(EntityId questGiver, double createdTime) {
        this.questGiver = questGiver;
        this.createdTime = createdTime;
        this.statusTime = createdTime;
    }

    public Quest(EntityId questGiver, EntityId parentQuest, EntityId quester, WorldTime createdTime, WorldTime statusTime, int status) {
        this(questGiver, parentQuest, quester, createdTime.getTotalGameSeconds(), statusTime.getTotalGameSeconds(), status);
    }

    public Quest(EntityId questGiver, EntityId parentQuest, EntityId quester, double createdTime, double statusTime, int status) {
        this.questGiver = questGiver;
        this.parentQuest = parentQuest;
        this.quester = quester;
        this.createdTime = createdTime;
        this.statusTime = statusTime;
        this.status = status;
    }

    public static ComponentFilter<Quest> questGiverFilter(EntityId questGiver) {
        return Filters.fieldEquals(Quest.class, (String)"questGiver", (Object)questGiver);
    }

    public static ComponentFilter<Quest> questerFilter(EntityId quester) {
        return Filters.fieldEquals(Quest.class, (String)"quester", (Object)quester);
    }

    public static ComponentFilter<Quest> childFilter(EntityId parentQuest) {
        return Filters.fieldEquals(Quest.class, (String)"parentQuest", (Object)parentQuest);
    }

    public static ComponentFilter<Quest> childFilter(EntityId parentQuest, EntityId quester) {
        return Filters.and(Quest.class, (ComponentFilter[])new ComponentFilter[]{Quest.childFilter(parentQuest), Quest.questerFilter(quester)});
    }

    public static ComponentFilter<Quest> specificQuestFilter(EntityId questGiver, EntityId quester) {
        return Filters.and(Quest.class, (ComponentFilter[])new ComponentFilter[]{Quest.questGiverFilter(questGiver), Quest.questerFilter(quester)});
    }

    public Quest createChild(EntityId parentQuest, EntityId quester, WorldTime createdTime) {
        return new Quest(this.questGiver, parentQuest, quester, createdTime, createdTime, this.status);
    }

    public Quest updateStatus(int status, WorldTime statusTime) {
        return new Quest(this.questGiver, this.parentQuest, this.quester, this.createdTime, statusTime.getTotalGameSeconds(), status);
    }

    public EntityId getQuestGiver() {
        return this.questGiver;
    }

    public EntityId getParentQuest() {
        return this.parentQuest;
    }

    public EntityId getQuester() {
        return this.quester;
    }

    public WorldTime getCreatedTime() {
        return new WorldTime(this.createdTime);
    }

    public WorldTime getStatusTime() {
        return new WorldTime(this.statusTime);
    }

    public int getStatus() {
        return this.status;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("questGiver", (Object)this.questGiver).add("parentQuest", (Object)this.parentQuest).add("quester", (Object)this.quester).add("createdTime", this.createdTime).add("statusTime", this.statusTime).add("status", this.status).toString();
    }
}

