/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.crig.RigShape;
import com.simsilica.crig.sim.AnimPump;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockContact;
import mythruna.sim.Activity;
import mythruna.sim.SwingMotion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingLeftActivity
implements Activity {
    static Logger log = LoggerFactory.getLogger(SwingLeftActivity.class);
    private RigShape rigShape;
    private AnimPump animPump;
    private double speed = 1.0;
    private double pitch = 0.5;
    private double kinematicScale = 0.0;
    private SwingMotion motion;
    private boolean blocked;

    public SwingLeftActivity(RigShape rigShape, AnimPump animPump) {
        this.rigShape = rigShape;
        this.animPump = animPump;
        this.motion = new SwingMotion(0.1, 0.2, 0.3, 0.1);
    }

    @Override
    public double getKinematicScale() {
        return this.kinematicScale;
    }

    @Override
    public void reset() {
        this.motion.reset();
        this.blocked = false;
    }

    @Override
    public void newContact(MBlockContact<EntityId> contact, int type1, int type2, Vec3d kVelocity) {
        this.blocked = true;
    }

    protected double smoothStep(double t) {
        if (t < 0.0) {
            return 0.0;
        }
        if (t > 1.0) {
            return 1.0;
        }
        return t * t * (3.0 - 2.0 * t);
    }

    @Override
    public void update(long frameTime, double step, Vec3d view) {
        if (this.blocked) {
            this.motion.blocked();
            this.blocked = false;
        }
        this.motion.update(step * this.speed);
        double min = -0.8031;
        double mid = -0.2831;
        double max = 0.3286;
        this.pitch = view.y < min ? 0.0 : (view.y < mid ? 0.5 * (view.y - min) / (mid - min) : (view.y < max ? 0.5 + 0.5 * (view.y - mid) / (max - mid) : 1.0));
        double x = this.motion.getSwingTime();
        double leadInPart = this.motion.getLeadInPercent();
        double y = leadInPart * this.pitch;
        this.kinematicScale = this.motion.getStrength();
        this.animPump.setCurrentAction("Swing", 0.0);
        this.animPump.setTime(x);
        this.rigShape.setMix("Swing", y);
        this.rigShape.update();
    }
}

