/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.post;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnderwaterFilter
extends Filter {
    static Logger log = LoggerFactory.getLogger(UnderwaterFilter.class);
    private float blurDistance = 20.0f;
    private float blurScale = 2.0f;
    private boolean debugUnfocus;
    private ColorRGBA baseColor = new ColorRGBA(0.75f, 0.8f, 1.0f, 1.0f);
    private ColorRGBA depthColor = new ColorRGBA(0.1f, 0.1f, 0.5f, 1.0f);
    private float attenuationDistance = 128.0f;
    private float waterLevel = 0.0f;
    private boolean debugAttenuation;
    private boolean debugBrightness;
    private float xScale;
    private float yScale;

    public void setBlurScale(float f) {
        this.blurScale = f;
        if (this.material != null) {
            this.material.setFloat("XScale", this.blurScale * this.xScale);
            this.material.setFloat("YScale", this.blurScale * this.yScale);
        }
    }

    public float getBlurScale() {
        return this.blurScale;
    }

    public void setBlurDistance(float f) {
        this.blurDistance = f;
        if (this.material != null) {
            this.material.setFloat("BlurDistance", this.blurDistance);
        }
    }

    public float getBlurDistance() {
        return this.blurDistance;
    }

    public void setAttenuationDistance(float f) {
        this.attenuationDistance = f;
        if (this.material != null) {
            this.material.setFloat("AttenuationDistance", this.attenuationDistance);
        }
    }

    public float getAttenuationDistance() {
        return this.attenuationDistance;
    }

    public void setWaterLevel(float waterLevel) {
        this.waterLevel = waterLevel;
        if (this.material != null) {
            this.material.setFloat("WaterLevel", waterLevel);
        }
    }

    public float getWaterLevel() {
        return this.waterLevel;
    }

    public void setDebugUnfocus(boolean b) {
        this.debugUnfocus = b;
        if (this.material != null) {
            this.material.setBoolean("DebugUnfocus", this.debugUnfocus);
        }
    }

    public boolean getDebugUnfocus() {
        return this.debugUnfocus;
    }

    public void setDebugAttenuation(boolean b) {
        this.debugAttenuation = b;
        if (this.material != null) {
            this.material.setBoolean("DebugAttenuation", this.debugAttenuation);
        }
    }

    public boolean getDebugAttenuation() {
        return this.debugAttenuation;
    }

    public void setDebugBrightness(boolean b) {
        this.debugBrightness = b;
        if (this.material != null) {
            this.material.setBoolean("DebugBrightness", this.debugBrightness);
        }
    }

    public boolean getDebugBrightness() {
        return this.debugBrightness;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected Material getMaterial() {
        return this.material;
    }

    protected void initFilter(AssetManager assets, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(assets, "MatDefs/Post/Underwater.j3md");
        this.material.setFloat("BlurDistance", this.blurDistance);
        this.xScale = 1.0f / (float)w;
        this.yScale = 1.0f / (float)h;
        this.material.setFloat("XScale", this.blurScale * this.xScale);
        this.material.setFloat("YScale", this.blurScale * this.yScale);
        this.material.setColor("BaseColor", this.baseColor);
        this.material.setColor("DepthColor", this.depthColor);
        this.material.setFloat("AttenuationDistance", this.attenuationDistance);
        this.material.setFloat("WaterLevel", this.waterLevel);
    }
}

