
import mythruna.net.server.AccountHostedService;

on( playerEntityJoined ) { event ->

    def account = AccountHostedService.getAccount(event.connection);
    if( !account ) {
        return;
    }
    log.info("Entity joined for account:" + account);

    def backpack = findItem(event.player, "Backpack");
    log.info("found backpack:" + backpack);

    def perms = account.getProperty("permissions", List.class);
    log.info("perms:" + perms);

    if( perms?.contains("admin") || perms?.contains("singlePlayer") ) {
        log.info("Need to add admin/singlePlayer tools to player:" + account.getName());

        createItem("Extractor Wand", "Extractor", new ContainedIn(event.player, backpack, 20, 7));
    }
}
