/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.server;

import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.MessageListener;
import com.jme3.network.Server;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.es.server.EntityHostSettings;
import com.simsilica.es.server.HostedEntityData;
import com.simsilica.es.server.SessionDataDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDataHostService
implements EntityHostSettings {
    static Logger log = LoggerFactory.getLogger(EntityDataHostService.class);
    private final Server server;
    private final int channel;
    private final ObservableEntityData ed;
    private boolean autoHost = true;
    private int maxEntityBatchSize = 20;
    private int maxChangeBatchSize = 20;
    private final ConnectionObserver connectionObserver;

    public EntityDataHostService(Server server, int channel, ObservableEntityData ed) {
        this.server = server;
        this.channel = channel;
        this.ed = ed;
        this.connectionObserver = new ConnectionObserver();
        server.addConnectionListener((ConnectionListener)this.connectionObserver);
        SessionDataDelegator delegator = new SessionDataDelegator(HostedEntityData.class, "hostedEntityData", true);
        server.addMessageListener((MessageListener)delegator, delegator.getMessageTypes());
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    public void sendUpdates() {
        for (HostedConnection conn : this.server.getConnections()) {
            HostedEntityData hed = (HostedEntityData)conn.getAttribute("hostedEntityData");
            if (hed == null) continue;
            hed.sendUpdates();
        }
    }

    public void stop() {
        this.server.removeConnectionListener((ConnectionListener)this.connectionObserver);
        for (HostedConnection conn : this.server.getConnections()) {
            this.stopHostingOnConnection(conn);
        }
    }

    public void startHostingOnConnection(HostedConnection hc) {
        log.debug("startHostingOnConnection:" + hc);
        hc.setAttribute("hostedEntityData", (Object)new HostedEntityData(this, hc, this.ed));
    }

    public void stopHostingOnConnection(HostedConnection hc) {
        HostedEntityData hed = (HostedEntityData)hc.getAttribute("hostedEntityData");
        if (hed == null) {
            return;
        }
        log.debug("stopHostingOnConnection:" + hc);
        hc.setAttribute("hostedEntityData", null);
        hed.close();
    }

    public void setMaxEntityBatchSize(int i) {
        this.maxEntityBatchSize = i;
    }

    @Override
    public int getMaxEntityBatchSize() {
        return this.maxEntityBatchSize;
    }

    public void setMaxChangeBatchSize(int i) {
        this.maxChangeBatchSize = i;
    }

    @Override
    public int getMaxChangeBatchSize() {
        return this.maxChangeBatchSize;
    }

    public void setAutoHost(boolean b) {
        this.autoHost = b;
    }

    public boolean getAutoHost() {
        return this.autoHost;
    }

    protected void addConnection(HostedConnection hc) {
        log.debug("Connection added:" + hc);
        if (this.autoHost) {
            this.startHostingOnConnection(hc);
        }
    }

    protected void removeConnection(HostedConnection hc) {
        log.debug("Connection removed:" + hc);
        this.stopHostingOnConnection(hc);
    }

    protected class ConnectionObserver
    implements ConnectionListener {
        protected ConnectionObserver() {
        }

        public void connectionAdded(Server server, HostedConnection hc) {
            EntityDataHostService.this.addConnection(hc);
        }

        public void connectionRemoved(Server server, HostedConnection hc) {
            EntityDataHostService.this.removeConnection(hc);
        }
    }
}

