/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.app.state.BaseAppState;
import com.jme3.util.SafeArrayList;

public class CompositeAppState
extends BaseAppState {
    private final SafeArrayList<AppStateEntry> states = new SafeArrayList(AppStateEntry.class);
    private boolean childrenEnabled;
    private AppStateManager stateManager;
    private boolean attached;

    public CompositeAppState(AppState ... states) {
        for (AppState a : states) {
            this.states.add((Object)new AppStateEntry(a, false));
        }
    }

    private int indexOf(AppState state) {
        for (int i = 0; i < this.states.size(); ++i) {
            AppStateEntry e = (AppStateEntry)this.states.get(i);
            if (e.state != state) continue;
            return i;
        }
        return -1;
    }

    private AppStateEntry entry(AppState state) {
        for (AppStateEntry e : (AppStateEntry[])this.states.getArray()) {
            if (e.state != state) continue;
            return e;
        }
        return null;
    }

    protected <T extends AppState> T addChild(T state) {
        return this.addChild(state, false);
    }

    protected <T extends AppState> T addChild(T state, boolean overrideEnable) {
        if (this.indexOf(state) >= 0) {
            return state;
        }
        this.states.add((Object)new AppStateEntry(state, overrideEnable));
        if (this.attached) {
            this.stateManager.attach(state);
        }
        return state;
    }

    protected void removeChild(AppState state) {
        int index = this.indexOf(state);
        if (index < 0) {
            return;
        }
        this.states.remove(index);
        if (this.attached) {
            this.stateManager.detach(state);
        }
    }

    protected <T extends AppState> T getChild(Class<T> stateType) {
        for (AppStateEntry e : (AppStateEntry[])this.states.getArray()) {
            if (!stateType.isInstance(e.state)) continue;
            return (T)((AppState)stateType.cast(e.state));
        }
        return null;
    }

    protected void clearChildren() {
        for (AppStateEntry e : (AppStateEntry[])this.states.getArray()) {
            this.removeChild(e.state);
        }
    }

    public void stateAttached(AppStateManager stateManager) {
        this.stateManager = stateManager;
        for (AppStateEntry e : (AppStateEntry[])this.states.getArray()) {
            stateManager.attach(e.state);
        }
        this.attached = true;
    }

    public void stateDetached(AppStateManager stateManager) {
        for (int i = this.states.size() - 1; i >= 0; --i) {
            stateManager.detach(((AppStateEntry)this.states.get((int)i)).state);
        }
        this.attached = false;
        this.stateManager = null;
    }

    protected void setChildrenEnabled(boolean b) {
        if (this.childrenEnabled == b) {
            return;
        }
        this.childrenEnabled = b;
        for (AppStateEntry e : (AppStateEntry[])this.states.getArray()) {
            e.setEnabled(b);
        }
    }

    public void setOverrideEnabled(AppState state, boolean override) {
        AppStateEntry e = this.entry(state);
        if (e == null) {
            throw new IllegalArgumentException("State not managed:" + state);
        }
        if (override) {
            e.override = true;
        } else {
            e.override = false;
            e.state.setEnabled(this.isEnabled());
        }
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.setChildrenEnabled(true);
    }

    protected void onDisable() {
        this.setChildrenEnabled(false);
    }

    private class AppStateEntry {
        AppState state;
        boolean enabled;
        boolean override;

        public AppStateEntry(AppState state, boolean overrideEnable) {
            this.state = state;
            this.override = overrideEnable;
            this.enabled = state.isEnabled();
        }

        public void setEnabled(boolean b) {
            if (this.override) {
                if (b) {
                    this.state.setEnabled(this.enabled);
                } else {
                    this.enabled = this.state.isEnabled();
                    this.state.setEnabled(false);
                }
            } else {
                this.state.setEnabled(b);
            }
        }
    }
}

