/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.character;

import com.jme3.scene.Spatial;
import com.simsilica.crig.CharacterRig;
import mythruna.client.character.CharacterDecorator;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDecorator
implements CharacterDecorator {
    static Logger log = LoggerFactory.getLogger(CompositeDecorator.class);
    private CharacterDecorator[] delegates;

    public CompositeDecorator(CharacterDecorator ... delegates) {
        this.delegates = delegates;
    }

    @Override
    public void setRig(CharacterRig rig) {
        for (CharacterDecorator delegate : this.delegates) {
            delegate.setRig(rig);
        }
    }

    @Override
    public void setSpatial(Spatial spatial) {
        for (CharacterDecorator delegate : this.delegates) {
            delegate.setSpatial(spatial);
        }
    }

    @Override
    public void setShapeName(ShapeName name) {
        for (CharacterDecorator delegate : this.delegates) {
            delegate.setShapeName(name);
        }
    }

    @Override
    public boolean apply() {
        boolean result = false;
        for (CharacterDecorator delegate : this.delegates) {
            if (!delegate.apply()) continue;
            result = true;
        }
        return result;
    }
}

