/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.character;

import com.google.common.collect.Ordering;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.WatchedEntity;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.ColorChooser;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import mythruna.character.BodyConfig;
import mythruna.character.BodyConfigIndex;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.character.CharacterFunctions;
import mythruna.client.ui.clothing.ClothingItem;
import mythruna.client.view.object.Model;
import mythruna.client.view.object.ModelViewState;
import mythruna.es.ClothingInfo;
import mythruna.es.HairColor;
import mythruna.es.ObjectName;
import mythruna.es.Race;
import mythruna.es.SkinColor;
import mythruna.es.WornBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterMenuState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CharacterMenuState.class);
    public static final ColorRGBA DEFAULT_HAIR_COLOR = new ColorRGBA(0.29803923f, 0.08627451f, 0.03529412f, 1.0f);
    public static final ColorRGBA DEFAULT_SKIN_COLOR = new ColorRGBA(0.6313726f, 0.4745098f, 0.28235295f, 1.0f);
    private GameSessionState sessionState;
    private EntityData ed;
    private EntityId player;
    private Node rootNode = new Node("character");
    private Spatial background;
    private Node platform = new Node("platform");
    private Vector2f screenSize = new Vector2f();
    private Vector2f center = new Vector2f();
    private Node avatar = new Node("character");
    private InputHandler inputHandler = new InputHandler();
    private float yaw = 0.7853982f;
    private float pitch = 0.39f;
    private float minPitch = 0.0f;
    private float maxPitch = 1.4137167f;
    private float yOffset = -200.0f;
    private GeometryFactory geomFactory;
    private CellArray groundCells = new CellArray(1, 1, 1);
    private Container sidebar;
    private AvailableClothingContainer availableClothes;
    private Container selectionWindow;
    private VersionedList<ClothingItem> designList = new VersionedList();
    private ListBox<ClothingItem> designs;
    private ActionButton doWear;
    private WornClothingContainer wornClothes;
    private Container wearingWindow;
    private VersionedList<ClothingItem> wearingList = new VersionedList();
    private ListBox<ClothingItem> wearing;
    private ActionButton doRemove;
    private boolean resortWearing = false;
    private Container appearanceWindow;
    private WatchedEntity characterEntity;
    private ColorPicker skinPicker;
    private ColorPicker hairPicker;
    private int updateFrames = -1;

    public CharacterMenuState() {
        this(false);
    }

    public CharacterMenuState(boolean enabled) {
        this.setEnabled(enabled);
    }

    protected void wear() {
        ClothingItem item = (ClothingItem)this.designs.getSelectedItem();
        log.info("wear():" + item);
        if (item == null) {
            return;
        }
        this.sessionState.getGameSession().runAction(item.getId(), "Wear", new Object[0]);
    }

    protected void unwear() {
        log.info("unwear()");
        ClothingItem item = (ClothingItem)this.wearing.getSelectedItem();
        log.info("unwear():" + item);
        if (item == null) {
            return;
        }
        this.sessionState.getGameSession().runAction(item.getId(), "Remove", new Object[0]);
    }

    protected void initialize(Application app) {
        BodyConfig config;
        if (this.getState(PlayerMenuState.class) != null) {
            ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu("Character", (AppState)this);
        }
        this.sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = this.sessionState.getEntityData();
        this.player = this.sessionState.getGameSession().getAvatar();
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getGeometryFactory();
        this.availableClothes = new AvailableClothingContainer(this.player, this.ed);
        this.wornClothes = new WornClothingContainer(this.player, this.ed);
        this.screenSize.set(((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize());
        this.center.set(this.screenSize).multLocal(0.5f);
        log.info("center:" + this.center);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        CharacterFunctions.initializeDefaultMappings(inputMapper);
        inputMapper.addAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{CharacterFunctions.F_PAN, CharacterFunctions.F_CRANE, CharacterFunctions.F_ZOOM});
        this.sidebar = new Container();
        float minWidth = 300.0f;
        this.selectionWindow = (Container)this.sidebar.addChild((Node)new Container(new ElementId("window")), new Object[0]);
        this.selectionWindow.setInsets(new Insets3f(0.0f, 0.0f, 20.0f, 0.0f));
        Label label = (Label)this.selectionWindow.addChild((Node)new Label("Clothing Selector", new ElementId("window.title")), new Object[0]);
        Vector3f pref = label.getPreferredSize();
        pref.x = Math.max(minWidth, pref.x);
        label.setPreferredSize(pref);
        this.designs = (ListBox)this.selectionWindow.addChild((Node)new ListBox(this.designList), new Object[0]);
        Container buttons = (Container)this.selectionWindow.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        this.doWear = (ActionButton)buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Wear", (Object)this, "wear")), new Object[0]);
        this.wearingWindow = (Container)this.sidebar.addChild((Node)new Container(new ElementId("window")), new Object[0]);
        this.wearingWindow.addChild((Node)new Label("Wearing", new ElementId("window.title")), new Object[0]);
        this.wearing = (ListBox)this.wearingWindow.addChild((Node)new ListBox(this.wearingList), new Object[0]);
        buttons = (Container)this.wearingWindow.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        this.doRemove = (ActionButton)buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Remove", (Object)this, "unwear")), new Object[0]);
        this.appearanceWindow = (Container)this.sidebar.addChild((Node)new Container(new ElementId("window")), new Object[0]);
        this.appearanceWindow.addChild((Node)new Label("Appearance", new ElementId("window.title")), new Object[0]);
        BodyConfigIndex configs = BodyConfigIndex.create(id -> this.sessionState.getDataSession().getText(id));
        Race race = (Race)this.ed.getComponent(this.player, Race.class);
        ColorRGBA defaultSkin = DEFAULT_SKIN_COLOR;
        ColorRGBA defaultHair = DEFAULT_HAIR_COLOR;
        BodyConfig bodyConfig = config = race == null ? null : configs.getFirst(race.getTypeName(this.ed));
        if (config != null) {
            defaultSkin = config.getSkinColor();
            defaultHair = config.getHairColor();
        }
        Container props = (Container)this.appearanceWindow.addChild((Node)new Container(), new Object[0]);
        props.addChild((Node)new Label("Skin:"), new Object[0]);
        this.skinPicker = new ColorPicker(defaultSkin, color -> this.sessionState.getGameSession().runAction(this.player, "setSkinColor", new Object[]{new SkinColor(color)}));
        props.addChild((Node)this.skinPicker.button, new Object[]{1});
        props.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this.skinPicker, "reset")), new Object[]{2});
        props.addChild((Node)new Label("Hair:"), new Object[0]);
        this.hairPicker = new ColorPicker(defaultHair, color -> this.sessionState.getGameSession().runAction(this.player, "setHairColor", new Object[]{new HairColor(color)}));
        props.addChild((Node)this.hairPicker.button, new Object[]{1});
        props.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this.hairPicker, "reset")), new Object[]{2});
        this.background = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).createVignette();
        this.rootNode.attachChild(this.background);
        this.rootNode.attachChild((Spatial)this.platform);
        float percent = 0.8f;
        float scale = this.screenSize.y * percent * 0.5f;
        this.platform.setLocalScale(scale);
        this.yOffset = -0.9f;
        this.avatar.move(0.0f, this.yOffset, 0.0f);
        this.platform.attachChild((Spatial)this.avatar);
        int grass = BlockTypeIndex.findType((BlockName)new BlockName("grass", "cube"));
        int topsOnly = MaskUtils.setSideMask((int)grass, (int)16);
        this.groundCells.clear(topsOnly);
        Node ground = new Node("ground");
        ground.move((float)(-this.groundCells.getSizeX()) * 0.5f, (float)(-this.groundCells.getSizeY()), (float)(-this.groundCells.getSizeZ()) * 0.5f);
        ground.move(0.0f, this.yOffset, 0.0f);
        this.geomFactory.generateBlocks(ground, this.groundCells, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        this.platform.attachChild((Spatial)ground);
    }

    protected void cleanup(Application app) {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{CharacterFunctions.F_PAN, CharacterFunctions.F_CRANE, CharacterFunctions.F_ZOOM});
    }

    protected void onEnable() {
        this.characterEntity = this.ed.watchEntity(this.player, new Class[]{SkinColor.class, HairColor.class});
        this.resetAppearanceColors();
        this.availableClothes.start();
        this.wornClothes.start();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup("Character");
        ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot().attachChild((Spatial)this.rootNode);
        log.info("world bound:" + this.avatar.getWorldBound());
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.sidebar);
        this.updateLayout();
        this.resetModel();
    }

    protected void resetModel() {
        log.info("resetModel()");
        Model model = ((ModelViewState)this.getState(ModelViewState.class)).getModel(this.player);
        if (model == null || model.getSpatial() == null) {
            return;
        }
        Spatial clone = model.getSpatial().clone(false);
        clone.setLocalTranslation(0.0f, 0.0f, 0.0f);
        clone.setLocalRotation(new Quaternion());
        this.avatar.detachAllChildren();
        this.avatar.attachChild(clone);
        this.updateRotation();
    }

    protected void updateLayout() {
        float x = this.screenSize.x * 0.95f;
        float y = this.screenSize.y * 0.95f;
        Vector3f pref = this.sidebar.getPreferredSize();
        this.sidebar.setLocalTranslation(x - pref.x, y, 0.0f);
    }

    public void update(float tpf) {
        if (this.availableClothes.update()) {
            this.updateLayout();
        }
        if (this.wornClothes.update()) {
            this.updateLayout();
        }
        if (this.resortWearing) {
            this.resortWearing();
        }
        if (this.characterEntity.applyChanges()) {
            this.resetAppearanceColors();
        }
        this.skinPicker.update();
        this.hairPicker.update();
    }

    protected void onDisable() {
        this.characterEntity.release();
        this.characterEntity = null;
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup("Character");
        this.rootNode.removeFromParent();
        this.sidebar.removeFromParent();
        this.availableClothes.stop();
        this.wornClothes.stop();
    }

    protected void updateRotation() {
        Quaternion rot = new Quaternion().fromAngles(this.pitch, 0.0f, 0.0f);
        rot.multLocal(new Quaternion().fromAngles(0.0f, this.yaw, 0.0f));
        this.platform.setLocalRotation(rot);
        this.platform.setLocalTranslation(this.center.x, this.center.y, 0.0f);
    }

    protected void resetAppearanceColors() {
        SkinColor skin = (SkinColor)this.characterEntity.get(SkinColor.class);
        this.skinPicker.updateSelectedColor(skin == null ? null : skin.getColor());
        HairColor hair = (HairColor)this.characterEntity.get(HairColor.class);
        this.hairPicker.updateSelectedColor(hair == null ? null : hair.getColor());
    }

    protected void resortWearing() {
        this.resortWearing = false;
        Collections.sort(this.wearingList, this.wornClothes.comparator);
    }

    protected Vector3f getTopLeft(Panel p, Panel popup) {
        Vector3f pos = p.getWorldTranslation().clone();
        log.info("getTopLeft() world:" + pos);
        Vector3f scaled = GuiGlobals.getInstance().getPopupState().screenToGui(pos);
        Vector2f guiSize = GuiGlobals.getInstance().getPopupState().getGuiSize();
        Vector3f size = popup.getSize();
        if (size.x == 0.0f) {
            size = popup.getPreferredSize();
        }
        log.info("scaled:" + scaled + "  guiSize:" + guiSize + "  size:" + size);
        if (scaled.x + size.x > guiSize.x) {
            scaled.x = guiSize.x - size.x;
            log.info("Adjusted x to:" + scaled.x);
        }
        return scaled;
    }

    private class InputHandler
    implements AnalogFunctionListener,
    StateFunctionListener {
        private InputHandler() {
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == CharacterFunctions.F_PAN) {
                CharacterMenuState.this.yaw = (float)((double)CharacterMenuState.this.yaw + -value * tpf);
                if (CharacterMenuState.this.yaw < 0.0f) {
                    CharacterMenuState.this.yaw += (float)Math.PI * 2;
                } else if (CharacterMenuState.this.yaw >= (float)Math.PI * 2) {
                    CharacterMenuState.this.yaw -= (float)Math.PI * 2;
                }
                CharacterMenuState.this.updateRotation();
            } else if (func == CharacterFunctions.F_CRANE) {
                CharacterMenuState.this.pitch = (float)((double)CharacterMenuState.this.pitch + value * tpf);
                if (CharacterMenuState.this.pitch < CharacterMenuState.this.minPitch) {
                    CharacterMenuState.this.pitch = CharacterMenuState.this.minPitch;
                } else if (CharacterMenuState.this.pitch > CharacterMenuState.this.maxPitch) {
                    CharacterMenuState.this.pitch = CharacterMenuState.this.maxPitch;
                }
                CharacterMenuState.this.updateRotation();
            } else {
                log.info("unhandled id:" + func);
            }
        }
    }

    private class AvailableClothingContainer
    extends EntityContainer<ClothingItem> {
        private Comparator<? super ClothingItem> comparator;

        public AvailableClothingContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{ClothingInfo.class, ShapeInfo.class, ObjectName.class});
            this.comparator = Ordering.usingToString();
            ComponentFilter filter = Filters.fieldEquals(ClothingInfo.class, (String)"parent", (Object)player);
            this.setFilter(filter);
        }

        protected ClothingItem addObject(Entity e) {
            log.info("AvailableClothingContainer.addObject(" + e + ")");
            ClothingItem object = new ClothingItem(e);
            this.updateObject(object, e);
            if (this.comparator != null) {
                int index = Collections.binarySearch(CharacterMenuState.this.designList, object, this.comparator);
                if (index < 0) {
                    index = -(index + 1);
                }
                CharacterMenuState.this.designList.add(index, (Object)object);
            } else {
                CharacterMenuState.this.designList.add((Object)object);
            }
            return object;
        }

        protected void updateObject(ClothingItem object, Entity e) {
            log.info("AvailableClothingContainer.updateObject(" + e + ")");
            object.update(CharacterMenuState.this.ed);
        }

        protected void removeObject(ClothingItem object, Entity e) {
            log.info("AvailableClothingContainer.removeObject(" + e + ")");
            CharacterMenuState.this.designList.remove((Object)object);
        }
    }

    private class WornClothingContainer
    extends EntityContainer<ClothingItem> {
        private Comparator<? super ClothingItem> comparator;

        public WornClothingContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{WornBy.class, ClothingInfo.class, ShapeInfo.class, ObjectName.class});
            this.comparator = new LayerSorter(CharacterMenuState.this);
            ComponentFilter filter = Filters.fieldEquals(WornBy.class, (String)"target", (Object)player);
            this.setFilter(filter);
        }

        protected ClothingItem addObject(Entity e) {
            log.info("WornClothingContainer.addObject(" + e + ")");
            ClothingItem object = new ClothingItem(e);
            this.updateObject(object, e);
            CharacterMenuState.this.wearingList.add((Object)object);
            CharacterMenuState.this.resortWearing = true;
            return object;
        }

        protected void updateObject(ClothingItem object, Entity e) {
            log.info("WornClothingContainer.updateObject(" + e + ")");
            WornBy original = object.getWornBy();
            object.update(CharacterMenuState.this.ed);
            if (!Objects.equals(original, object.getWornBy())) {
                CharacterMenuState.this.resortWearing = true;
            }
        }

        protected void removeObject(ClothingItem object, Entity e) {
            log.info("WornClothingContainer.removeObject(" + e + ")");
            CharacterMenuState.this.resortWearing = true;
            CharacterMenuState.this.wearingList.remove((Object)object);
        }
    }

    private class ColorPicker {
        ActionButton button;
        private Container popup;
        private ColorChooser chooser;
        private VersionedReference<ColorRGBA> colorRef;
        private ColorRGBA defaultColor;
        private ColorRGBA color = new ColorRGBA();
        private QuadBackgroundComponent colorBackground;
        private Consumer<ColorRGBA> callback;

        public ColorPicker(ColorRGBA defaultColor, Consumer<ColorRGBA> callback) {
            this.defaultColor = defaultColor;
            this.callback = callback;
            this.color.set(defaultColor);
            ElementId baseId = new ElementId("form");
            this.popup = new Container(baseId.child("popup"));
            this.chooser = (ColorChooser)this.popup.addChild((Node)new ColorChooser(baseId.child("colorChooser")), new Object[0]);
            Container buttons = new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.First, FillMode.None));
            this.popup.addChild((Node)buttons, new Object[0]);
            buttons.addChild((Node)new Label(""), new Object[0]);
            buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Ok", (Object)this, "closePopup")), new Object[0]);
            this.colorRef = this.chooser.getModel().createReference();
            this.button = new ActionButton((Action)new CallMethodAction("", (Object)this, "openPopup"), baseId.child("value.color.button"));
            this.colorBackground = new QuadBackgroundComponent(this.color);
            this.button.setBackground((GuiComponent)this.colorBackground);
        }

        public void reset() {
            this.color.set(this.defaultColor);
            this.callback.accept(this.color);
        }

        public void update() {
            if (this.colorRef.update()) {
                this.callback.accept((ColorRGBA)this.colorRef.get());
            }
        }

        public void updateSelectedColor(ColorRGBA color) {
            if (color == null) {
                this.reset();
                return;
            }
            this.color.set(color);
        }

        public void openPopup() {
            Vector3f pos = CharacterMenuState.this.getTopLeft((Panel)this.button, (Panel)this.popup);
            this.popup.setLocalTranslation(pos);
            this.chooser.setColor(this.color);
            GuiGlobals.getInstance().getPopupState().showPopup((Spatial)this.popup);
        }

        public void closePopup() {
            this.popup.removeFromParent();
        }
    }

    private class LayerSorter
    implements Comparator<ClothingItem> {
        private LayerSorter(CharacterMenuState characterMenuState) {
        }

        @Override
        public int compare(ClothingItem item1, ClothingItem item2) {
            int layer2;
            if (item1 == item2) {
                return 0;
            }
            int layer1 = item1.getLayer();
            int result = Integer.compare(layer1, layer2 = item2.getLayer());
            if (result != 0) {
                return result;
            }
            return Long.compare(item1.getId().getId(), item2.getId().getId());
        }
    }
}

