/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.path;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.IOException;
import mythruna.world.path.RoadSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadSectionProtocol
implements ObjectProtocol<RoadSection> {
    static Logger log = LoggerFactory.getLogger(RoadSectionProtocol.class);
    public static final int X_BITS = 32;
    public static final int Y_BITS = 10;
    public static final int Z_BITS = 32;
    public static final int TYPE_BITS = 8;
    public static final int WIDTH_BITS = 7;
    private int version = 0;

    public int getProtocolVersion() {
        return this.version;
    }

    public void write(RoadSection data, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 8);
        Vec3i start = data.getStart();
        Vec3i end = data.getEnd();
        out.writeBits(start.x, 32);
        out.writeBits(start.y, 10);
        out.writeBits(start.z, 32);
        out.writeBits(end.x, 32);
        out.writeBits(end.y, 10);
        out.writeBits(end.z, 32);
        out.writeBits(data.getWidth(), 7);
        out.writeBits(data.getType(), 8);
    }

    public RoadSection read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        int x = in.readBits(32);
        int y = in.readBits(10);
        int z = in.readBits(32);
        Vec3i start = new Vec3i(x, y, z);
        x = in.readBits(32);
        y = in.readBits(10);
        z = in.readBits(32);
        Vec3i end = new Vec3i(x, y, z);
        int width = in.readBits(7);
        int type = in.readBits(8);
        return new RoadSection(start, end, width, type);
    }
}

