/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.jme3.scene.Node;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import mythruna.client.net.character.CharacterEditor;
import mythruna.client.net.character.CharacterPage;
import mythruna.client.ui.MarkdownUtil;
import mythruna.net.DataSession;

public abstract class AbstractCharacterPage
extends Container
implements CharacterPage {
    public static final ElementId ELEMENT_ID = new ElementId("book.page");
    private CharacterEditor editor;
    private String name;
    private Entity character;
    private boolean enabled;
    private Action[] nextActions;

    protected AbstractCharacterPage(String name) {
        this(name, MarkdownUtil.createLayout(), ELEMENT_ID);
    }

    protected AbstractCharacterPage(String name, GuiLayout layout) {
        this(name, layout, ELEMENT_ID);
    }

    protected AbstractCharacterPage(String name, ElementId elementId) {
        this(name, MarkdownUtil.createLayout(), elementId);
    }

    protected AbstractCharacterPage(String name, GuiLayout layout, ElementId elementId) {
        super(layout, elementId);
        this.name = name;
        this.setNextActions(new Action[]{new CallMethodAction("Continue", (Object)this, "nextPage")});
    }

    @Override
    public final void initialize(CharacterEditor editor) {
        this.editor = editor;
        this.onInitialize(editor);
    }

    protected CharacterEditor getCharacterEditor() {
        return this.editor;
    }

    protected DataSession getDataSession() {
        return this.editor.getDataSession();
    }

    protected void onInitialize(CharacterEditor editor) {
    }

    public void setParent(Node parent) {
        super.setParent(parent);
        if (parent == null) {
            this.onDetach();
        } else {
            this.onAttach();
        }
    }

    protected void onAttach() {
    }

    protected void onDetach() {
    }

    @Override
    public final void setCharacter(Entity character) {
        this.character = character;
        this.enabled = this.onSetCharacter(character);
    }

    protected Entity getCharacter() {
        return this.character;
    }

    protected boolean onSetCharacter(Entity character) {
        return character != null;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Panel getPanel() {
        return this;
    }

    @Override
    public Panel getView() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void nextPage() {
        if (this.editor != null) {
            this.editor.nextPage();
        }
    }

    protected void setNextActions(Action ... nextActions) {
        this.nextActions = nextActions;
    }

    @Override
    public Action[] getNextActions() {
        return this.nextActions;
    }

    protected <T extends EntityComponent> T getBaseComponent(Class<T> type) {
        return this.editor.getBaseComponent(type);
    }

    protected <T extends EntityComponent> T getComponent(Class<T> type) {
        EntityComponent result = this.character.get(type);
        if (result != null) {
            return (T)result;
        }
        return this.getBaseComponent(type);
    }

    protected void setComponent(EntityComponent component) {
        this.editor.setComponent(component);
    }

    protected EntityComponent[] getComponents() {
        return this.character.getComponents();
    }

    protected EntityData getEntityData() {
        return this.editor.getEntityData();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + "]";
    }
}

