/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.jme3.scene.Node;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import mythruna.client.ui.clothing.ClothingBuilder;
import mythruna.client.ui.clothing.FabricTypeSelector;
import mythruna.client.ui.clothing.SearchReplaceEdit;
import mythruna.client.ui.edit.EditHistory;
import mythruna.fabric.FabricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchReplaceDialog
extends Container {
    static Logger log = LoggerFactory.getLogger(SearchReplaceDialog.class);
    private ClothingBuilder builder;
    private EditHistory history;
    private FabricTypeSelector searchSelector;
    private VersionedReference<FabricType> searchRef;
    private FabricTypeSelector replaceSelector;
    private VersionedReference<FabricType> replaceRef;

    public SearchReplaceDialog(ClothingBuilder builder, EditHistory history) {
        super(new ElementId("window"));
        this.builder = builder;
        this.history = history;
        this.addChild((Node)new Label("Search/replace Material", this.getElementId().child("title")), new Object[0]);
        this.addChild((Node)new Label("Find:"), new Object[0]);
        this.searchSelector = (FabricTypeSelector)this.addChild((Node)new FabricTypeSelector(), new Object[0]);
        this.searchRef = this.searchSelector.createSelectedTypeRef();
        this.addChild((Node)new Label("Replace with:"), new Object[0]);
        this.replaceSelector = (FabricTypeSelector)this.addChild((Node)new FabricTypeSelector(), new Object[0]);
        this.replaceRef = this.replaceSelector.createSelectedTypeRef();
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "replace")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    public void replace() {
        int find = this.searchSelector.getSelectedType();
        int replace = this.replaceSelector.getSelectedType();
        log.info("find:" + find + "  replace with:" + replace);
        this.history.accept(new SearchReplaceEdit(this.builder, find, replace));
        this.removeFromParent();
    }

    public void cancel() {
        this.removeFromParent();
    }
}

