/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.navigation;

import jme3tools.navigation.GCSailing;
import jme3tools.navigation.InvalidPositionException;
import jme3tools.navigation.Position;
import jme3tools.navigation.RLSailing;

public class NavCalculator {
    private double distance;
    private double trueCourse;
    public static final int WGS84_EARTH_RADIUS = 6378137;
    private String strCourse;
    public static final int MERCATOR = 0;
    public static final int GC = 1;
    public static final int RL_CRS_PRECISION = 1;
    public static final int RL_DIST_PRECISION = 1;
    public static final int METERS_PER_MINUTE = 1852;

    public NavCalculator(Position P1, Position P2, int calcType) {
        switch (calcType) {
            case 0: {
                this.mercatorSailing(P1, P2);
                break;
            }
            case 1: {
                this.greatCircleSailing(P1, P2);
            }
        }
    }

    public NavCalculator() {
    }

    public GCSailing greatCircleSailing(Position p1, Position p2) {
        return new GCSailing(new int[0], new float[0]);
    }

    public RLSailing rhumbLineSailing(Position p1, Position p2) {
        RLSailing rl = this.mercatorSailing(p1, p2);
        return rl;
    }

    public RLSailing mercatorSailing(Position p1, Position p2) {
        double dLat = NavCalculator.computeDLat(p1.getLatitude(), p2.getLatitude());
        if (dLat == 0.0) {
            RLSailing rl = this.planeSailing(p1, p2);
            return rl;
        }
        double dLong = NavCalculator.computeDLong(p1.getLongitude(), p2.getLongitude());
        double dmp = (float)NavCalculator.computeDMPClarkeSpheroid(p1.getLatitude(), p2.getLatitude());
        this.trueCourse = (float)Math.toDegrees(Math.atan(dLong / dmp));
        double degCrs = NavCalculator.convertCourse((float)this.trueCourse, p1, p2);
        this.distance = (float)Math.abs(dLat / Math.cos(Math.toRadians(this.trueCourse)));
        RLSailing rl = new RLSailing(degCrs, (float)this.distance);
        this.trueCourse = rl.getCourse();
        this.strCourse = dLat < 0.0 ? "S" : "N";
        this.strCourse = this.strCourse + " " + this.trueCourse;
        this.strCourse = this.strCourse + " " + (dLong < 0.0 ? "W" : "E");
        return rl;
    }

    public RLSailing planeSailing(Position p1, Position p2) {
        double dLong = NavCalculator.computeDLong(p1.getLongitude(), p2.getLongitude());
        double sgnDLong = 0.0 - dLong / Math.abs(dLong);
        if (Math.abs(dLong) > 10800.0) {
            dLong = (21600.0 - Math.abs(dLong)) * sgnDLong;
        }
        double redist = 0.0;
        double recourse = 0.0;
        redist = p1.getLatitude() == 0.0 ? Math.abs(dLong) : Math.abs(dLong * (double)((float)Math.cos(p1.getLatitude() * 2.0 * Math.PI / 360.0)));
        recourse = (float)Math.asin(0.0 - sgnDLong);
        if ((recourse = recourse * 360.0 / 2.0 / 3.1415927410125732) < 0.0) {
            recourse += 360.0;
        }
        return new RLSailing(recourse, redist);
    }

    public static double convertCourse(float tc, Position p1, Position p2) {
        double dLat = p1.getLatitude() - p2.getLatitude();
        double dLong = p1.getLongitude() - p2.getLongitude();
        if (dLong >= 0.0 & dLat >= 0.0) {
            return Math.abs(tc);
        }
        if (dLong >= 0.0 & dLat < 0.0) {
            return 180.0f - Math.abs(tc);
        }
        if (dLong < 0.0 & dLat < 0.0) {
            return 180.0f + Math.abs(tc);
        }
        if (dLong < 0.0 & dLat >= 0.0) {
            return 360.0f - Math.abs(tc);
        }
        return -1.0;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getTrueCourse() {
        return this.trueCourse;
    }

    public String getStrCourse() {
        return this.strCourse;
    }

    public static double computeDMPClarkeSpheroid(double lat1, double lat2) {
        double absLat1 = Math.abs(lat1);
        double absLat2 = Math.abs(lat2);
        double m1 = 7915.704468 * (Math.log(Math.tan(Math.toRadians(45.0 + absLat1 / 2.0))) / Math.log(10.0)) - 23.268932 * Math.sin(Math.toRadians(absLat1)) - 0.0525 * Math.pow(Math.sin(Math.toRadians(absLat1)), 3.0) - 2.13E-4 * Math.pow(Math.sin(Math.toRadians(absLat1)), 5.0);
        double m2 = 7915.704468 * (Math.log(Math.tan(Math.toRadians(45.0 + absLat2 / 2.0))) / Math.log(10.0)) - 23.268932 * Math.sin(Math.toRadians(absLat2)) - 0.0525 * Math.pow(Math.sin(Math.toRadians(absLat2)), 3.0) - 2.13E-4 * Math.pow(Math.sin(Math.toRadians(absLat2)), 5.0);
        if (lat1 <= 0.0 && lat2 <= 0.0 || lat1 > 0.0 && lat2 > 0.0) {
            return Math.abs(m1 - m2);
        }
        return m1 + m2;
    }

    public static float computeDMPWGS84Spheroid(float lat1, float lat2) {
        float absLat1 = Math.abs(lat1);
        float absLat2 = Math.abs(lat2);
        float m1 = (float)(7915.7045 * Math.log10(Math.tan(Math.toRadians(45.0f + absLat1 / 2.0f))) - 23.01358 * Math.sin((double)absLat1 - 0.05135) * Math.pow(Math.sin(absLat1), 3.0));
        float m2 = (float)(7915.7045 * Math.log10(Math.tan(Math.toRadians(45.0f + absLat2 / 2.0f))) - 23.01358 * Math.sin((double)absLat2 - 0.05135) * Math.pow(Math.sin(absLat2), 3.0));
        if (lat1 <= 0.0f & lat2 <= 0.0f || lat1 > 0.0f & lat2 > 0.0f) {
            return Math.abs(m1 - m2);
        }
        return m1 + m2;
    }

    public static Position predictPosition(int time, double speed, double currentLat, double currentLong, double course) {
        Position futurePosition = null;
        course = Math.toRadians(course);
        double futureLong = currentLong + speed * (double)time * Math.sin(course);
        double futureLat = currentLat + speed * (double)time * Math.cos(course);
        try {
            futurePosition = new Position(futureLat, futureLong);
        }
        catch (InvalidPositionException ipe) {
            ipe.printStackTrace();
        }
        return futurePosition;
    }

    public static Position computePosition(Position initialPos, double heading, double distance) {
        double diff;
        if (initialPos == null) {
            return null;
        }
        double angle = heading < 90.0 ? heading : (heading > 90.0 && heading < 180.0 ? 180.0 - heading : (heading > 180.0 && heading < 270.0 ? heading - 180.0 : 360.0 - heading));
        Position newPosition = null;
        angle = Math.toRadians(angle);
        double initialLat = initialPos.getLatitude();
        double initialLong = initialPos.getLongitude();
        double dlat = (distance *= 5.39956803E-4) * Math.cos(angle);
        dlat /= 60.0;
        dlat = Math.abs(dlat);
        double newLat = 0.0;
        if (heading > 270.0 && heading < 360.0 || heading > 0.0 && heading < 90.0) {
            newLat = initialLat + dlat;
        } else if (heading < 270.0 && heading > 90.0) {
            newLat = initialLat - dlat;
        }
        double meanLat = Math.abs(dlat) / 2.0 + newLat;
        double dep = Math.abs(dlat * 60.0) * Math.tan(angle);
        double dlong = dep * (1.0 / Math.cos(Math.toRadians(meanLat)));
        dlong /= 60.0;
        dlong = Math.abs(dlong);
        double newLong = heading > 180.0 && heading < 360.0 ? initialLong - dlong : initialLong + dlong;
        if (newLong < -180.0) {
            diff = Math.abs(newLong + 180.0);
            newLong = 180.0 - diff;
        }
        if (newLong > 180.0) {
            diff = Math.abs(newLong + 180.0);
            newLong = (180.0 - diff) * -1.0;
        }
        if (heading == 0.0 || heading == 360.0 || heading == 180.0) {
            newLong = initialLong;
            newLat = initialLat + dlat;
        } else if (heading == 90.0 || heading == 270.0) {
            newLat = initialLat;
            newLong = initialLong - dlong;
        }
        try {
            newPosition = new Position(newLat, newLong);
        }
        catch (InvalidPositionException ipe) {
            ipe.printStackTrace();
            System.out.println(newLat + "," + newLong);
        }
        return newPosition;
    }

    public static double computeDLong(double lng1, double lng2) {
        if (lng1 - lng2 == 0.0) {
            return 0.0;
        }
        if (lng1 >= 0.0 & lng2 >= 0.0) {
            return -(lng1 - lng2) * 60.0;
        }
        if (lng1 < 0.0 & lng2 < 0.0) {
            return -(lng1 - lng2) * 60.0;
        }
        if (Math.abs(lng1) + Math.abs(lng2) < 180.0) {
            if (lng1 < 0.0 & lng2 > 0.0) {
                return -(Math.abs(lng1) + Math.abs(lng2)) * 60.0;
            }
            return Math.abs(lng1) + Math.abs(lng2) * 60.0;
        }
        if (lng1 < 0.0 & lng2 > 0.0) {
            return -(360.0 - (Math.abs(lng1) + Math.abs(lng2))) * 60.0;
        }
        return (360.0 - (Math.abs(lng1) + Math.abs(lng2))) * 60.0;
    }

    public static double computeLongDiff(double lng1, double lng2) {
        if (lng1 - lng2 == 0.0) {
            return 0.0;
        }
        if (lng1 >= 0.0 & lng2 >= 0.0) {
            return Math.abs(-(lng1 - lng2) * 60.0);
        }
        if (lng1 < 0.0 & lng2 < 0.0) {
            return Math.abs(-(lng1 - lng2) * 60.0);
        }
        if (lng1 == 0.0) {
            return Math.abs(lng2 * 60.0);
        }
        if (lng2 == 0.0) {
            return Math.abs(lng1 * 60.0);
        }
        return (Math.abs(lng1) + Math.abs(lng2)) * 60.0;
    }

    public static double computeDLat(double lat1, double lat2) {
        if (lat1 - lat2 == 0.0) {
            return 0.0;
        }
        if (lat1 >= 0.0 & lat2 >= 0.0) {
            return -(lat1 - lat2) * 60.0;
        }
        if (lat1 < 0.0 & lat2 < 0.0) {
            return -(lat1 - lat2) * 60.0;
        }
        if (lat1 >= 0.0) {
            return -(Math.abs(lat1) + Math.abs(lat2));
        }
        return Math.abs(lat1) + Math.abs(lat2);
    }

    public static double toDegrees(double meters) {
        return meters / 1852.0 / 60.0;
    }

    public static int computeBearing(Position p1, Position p2) {
        double dLon = NavCalculator.computeDLong(p1.getLongitude(), p2.getLongitude());
        double y = Math.sin(dLon) * Math.cos(p2.getLatitude());
        double x = Math.cos(p1.getLatitude()) * Math.sin(p2.getLatitude()) - Math.sin(p1.getLatitude()) * Math.cos(p2.getLatitude()) * Math.cos(dLon);
        int bearing = (int)Math.toDegrees(Math.atan2(y, x));
        return bearing;
    }

    public static int computeAngle(Position p1, Position p2) {
        double adj = Math.abs(p1.getLongitude() - p2.getLongitude());
        double opp = Math.abs(p1.getLatitude() - p2.getLatitude());
        return (int)Math.toDegrees(Math.atan(opp / adj));
    }

    public static int computeHeading(Position p1, Position p2) {
        int angle = NavCalculator.computeAngle(p1, p2);
        if (p2.getLongitude() >= p1.getLongitude() && p2.getLatitude() >= p1.getLatitude()) {
            return angle;
        }
        if (p2.getLongitude() >= p1.getLongitude() && p2.getLatitude() <= p1.getLatitude()) {
            return 90 + angle;
        }
        if (p2.getLongitude() <= p1.getLongitude() && p2.getLatitude() <= p1.getLatitude()) {
            return 270 - angle;
        }
        return 270 + angle;
    }

    public static void main(String[] args) {
        try {
            int pos = NavCalculator.computeHeading(new Position(0.0, 0.0), new Position(10.0, -10.0));
            System.out.println(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Quadrant {
        private static final Quadrant FIRST = new Quadrant(1, 1);
        private static final Quadrant SECOND = new Quadrant(-1, 1);
        private static final Quadrant THIRD = new Quadrant(-1, -1);
        private static final Quadrant FOURTH = new Quadrant(1, -1);
        private final int lonMultiplier;
        private final int latMultiplier;

        public Quadrant(int xMultiplier, int yMultiplier) {
            this.lonMultiplier = xMultiplier;
            this.latMultiplier = yMultiplier;
        }

        static Quadrant getQuadrant(double degrees, boolean invert) {
            if (invert) {
                if (degrees >= 0.0 && degrees <= 90.0) {
                    return FOURTH;
                }
                if (degrees > 90.0 && degrees <= 180.0) {
                    return THIRD;
                }
                if (degrees > 180.0 && degrees <= 270.0) {
                    return SECOND;
                }
                return FIRST;
            }
            if (degrees >= 0.0 && degrees <= 90.0) {
                return FIRST;
            }
            if (degrees > 90.0 && degrees <= 180.0) {
                return SECOND;
            }
            if (degrees > 180.0 && degrees <= 270.0) {
                return THIRD;
            }
            return FOURTH;
        }
    }
}

