/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.IndexedField;
import com.simsilica.es.PersistentComponent;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.TileId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMapMarker
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(CustomMapMarker.class);
    private int iconId;
    private int size;
    private int pinSize;
    @IndexedField
    private long tileId;

    private CustomMapMarker() {
    }

    public CustomMapMarker(int iconId, int size, int pinSize, long tileId) {
        this.iconId = iconId;
        this.size = size;
        this.pinSize = pinSize;
        this.tileId = tileId;
    }

    public static CustomMapMarker create(String icon, int size, int pinSize, Vec3d pos, EntityData ed) {
        int id = ed.getStrings().getStringId(icon, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(icon, true);
        }
        TileId tileId = TileId.fromWorld((Vec3d)pos);
        return new CustomMapMarker(id, size, pinSize, tileId.getId());
    }

    public CustomMapMarker changePosition(Vec3d pos) {
        TileId tileId = TileId.fromWorld((Vec3d)pos);
        return new CustomMapMarker(this.iconId, this.size, this.pinSize, tileId.getId());
    }

    public CustomMapMarker changeSize(int size) {
        return new CustomMapMarker(this.iconId, size, this.pinSize, this.tileId);
    }

    public CustomMapMarker changePinSize(int pinSize) {
        return new CustomMapMarker(this.iconId, this.size, pinSize, this.tileId);
    }

    public int getIconId() {
        return this.iconId;
    }

    public String getIconName(EntityData ed) {
        if (this.iconId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.iconId);
    }

    public int getSize() {
        return this.size;
    }

    public int getPinSize() {
        return this.pinSize;
    }

    public long getTileId() {
        return this.tileId;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.iconId) : this.getIconName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("iconId", (Object)s).add("size", this.size).add("pinSize", this.pinSize).add("tileId", this.tileId).toString();
    }
}

