/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainTypes {
    static Logger log = LoggerFactory.getLogger(TerrainTypes.class);
    public static final byte TYPE_SAND = 0;
    public static final byte TYPE_DIRT = 1;
    public static final byte TYPE_STONE1 = 2;
    public static final byte TYPE_STONE2 = 3;
    public static final byte TYPE_STONE3 = 4;
    public static final byte TYPE_STONE4 = 5;
    public static final byte TYPE_STONE5 = 6;
    public static final byte TYPE_ICE = 7;
    public static final byte FOLIAGE0 = 0;
    public static final byte FOLIAGE1 = 8;
    public static final byte FOLIAGE2 = 16;
    public static final byte FOLIAGE3 = 24;
    public static final byte WET0 = 0;
    public static final byte WET1 = 32;
    public static final byte WET2 = 64;
    public static final byte WET3 = 96;
    public static final byte FROZEN = -128;

    public static int getBaseType(int type) {
        return type & 7;
    }

    public static byte setBaseType(int value, int newType) {
        int result = value & 0xFFFFFFF8;
        return (byte)(result |= newType & 7);
    }

    public static int getFoliageLevel(int type) {
        return (type & 0x18) >> 3;
    }

    public static byte setFoliageLevel(byte type, int level) {
        int result = type & 0xFFFFFFE7;
        return (byte)(result |= (level & 3) << 3);
    }

    public static int getWetnessLevel(int type) {
        return (type & 0x60) >> 5;
    }

    public static byte setWetnessLevel(byte type, int level) {
        int result = type & 0xFFFFFF9F;
        return (byte)(result |= (level & 3) << 5);
    }

    public static boolean isFrozen(int type) {
        return (type & 0xFFFFFF80) != 0;
    }

    public static byte setFrozen(int type, int frozen) {
        int result = type & 0x7F;
        return (byte)(result |= frozen & 0xFFFFFF80);
    }
}

